/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

class CharacterSetAL32UTF8
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 4};

    CharacterSetAL32UTF8(int n) {
        super(n);
        this.rep = 6;
    }

    public boolean isLossyFrom(CharacterSet characterSet) {
        return !characterSet.isUnicode();
    }

    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = characterSet.rep <= 1024;
        return bl;
    }

    public boolean isUnicode() {
        return true;
    }

    public String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n2};
            int n3 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n, cArray, 0, nArray, true);
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            return "";
        }
    }

    public String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int[] nArray = new int[]{n2};
            int n3 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n, cArray, 0, nArray, false);
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            CharacterSetAL32UTF8.failUTFConversion();
            return "";
        }
    }

    public byte[] convertWithReplacement(String string) {
        return CharacterSetAL32UTF8.stringToAL32UTF8(string);
    }

    public byte[] convert(String string) throws SQLException {
        return CharacterSetAL32UTF8.stringToAL32UTF8(string);
    }

    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 6) {
            byArray2 = CharacterSetAL32UTF8.useOrCopy(byArray, n, n2);
        } else {
            String string = characterSet.toString(byArray, n, n2);
            byArray2 = CharacterSetAL32UTF8.stringToAL32UTF8(string);
        }
        return byArray2;
    }

    int decode(CharacterWalker characterWalker) throws SQLException {
        byte by;
        int n;
        byte[] byArray = characterWalker.bytes;
        int n2 = characterWalker.next;
        int n3 = characterWalker.end;
        if (n2 >= n3) {
            CharacterSetAL32UTF8.failUTFConversion();
        }
        if ((n = CharacterSetAL32UTF8.getUTFByteLength(by = byArray[n2])) == 0 || n2 + (n - 1) >= n3) {
            CharacterSetAL32UTF8.failUTFConversion();
        }
        try {
            char[] cArray = new char[2];
            int[] nArray = new int[]{n};
            int n4 = CharacterSet.convertAL32UTF8BytesToJavaChars(byArray, n2, cArray, 0, nArray, false);
            characterWalker.next += n;
            if (n4 == 1) {
                return cArray[0];
            }
            return cArray[0] << 16 | cArray[1];
        }
        catch (SQLException sQLException) {
            CharacterSetAL32UTF8.failUTFConversion();
            return 0;
        }
    }

    void encode(CharacterBuffer characterBuffer, int n) throws SQLException {
        int n2;
        if ((n & 0xFFFF0000) != 0) {
            CharacterSetAL32UTF8.need(characterBuffer, 4);
            char[] cArray = new char[]{(char)(n >>> 16), (char)n};
            n2 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 2);
        } else {
            CharacterSetAL32UTF8.need(characterBuffer, 3);
            char[] cArray = new char[]{(char)n};
            n2 = CharacterSet.convertJavaCharsToAL32UTF8Bytes(cArray, 0, characterBuffer.bytes, characterBuffer.next, 1);
        }
        characterBuffer.next += n2;
    }

    private static int getUTFByteLength(byte by) {
        return m_byteLen[by >>> 4 & 0xF];
    }
}

