/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.driver.BaseResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleResultSetMetaData;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.driver.ScrollableResultSet;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

class UpdatableResultSet
extends BaseResultSet {
    static final int s_concurrencyType = 1008;
    static final int s_beginColumnIndex = 1;
    PhysicalConnection m_conn;
    OracleResultSet m_rset;
    boolean m_isCachedRset;
    ScrollRsetStatement m_scrollStmt;
    ResultSetMetaData m_metadata;
    private int m_type;
    private int m_columnCount;
    private OraclePreparedStatement m_deleteStmt;
    private OraclePreparedStatement m_insertStmt;
    private OraclePreparedStatement m_updateStmt;
    private int[] m_idxColsChanged;
    private Object[] m_rowBuffer;
    private boolean[] m_nullIndicator;
    private int[][] m_typeInfo;
    private boolean m_isInserting;
    private boolean m_isUpdating;
    private int m_wasNull;
    private static final int VALUE_NULL = 1;
    private static final int VALUE_NOT_NULL = 2;
    private static final int VALUE_UNKNOWN = 3;
    private static final int VALUE_IN_RSET = 4;
    private static final int ASCII_STREAM = 1;
    private static final int BINARY_STREAM = 2;
    private static final int UNICODE_STREAM = 3;
    private static int _MIN_STREAM_SIZE = 4000;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, ScrollableResultSet scrollableResultSet, int n, int n2) throws SQLException {
        this.init(scrollRsetStatement, scrollableResultSet, n, n2);
        scrollableResultSet.resetBeginColumnIndex();
        this.m_isCachedRset = true;
    }

    UpdatableResultSet(ScrollRsetStatement scrollRsetStatement, OracleResultSetImpl oracleResultSetImpl, int n, int n2) throws SQLException {
        this.init(scrollRsetStatement, oracleResultSetImpl, n, n2);
        this.m_isCachedRset = false;
    }

    private void init(ScrollRsetStatement scrollRsetStatement, OracleResultSet oracleResultSet, int n, int n2) throws SQLException {
        if (scrollRsetStatement == null || oracleResultSet == null || n2 != 1008) {
            DatabaseError.throwSqlException(68);
        }
        this.m_conn = (PhysicalConnection)scrollRsetStatement.getConnection();
        this.m_rset = oracleResultSet;
        this.m_scrollStmt = scrollRsetStatement;
        this.m_type = n;
        this.m_autoRefetch = scrollRsetStatement.getAutoRefetch();
        this.m_deleteStmt = null;
        this.m_insertStmt = null;
        this.m_updateStmt = null;
        this.m_idxColsChanged = null;
        this.m_rowBuffer = null;
        this.m_nullIndicator = null;
        this.m_typeInfo = null;
        this.m_isInserting = false;
        this.m_isUpdating = false;
        this.m_wasNull = -1;
        this.m_metadata = null;
        this.m_columnCount = 0;
    }

    public synchronized void close() throws SQLException {
        if (this.m_rset != null) {
            this.m_rset.close();
        }
        if (this.m_insertStmt != null) {
            this.m_insertStmt.close();
        }
        if (this.m_updateStmt != null) {
            this.m_updateStmt.close();
        }
        if (this.m_deleteStmt != null) {
            this.m_deleteStmt.close();
        }
        if (this.m_scrollStmt != null) {
            this.m_scrollStmt.notify_close_rset();
        }
        this.cancelRowInserts();
        this.m_conn = null;
        this.m_rset = null;
        this.m_scrollStmt = null;
        this.m_metadata = null;
        this.m_scrollStmt = null;
        this.m_deleteStmt = null;
        this.m_insertStmt = null;
        this.m_updateStmt = null;
        this.m_idxColsChanged = null;
        this.m_rowBuffer = null;
        this.m_nullIndicator = null;
        this.m_typeInfo = null;
    }

    public synchronized boolean wasNull() throws SQLException {
        switch (this.m_wasNull) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 4: {
                return this.m_rset.wasNull();
            }
        }
        DatabaseError.throwSqlException(24);
        return false;
    }

    int getFirstUserColumnIndex() {
        return 1;
    }

    public synchronized Statement getStatement() throws SQLException {
        return (Statement)((Object)this.m_scrollStmt);
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = this.m_rset.getWarnings();
        if (this.m_warning == null) {
            return sQLWarning;
        }
        SQLWarning sQLWarning2 = this.m_warning;
        while (sQLWarning2.getNextWarning() != null) {
            sQLWarning2 = sQLWarning2.getNextWarning();
        }
        sQLWarning2.setNextWarning(sQLWarning);
        return this.m_warning;
    }

    public void clearWarnings() throws SQLException {
        this.m_warning = null;
        this.m_rset.clearWarnings();
    }

    public synchronized boolean next() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.next();
    }

    public synchronized boolean isBeforeFirst() throws SQLException {
        return this.m_rset.isBeforeFirst();
    }

    public synchronized boolean isAfterLast() throws SQLException {
        return this.m_rset.isAfterLast();
    }

    public synchronized boolean isFirst() throws SQLException {
        return this.m_rset.isFirst();
    }

    public synchronized boolean isLast() throws SQLException {
        return this.m_rset.isLast();
    }

    public synchronized void beforeFirst() throws SQLException {
        this.cancelRowChanges();
        this.m_rset.beforeFirst();
    }

    public synchronized void afterLast() throws SQLException {
        this.cancelRowChanges();
        this.m_rset.afterLast();
    }

    public synchronized boolean first() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.first();
    }

    public synchronized boolean last() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.last();
    }

    public synchronized int getRow() throws SQLException {
        return this.m_rset.getRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean absolute(int n) throws SQLException {
        PhysicalConnection physicalConnection = this.m_conn;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                this.cancelRowChanges();
                return this.m_rset.absolute(n);
            }
        }
    }

    public synchronized boolean relative(int n) throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.relative(n);
    }

    public synchronized boolean previous() throws SQLException {
        this.cancelRowChanges();
        return this.m_rset.previous();
    }

    public synchronized Datum getOracleObject(int n) throws SQLException {
        Datum datum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            this.setIsNull(datum == null);
            datum = this.getRowBufferDatumAt(n);
        } else {
            this.setIsNull(4);
            datum = this.m_rset.getOracleObject(n + 1);
        }
        return datum;
    }

    public synchronized String getString(int n) throws SQLException {
        String string = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                string = datum.stringValue();
            }
        } else {
            this.setIsNull(4);
            string = this.m_rset.getString(n + 1);
        }
        return string;
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                bl = datum.booleanValue();
            }
        } else {
            this.setIsNull(4);
            bl = this.m_rset.getBoolean(n + 1);
        }
        return bl;
    }

    public synchronized byte getByte(int n) throws SQLException {
        byte by = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                by = datum.byteValue();
            }
        } else {
            this.setIsNull(4);
            by = this.m_rset.getByte(n + 1);
        }
        return by;
    }

    public synchronized short getShort(int n) throws SQLException {
        short s = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            long l = this.getLong(n);
            if (l > 65537L || l < -65538L) {
                DatabaseError.check_error(26, "getShort");
            }
            s = (short)l;
        } else {
            this.setIsNull(4);
            s = this.m_rset.getShort(n + 1);
        }
        return s;
    }

    public synchronized int getInt(int n) throws SQLException {
        int n2 = 0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                n2 = datum.intValue();
            }
        } else {
            this.setIsNull(4);
            n2 = this.m_rset.getInt(n + 1);
        }
        return n2;
    }

    public synchronized long getLong(int n) throws SQLException {
        long l = 0L;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                l = datum.longValue();
            }
        } else {
            this.setIsNull(4);
            l = this.m_rset.getLong(n + 1);
        }
        return l;
    }

    public synchronized float getFloat(int n) throws SQLException {
        float f = 0.0f;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                f = datum.floatValue();
            }
        } else {
            this.setIsNull(4);
            f = this.m_rset.getFloat(n + 1);
        }
        return f;
    }

    public synchronized double getDouble(int n) throws SQLException {
        double d = 0.0;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                d = datum.doubleValue();
            }
        } else {
            this.setIsNull(4);
            d = this.m_rset.getDouble(n + 1);
        }
        return d;
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.m_rset.getBigDecimal(n + 1);
        }
        return bigDecimal;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                byArray = datum.getBytes();
            }
        } else {
            this.setIsNull(4);
            byArray = this.m_rset.getBytes(n + 1);
        }
        return byArray;
    }

    public synchronized Date getDate(int n) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                date = datum.dateValue();
            }
        } else {
            this.setIsNull(4);
            date = this.m_rset.getDate(n + 1);
        }
        return date;
    }

    public synchronized Time getTime(int n) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                time = datum.timeValue();
            }
        } else {
            this.setIsNull(4);
            time = this.m_rset.getTime(n + 1);
        }
        return time;
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                timestamp = datum.timestampValue();
            }
        } else {
            this.setIsNull(4);
            timestamp = this.m_rset.getTimestamp(n + 1);
        }
        return timestamp;
    }

    public synchronized InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    inputStream = datum.asciiStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.m_rset.getAsciiStream(n + 1);
        }
        return inputStream;
    }

    public synchronized InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    DBConversion dBConversion = this.m_conn.conversion;
                    byte[] byArray = datum.shareBytes();
                    if (datum instanceof RAW) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                    } else if (datum instanceof CHAR) {
                        inputStream = dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                    } else {
                        DatabaseError.check_error(4, "getUnicodeStream");
                    }
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.m_rset.getUnicodeStream(n + 1);
        }
        return inputStream;
    }

    public synchronized InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof InputStream) {
                    inputStream = (InputStream)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    inputStream = datum.binaryStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            inputStream = this.m_rset.getBinaryStream(n + 1);
        }
        return inputStream;
    }

    public synchronized Object getObject(int n) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.m_rset.getObject(n + 1);
        }
        return object;
    }

    public synchronized Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Object object = this.getRowBufferAt(n);
            this.setIsNull(object == null);
            if (object != null) {
                if (object instanceof Reader) {
                    reader = (Reader)object;
                } else {
                    Datum datum = this.getRowBufferDatumAt(n);
                    reader = datum.characterStreamValue();
                }
            }
        } else {
            this.setIsNull(4);
            reader = this.m_rset.getCharacterStream(n + 1);
        }
        return reader;
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                bigDecimal = datum.bigDecimalValue();
            }
        } else {
            this.setIsNull(4);
            bigDecimal = this.m_rset.getBigDecimal(n + 1);
        }
        return bigDecimal;
    }

    public synchronized Object getObject(int n, Map map) throws SQLException {
        Object object = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(map) : datum.toJdbc();
            }
        } else {
            this.setIsNull(4);
            object = this.m_rset.getObject(n + 1, map);
        }
        return object;
    }

    public synchronized Ref getRef(int n) throws SQLException {
        return this.getREF(n);
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        return this.getBLOB(n);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        return this.getCLOB(n);
    }

    public synchronized Array getArray(int n) throws SQLException {
        return this.getARRAY(n);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    date = ((DATE)datum).dateValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        date = dATE.dateValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            date = this.m_rset.getDate(n + 1, calendar);
        }
        return date;
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    time = ((DATE)datum).timeValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        time = dATE.timeValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            time = this.m_rset.getTime(n + 1, calendar);
        }
        return time;
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            if (datum != null) {
                if (datum instanceof DATE) {
                    timestamp = ((DATE)datum).timestampValue(calendar);
                } else {
                    DATE dATE = new DATE(datum.stringValue());
                    if (dATE != null) {
                        timestamp = dATE.timestampValue(calendar);
                    }
                }
            }
        } else {
            this.setIsNull(4);
            timestamp = this.m_rset.getTimestamp(n + 1, calendar);
        }
        return timestamp;
    }

    public synchronized URL getURL(int n) throws SQLException {
        URL uRL = null;
        int n2 = this.getInternalMetadata().getColumnType(n);
        int n3 = SQLUtil.get_internal_type(n2);
        if (n3 == 96 || n3 == 1 || n3 == 8) {
            try {
                uRL = new URL(this.getString(n));
            }
            catch (MalformedURLException malformedURLException) {
                DatabaseError.throwSqlException(136);
            }
        } else {
            throw new SQLException("Conversion to java.net.URL not supported.");
        }
        return uRL;
    }

    public synchronized ResultSet getCursor(int n) throws SQLException {
        ResultSet resultSet = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getOracleObject(n);
            this.setIsNull(datum == null);
            DatabaseError.check_error(4, "getCursor");
        } else {
            this.setIsNull(4);
            resultSet = this.m_rset.getCursor(n + 1);
        }
        return resultSet;
    }

    public synchronized ROWID getROWID(int n) throws SQLException {
        ROWID rOWID = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ROWID)) {
                DatabaseError.check_error(4, "getROWID");
            }
            rOWID = (ROWID)datum;
        } else {
            this.setIsNull(4);
            rOWID = this.m_rset.getROWID(n + 1);
        }
        return rOWID;
    }

    public synchronized NUMBER getNUMBER(int n) throws SQLException {
        NUMBER nUMBER = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof NUMBER)) {
                DatabaseError.check_error(4, "getNUMBER");
            }
            nUMBER = (NUMBER)datum;
        } else {
            this.setIsNull(4);
            nUMBER = this.m_rset.getNUMBER(n + 1);
        }
        return nUMBER;
    }

    public synchronized DATE getDATE(int n) throws SQLException {
        DATE dATE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof DATE)) {
                DatabaseError.check_error(4, "getDATE");
            }
            dATE = (DATE)datum;
        } else {
            this.setIsNull(4);
            dATE = this.m_rset.getDATE(n + 1);
        }
        return dATE;
    }

    public synchronized TIMESTAMP getTIMESTAMP(int n) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMP)) {
                DatabaseError.check_error(4, "getTIMESTAMP");
            }
            tIMESTAMP = (TIMESTAMP)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMP = this.m_rset.getTIMESTAMP(n + 1);
        }
        return tIMESTAMP;
    }

    public synchronized TIMESTAMPTZ getTIMESTAMPTZ(int n) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMPTZ)) {
                DatabaseError.check_error(4, "getTIMESTAMPTZ");
            }
            tIMESTAMPTZ = (TIMESTAMPTZ)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMPTZ = this.m_rset.getTIMESTAMPTZ(n + 1);
        }
        return tIMESTAMPTZ;
    }

    public synchronized TIMESTAMPLTZ getTIMESTAMPLTZ(int n) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof TIMESTAMPLTZ)) {
                DatabaseError.check_error(4, "getTIMESTAMPLTZ");
            }
            tIMESTAMPLTZ = (TIMESTAMPLTZ)datum;
        } else {
            this.setIsNull(4);
            tIMESTAMPLTZ = this.m_rset.getTIMESTAMPLTZ(n + 1);
        }
        return tIMESTAMPLTZ;
    }

    public synchronized INTERVALDS getINTERVALDS(int n) throws SQLException {
        INTERVALDS iNTERVALDS = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof INTERVALDS)) {
                DatabaseError.check_error(4, "getINTERVALDS");
            }
            iNTERVALDS = (INTERVALDS)datum;
        } else {
            this.setIsNull(4);
            iNTERVALDS = this.m_rset.getINTERVALDS(n + 1);
        }
        return iNTERVALDS;
    }

    public synchronized INTERVALYM getINTERVALYM(int n) throws SQLException {
        INTERVALYM iNTERVALYM = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof INTERVALYM)) {
                DatabaseError.check_error(4, "getINTERVALYM");
            }
            iNTERVALYM = (INTERVALYM)datum;
        } else {
            this.setIsNull(4);
            iNTERVALYM = this.m_rset.getINTERVALYM(n + 1);
        }
        return iNTERVALYM;
    }

    public synchronized ARRAY getARRAY(int n) throws SQLException {
        ARRAY aRRAY = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof ARRAY)) {
                DatabaseError.check_error(4, "getARRAY");
            }
            aRRAY = (ARRAY)datum;
        } else {
            this.setIsNull(4);
            aRRAY = this.m_rset.getARRAY(n + 1);
        }
        return aRRAY;
    }

    public synchronized STRUCT getSTRUCT(int n) throws SQLException {
        STRUCT sTRUCT = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof STRUCT)) {
                DatabaseError.check_error(4, "getSTRUCT");
            }
            sTRUCT = (STRUCT)datum;
        } else {
            this.setIsNull(4);
            sTRUCT = this.m_rset.getSTRUCT(n + 1);
        }
        return sTRUCT;
    }

    public synchronized OPAQUE getOPAQUE(int n) throws SQLException {
        OPAQUE oPAQUE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof OPAQUE)) {
                DatabaseError.check_error(4, "getOPAQUE");
            }
            oPAQUE = (OPAQUE)datum;
        } else {
            this.setIsNull(4);
            oPAQUE = this.m_rset.getOPAQUE(n + 1);
        }
        return oPAQUE;
    }

    public synchronized REF getREF(int n) throws SQLException {
        REF rEF = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof REF)) {
                DatabaseError.check_error(4, "getREF");
            }
            rEF = (REF)datum;
        } else {
            this.setIsNull(4);
            rEF = this.m_rset.getREF(n + 1);
        }
        return rEF;
    }

    public synchronized CHAR getCHAR(int n) throws SQLException {
        CHAR cHAR = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CHAR)) {
                DatabaseError.check_error(4, "getCHAR");
            }
            cHAR = (CHAR)datum;
        } else {
            this.setIsNull(4);
            cHAR = this.m_rset.getCHAR(n + 1);
        }
        return cHAR;
    }

    public synchronized RAW getRAW(int n) throws SQLException {
        RAW rAW = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof RAW)) {
                DatabaseError.check_error(4, "getRAW");
            }
            rAW = (RAW)datum;
        } else {
            this.setIsNull(4);
            rAW = this.m_rset.getRAW(n + 1);
        }
        return rAW;
    }

    public synchronized BLOB getBLOB(int n) throws SQLException {
        BLOB bLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BLOB)) {
                DatabaseError.check_error(4, "getBLOB");
            }
            bLOB = (BLOB)datum;
        } else {
            this.setIsNull(4);
            bLOB = this.m_rset.getBLOB(n + 1);
        }
        return bLOB;
    }

    public synchronized CLOB getCLOB(int n) throws SQLException {
        CLOB cLOB = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof CLOB)) {
                DatabaseError.check_error(4, "getCLOB");
            }
            cLOB = (CLOB)datum;
        } else {
            this.setIsNull(4);
            cLOB = this.m_rset.getCLOB(n + 1);
        }
        return cLOB;
    }

    public synchronized BFILE getBFILE(int n) throws SQLException {
        BFILE bFILE = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            if (datum != null && !(datum instanceof BFILE)) {
                DatabaseError.check_error(4, "getBFILE");
            }
            bFILE = (BFILE)datum;
        } else {
            this.setIsNull(4);
            bFILE = this.m_rset.getBFILE(n + 1);
        }
        return bFILE;
    }

    public synchronized BFILE getBfile(int n) throws SQLException {
        return this.getBFILE(n);
    }

    public synchronized CustomDatum getCustomDatum(int n, CustomDatumFactory customDatumFactory) throws SQLException {
        if (customDatumFactory == null) {
            DatabaseError.throwSqlException(68);
        }
        CustomDatum customDatum = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            customDatum = customDatumFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            customDatum = this.m_rset.getCustomDatum(n + 1, customDatumFactory);
        }
        return customDatum;
    }

    public synchronized ORAData getORAData(int n, ORADataFactory oRADataFactory) throws SQLException {
        if (oRADataFactory == null) {
            DatabaseError.throwSqlException(68);
        }
        ORAData oRAData = null;
        this.setIsNull(3);
        if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(n)) {
            Datum datum = this.getRowBufferDatumAt(n);
            this.setIsNull(datum == null);
            oRAData = oRADataFactory.create(datum, 0);
        } else {
            this.setIsNull(4);
            oRAData = this.m_rset.getORAData(n + 1, oRADataFactory);
        }
        return oRAData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSetMetaData getMetaData() throws SQLException {
        if (((OracleStatement)this.m_scrollStmt).closed) {
            DatabaseError.check_error(9, "getMetaData");
        }
        PhysicalConnection physicalConnection = this.m_conn;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                return new OracleResultSetMetaData(this.m_conn, (OracleStatement)this.m_scrollStmt, 1);
            }
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        return this.m_rset.findColumn(string) - 1;
    }

    public synchronized void setFetchDirection(int n) throws SQLException {
        this.m_rset.setFetchDirection(n);
    }

    public synchronized int getFetchDirection() throws SQLException {
        return this.m_rset.getFetchDirection();
    }

    public synchronized void setFetchSize(int n) throws SQLException {
        this.m_rset.setFetchSize(n);
    }

    public synchronized int getFetchSize() throws SQLException {
        return this.m_rset.getFetchSize();
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public int getConcurrency() throws SQLException {
        return 1008;
    }

    public boolean rowUpdated() throws SQLException {
        return false;
    }

    public boolean rowInserted() throws SQLException {
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        return false;
    }

    public synchronized void insertRow() throws SQLException {
        if (!this.isOnInsertRow()) {
            DatabaseError.throwSqlException(83);
        }
        this.prepare_insertRow_statement();
        this.prepare_insertRow_binds();
        this.execute_insertRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLException {
        PhysicalConnection physicalConnection = this.m_conn;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                int n;
                if (this.isOnInsertRow()) {
                    DatabaseError.throwSqlException(84);
                }
                if ((n = this.get_num_columns_changed()) > 0) {
                    this.prepare_updateRow_statement(n);
                    this.prepare_updateRow_binds(n);
                    this.execute_updateRow();
                }
            }
        }
    }

    public synchronized void deleteRow() throws SQLException {
        if (this.isOnInsertRow()) {
            DatabaseError.throwSqlException(84);
        }
        this.prepare_deleteRow_statement();
        this.prepare_deleteRow_binds();
        this.execute_deleteRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRow() throws SQLException {
        PhysicalConnection physicalConnection = this.m_conn;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                if (this.isOnInsertRow()) {
                    DatabaseError.throwSqlException(84);
                }
                this.m_rset.refreshRow();
            }
        }
    }

    public synchronized void cancelRowUpdates() throws SQLException {
        if (this.m_isUpdating) {
            this.m_isUpdating = false;
            this.clearRowBuffer();
        }
    }

    public synchronized void moveToInsertRow() throws SQLException {
        if (this.isOnInsertRow()) {
            return;
        }
        this.m_isInserting = true;
        if (this.m_rowBuffer == null) {
            this.m_rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
        }
        this.clearRowBuffer();
    }

    public synchronized void moveToCurrentRow() throws SQLException {
        this.cancelRowInserts();
    }

    public synchronized void updateString(int n, String string) throws SQLException {
        this.updateObject(n, (Object)string);
    }

    public synchronized void updateNull(int n) throws SQLException {
        this.setRowBufferAt(n, null);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateObject(n, (Object)new Boolean(bl));
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateObject(n, (Object)new Integer(by));
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateObject(n, (Object)new Integer(s));
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateObject(n, (Object)new Integer(n2));
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateObject(n, (Object)new Long(l));
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateObject(n, (Object)new Float(f));
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateObject(n, (Object)new Double(d));
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateObject(n, (Object)bigDecimal);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateObject(n, (Object)byArray);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateObject(n, (Object)date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateObject(n, (Object)time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateObject(n, (Object)timestamp);
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.getInternalMetadata().getColumnType(1 + n);
        if (inputStream != null && n2 > 0) {
            if (!this.isStreamType(n3)) {
                byte[] byArray = new byte[n2];
                try {
                    int n4 = inputStream.read(byArray);
                    inputStream.close();
                    String string = new String(byArray, 0, n4);
                    this.updateString(n, string);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n2, 1};
                this.setRowBufferAt(n, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n, null);
        }
    }

    final boolean isStreamType(int n) {
        return n == 2004 || n == 2005 || n == -4 || n == -1;
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        int n3 = this.getInternalMetadata().getColumnType(1 + n);
        if (inputStream != null && n2 > 0) {
            if (!this.isStreamType(n3)) {
                byte[] byArray = new byte[n2];
                try {
                    int n4 = inputStream.read(byArray);
                    inputStream.close();
                    this.updateBytes(n, byArray);
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n2, 2};
                this.setRowBufferAt(n, inputStream, nArray);
            }
        } else {
            this.setRowBufferAt(n, null);
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        int n3 = this.getInternalMetadata().getColumnType(1 + n);
        if (reader != null && n2 > 0) {
            if (!this.isStreamType(n3)) {
                char[] cArray = new char[n2];
                try {
                    int n4 = reader.read(cArray);
                    reader.close();
                    this.updateString(n, new String(cArray));
                }
                catch (IOException iOException) {
                    DatabaseError.throwSqlException(iOException);
                }
            } else {
                int[] nArray = new int[]{n2};
                this.setRowBufferAt(n, reader, nArray);
            }
        } else {
            this.setRowBufferAt(n, null);
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.updateObject(n, object);
    }

    public synchronized void updateObject(int n, Object object) throws SQLException {
        Datum datum = null;
        if (object != null) {
            datum = object instanceof Datum ? (Datum)object : SQLUtil.makeOracleDatum(this.m_conn, object, this.getInternalMetadata().getColumnType(n + 1), null);
        }
        this.setRowBufferAt(n, datum);
    }

    public synchronized void updateOracleObject(int n, Datum datum) throws SQLException {
        this.setRowBufferAt(n, datum);
    }

    public void updateROWID(int n, ROWID rOWID) throws SQLException {
        this.updateOracleObject(n, (Datum)rOWID);
    }

    public void updateNUMBER(int n, NUMBER nUMBER) throws SQLException {
        this.updateOracleObject(n, (Datum)nUMBER);
    }

    public void updateDATE(int n, DATE dATE) throws SQLException {
        this.updateOracleObject(n, (Datum)dATE);
    }

    public void updateINTERVALYM(int n, INTERVALYM iNTERVALYM) throws SQLException {
        this.updateOracleObject(n, (Datum)iNTERVALYM);
    }

    public void updateINTERVALDS(int n, INTERVALDS iNTERVALDS) throws SQLException {
        this.updateOracleObject(n, (Datum)iNTERVALDS);
    }

    public void updateTIMESTAMP(int n, TIMESTAMP tIMESTAMP) throws SQLException {
        this.updateOracleObject(n, (Datum)tIMESTAMP);
    }

    public void updateTIMESTAMPTZ(int n, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.updateOracleObject(n, (Datum)tIMESTAMPTZ);
    }

    public void updateTIMESTAMPLTZ(int n, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        this.updateOracleObject(n, (Datum)tIMESTAMPLTZ);
    }

    public void updateARRAY(int n, ARRAY aRRAY) throws SQLException {
        this.updateOracleObject(n, (Datum)aRRAY);
    }

    public void updateSTRUCT(int n, STRUCT sTRUCT) throws SQLException {
        this.updateOracleObject(n, (Datum)sTRUCT);
    }

    public void updateOPAQUE(int n, OPAQUE oPAQUE) throws SQLException {
        this.updateOracleObject(n, (Datum)oPAQUE);
    }

    public void updateREF(int n, REF rEF) throws SQLException {
        this.updateOracleObject(n, (Datum)rEF);
    }

    public void updateCHAR(int n, CHAR cHAR) throws SQLException {
        this.updateOracleObject(n, (Datum)cHAR);
    }

    public void updateRAW(int n, RAW rAW) throws SQLException {
        this.updateOracleObject(n, (Datum)rAW);
    }

    public void updateBLOB(int n, BLOB bLOB) throws SQLException {
        this.updateOracleObject(n, (Datum)bLOB);
    }

    public void updateCLOB(int n, CLOB cLOB) throws SQLException {
        this.updateOracleObject(n, (Datum)cLOB);
    }

    public void updateBFILE(int n, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n, (Datum)bFILE);
    }

    public void updateBfile(int n, BFILE bFILE) throws SQLException {
        this.updateOracleObject(n, (Datum)bFILE);
    }

    public void updateCustomDatum(int n, CustomDatum customDatum) throws SQLException {
        throw new Error("wanna do datum = ((CustomDatum) x).toDatum(m_comm)");
    }

    public void updateORAData(int n, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.m_conn);
        this.updateOracleObject(n, datum);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateREF(n, (REF)ref);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateBLOB(n, (BLOB)blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateCLOB(n, (CLOB)clob);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateARRAY(n, (ARRAY)array);
    }

    int getColumnCount() throws SQLException {
        if (this.m_columnCount == 0) {
            this.m_columnCount = this.m_rset instanceof OracleResultSetImpl ? (((OracleResultSetImpl)this.m_rset).statement.accessors != null ? ((OracleResultSetImpl)this.m_rset).statement.number_of_define_positions : this.getInternalMetadata().getColumnCount()) : ((ScrollableResultSet)this.m_rset).getColumnCount();
        }
        return this.m_columnCount;
    }

    ResultSetMetaData getInternalMetadata() throws SQLException {
        if (this.m_metadata == null) {
            this.m_metadata = this.m_rset.getMetaData();
        }
        return this.m_metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void cancelRowChanges() throws SQLException {
        PhysicalConnection physicalConnection = this.m_conn;
        synchronized (physicalConnection) {
            UpdatableResultSet updatableResultSet = this;
            synchronized (updatableResultSet) {
                if (this.m_isInserting) {
                    this.cancelRowInserts();
                }
                if (this.m_isUpdating) {
                    this.cancelRowUpdates();
                }
            }
        }
    }

    boolean isOnInsertRow() {
        return this.m_isInserting;
    }

    private void cancelRowInserts() {
        if (this.m_isInserting) {
            this.m_isInserting = false;
            this.clearRowBuffer();
        }
    }

    boolean isUpdatingRow() {
        return this.m_isUpdating;
    }

    private void clearRowBuffer() {
        int n;
        if (this.m_rowBuffer != null) {
            for (n = 0; n < this.m_rowBuffer.length; ++n) {
                this.m_rowBuffer[n] = null;
            }
        }
        if (this.m_nullIndicator != null) {
            for (n = 0; n < this.m_nullIndicator.length; ++n) {
                this.m_nullIndicator[n] = false;
            }
        }
        if (this.m_typeInfo != null) {
            for (n = 0; n < this.m_typeInfo.length; ++n) {
                if (this.m_typeInfo[n] == null) continue;
                for (int i = 0; i < this.m_typeInfo[n].length; ++i) {
                    this.m_typeInfo[n][i] = 0;
                }
            }
        }
    }

    private void setRowBufferAt(int n, Datum datum) throws SQLException {
        this.setRowBufferAt(n, datum, null);
    }

    private void setRowBufferAt(int n, Object object, int[] nArray) throws SQLException {
        if (!this.m_isInserting) {
            if (this.isBeforeFirst() || this.isAfterLast() || this.getRow() == 0) {
                DatabaseError.throwSqlException(82);
            } else {
                this.m_isUpdating = true;
            }
        }
        if (n < 1 || n > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "setRowBufferAt");
        }
        if (this.m_rowBuffer == null) {
            this.m_rowBuffer = new Object[this.getColumnCount()];
        }
        if (this.m_nullIndicator == null) {
            this.m_nullIndicator = new boolean[this.getColumnCount()];
            for (int i = 0; i < this.getColumnCount(); ++i) {
                this.m_nullIndicator[i] = false;
            }
        }
        if (nArray != null) {
            if (this.m_typeInfo == null) {
                this.m_typeInfo = new int[this.getColumnCount()][];
            }
            this.m_typeInfo[n] = nArray;
        }
        this.m_rowBuffer[n] = object;
        this.m_nullIndicator[n] = object == null;
    }

    private Datum getRowBufferDatumAt(int n) throws SQLException {
        Object object;
        if (n < 1 || n > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "getRowBufferDatumAt");
        }
        Datum datum = null;
        if (this.m_rowBuffer != null && (object = this.m_rowBuffer[n]) != null) {
            if (object instanceof Datum) {
                datum = (Datum)object;
            } else {
                datum = SQLUtil.makeOracleDatum(this.m_conn, object, this.getInternalMetadata().getColumnType(n + 1), null);
                this.m_rowBuffer[n] = datum;
            }
        }
        return datum;
    }

    private Object getRowBufferAt(int n) throws SQLException {
        if (n < 1 || n > this.getColumnCount() - 1) {
            DatabaseError.throwSqlException(68, "getRowBufferDatumAt");
        }
        if (this.m_rowBuffer != null) {
            return this.m_rowBuffer[n];
        }
        return null;
    }

    private boolean isRowBufferUpdatedAt(int n) {
        if (this.m_rowBuffer == null) {
            return false;
        }
        return this.m_rowBuffer[n] != null || this.m_nullIndicator[n];
    }

    private void prepare_insertRow_statement() throws SQLException {
        if (this.m_insertStmt == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.m_insertStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(((OracleStatement)this.m_scrollStmt).m_sql.getInsertSqlForUpdatableResultSet(this));
            this.m_insertStmt.setQueryTimeout(((Statement)((Object)this.m_scrollStmt)).getQueryTimeout());
        }
    }

    private void prepare_insertRow_binds() throws SQLException {
        int n = 1;
        n = this.prepare_subquery_binds(this.m_insertStmt, n);
        for (int i = 1; i < this.getColumnCount(); ++i) {
            Object object = this.getRowBufferAt(i);
            if (object != null) {
                if (object instanceof Reader) {
                    this.m_insertStmt.setCharacterStream(n + i - 1, (Reader)object, this.m_typeInfo[i][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.m_typeInfo[i][1] == 2) {
                        this.m_insertStmt.setBinaryStream(n + i - 1, (InputStream)object, this.m_typeInfo[i][0]);
                        continue;
                    }
                    if (this.m_typeInfo[i][1] != 1) continue;
                    this.m_insertStmt.setAsciiStream(n + i - 1, (InputStream)object, this.m_typeInfo[i][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(i);
                this.m_insertStmt.setOracleObject(n + i - 1, datum);
                continue;
            }
            int n2 = this.getInternalMetadata().getColumnType(i + 1);
            if (n2 == 2006 || n2 == 2002 || n2 == 2008 || n2 == 2007 || n2 == 2003) {
                this.m_insertStmt.setNull(n + i - 1, n2, this.getInternalMetadata().getColumnTypeName(i + 1));
                continue;
            }
            this.m_insertStmt.setNull(n + i - 1, n2);
        }
    }

    private void execute_insertRow() throws SQLException {
        if (this.m_insertStmt.executeUpdate() != 1) {
            DatabaseError.throwSqlException(85);
        }
    }

    private int get_num_columns_changed() throws SQLException {
        int n = 0;
        if (this.m_idxColsChanged == null) {
            this.m_idxColsChanged = new int[this.getColumnCount()];
        }
        if (this.m_rowBuffer != null) {
            for (int i = 1; i < this.getColumnCount(); ++i) {
                if (this.m_rowBuffer[i] == null && (this.m_rowBuffer[i] != null || !this.m_nullIndicator[i])) continue;
                this.m_idxColsChanged[n++] = i;
            }
        }
        return n;
    }

    private void prepare_updateRow_statement(int n) throws SQLException {
        if (this.m_updateStmt != null) {
            this.m_updateStmt.close();
        }
        this.m_updateStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(((OracleStatement)this.m_scrollStmt).m_sql.getUpdateSqlForUpdatableResultSet(this, n, this.m_rowBuffer, this.m_idxColsChanged));
        this.m_updateStmt.setQueryTimeout(((Statement)((Object)this.m_scrollStmt)).getQueryTimeout());
    }

    private void prepare_updateRow_binds(int n) throws SQLException {
        int n2 = 1;
        n2 = this.prepare_subquery_binds(this.m_updateStmt, n2);
        for (int i = 0; i < n; ++i) {
            int n3 = this.m_idxColsChanged[i];
            Object object = this.getRowBufferAt(n3);
            if (object != null) {
                if (object instanceof Reader) {
                    this.m_updateStmt.setCharacterStream(n2++, (Reader)object, this.m_typeInfo[n3][0]);
                    continue;
                }
                if (object instanceof InputStream) {
                    if (this.m_typeInfo[n3][1] == 2) {
                        this.m_updateStmt.setBinaryStream(n2++, (InputStream)object, this.m_typeInfo[n3][0]);
                        continue;
                    }
                    if (this.m_typeInfo[n3][1] != 1) continue;
                    this.m_updateStmt.setAsciiStream(n2++, (InputStream)object, this.m_typeInfo[n3][0]);
                    continue;
                }
                Datum datum = this.getRowBufferDatumAt(n3);
                this.m_updateStmt.setOracleObject(n2++, datum);
                continue;
            }
            int n4 = this.getInternalMetadata().getColumnType(n3 + 1);
            if (n4 == 2006 || n4 == 2002 || n4 == 2008 || n4 == 2007 || n4 == 2003) {
                this.m_updateStmt.setNull(n2++, n4, this.getInternalMetadata().getColumnTypeName(n3 + 1));
                continue;
            }
            this.m_updateStmt.setNull(n2++, n4);
        }
        this.prepare_compare_self_binds(this.m_updateStmt, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void execute_updateRow() throws SQLException {
        try {
            if (this.m_updateStmt.executeUpdate() == 0) {
                DatabaseError.throwSqlException(85);
            }
            if (this.m_isCachedRset) {
                if (this.m_autoRefetch) {
                    ((ScrollableResultSet)this.m_rset).refreshRowsInCache(this.getRow(), 1, 1000);
                    this.cancelRowUpdates();
                } else {
                    if (this.m_rowBuffer != null) {
                        for (int i = 1; i < this.getColumnCount(); ++i) {
                            if (this.m_rowBuffer[i] == null && (this.m_rowBuffer[i] != null || !this.m_nullIndicator[i])) continue;
                            ((ScrollableResultSet)this.m_rset).setCurrentRowValueAt(this, i + 1, this.m_rowBuffer[i]);
                        }
                    }
                    this.cancelRowUpdates();
                }
            }
            Object var3_2 = null;
            if (this.m_updateStmt == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.m_updateStmt == null) throw throwable;
            this.m_updateStmt.close();
            this.m_updateStmt = null;
            throw throwable;
        }
        this.m_updateStmt.close();
        this.m_updateStmt = null;
    }

    private void prepare_deleteRow_statement() throws SQLException {
        if (this.m_deleteStmt == null) {
            this.m_deleteStmt = (OraclePreparedStatement)this.m_conn.prepareStatement(((OracleStatement)this.m_scrollStmt).m_sql.getDeleteSqlForUpdatableResultSet(this));
            this.m_deleteStmt.setQueryTimeout(((Statement)((Object)this.m_scrollStmt)).getQueryTimeout());
        }
    }

    private void prepare_deleteRow_binds() throws SQLException {
        int n = 1;
        n = this.prepare_subquery_binds(this.m_deleteStmt, n);
        this.prepare_compare_self_binds(this.m_deleteStmt, n);
    }

    private void execute_deleteRow() throws SQLException {
        if (this.m_deleteStmt.executeUpdate() == 0) {
            DatabaseError.throwSqlException(85);
        }
        if (this.m_isCachedRset) {
            ((ScrollableResultSet)this.m_rset).removeRowInCache(this.getRow());
        }
    }

    private int prepare_compare_self_binds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        Datum datum = this.m_rset.getOracleObject(1);
        oraclePreparedStatement.setOracleObject(n, this.m_rset.getOracleObject(1));
        return n + 1;
    }

    private int prepare_subquery_binds(OraclePreparedStatement oraclePreparedStatement, int n) throws SQLException {
        int n2 = this.m_scrollStmt.copyBinds(oraclePreparedStatement, n - 1);
        return n2 + 1;
    }

    private void setIsNull(int n) {
        this.m_wasNull = n;
    }

    private void setIsNull(boolean bl) {
        this.m_wasNull = bl ? 1 : 2;
    }
}

