/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.sql.OPAQUE;
import oracle.xdb.XDBError;
import oracle.xdb.XMLType;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBBinaryDocument;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContextFactory;
import oracle.xdb.spi.XDBNameParser;
import oracle.xdb.spi.XDBNamingEnumeration;
import oracle.xdb.spi.XDBResource;

public class XDBResourceContext
extends XDBResource
implements Context {
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    private static final char NAME_ABSOLUTE_PREFIX = '/';
    public static final long RES_OBJ = 1L;
    public static final int OBJ_CONTAINER = 0;
    public static final int OBJ_DOCUMENT = 1;
    public static final int OBJ_BINARY_DOC = 2;
    private static final int NO_ERROR = 0;
    private static final int NOT_CONTAINER_ERROR = 1;
    private static final int NOT_FOUND_ERROR = 2;
    private static final int NOT_DONE = 3;
    private static final int INVALID_HANDLE = 4;
    private static final int ENTRY_EXISTS_ERROR = 5;
    private static final int OTHER_ERROR = 6;
    private static final int INV_RESHDL_OR_PATH_ERR = 31001;
    private static final int NOT_CONT_ERR = 31002;
    private static final int ENTRY_EXISTS_ERR = 31003;
    private static final int DBBLKSIZE_TOO_SMALL_ERR = 31004;
    private static final int PATHNAME_TOO_LONG_ERR = 31005;
    private static final int PATH_SEGMENT_TOO_LONG_ERR = 31006;
    private static final int DEL_NONEMPTY_CONT_ERR = 31007;
    private static final int XDB_SPI_UNBIND_CONTEXT_ERR = 1;
    private static final int XDB_SPI_ENUM_EMPTY_ERR = 3;
    protected static XDBNameParser s_parser = new XDBNameParser();
    protected String m_path;
    protected Hashtable m_env;
    private int m_conntype;
    protected XDBElement m_resElem;

    public XDBResourceContext(Hashtable env) throws NamingException, OperationNotSupportedException, SQLException {
        super((Connection)env.get(XDBContextFactory.ENV_CONNECTION), (String)env.get("java.naming.provider.url"), 0L);
        Locale l = null;
        Hashtable hashtable = this.m_env = env != null ? (Hashtable)env.clone() : null;
        if (env != null) {
            String language = (String)env.get("Language");
            String country = (String)env.get("Country");
            this.m_path = (String)env.get("java.naming.provider.url");
            l = language == null || country == null ? Locale.getDefault() : new Locale(language, country);
        } else {
            l = Locale.getDefault();
        }
        this.m_conntype = XMLType.getConnType(this.m_conn);
        long[] cstate = new long[2];
        long retVal = 0L;
        cstate[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? 1L : 0L;
        switch (this.m_conntype) {
            case 2: {
                retVal = this.lookupKprbNative(this.m_path, cstate);
                this.m_xobcstate = cstate[1];
                break;
            }
            case 1: {
                retVal = this.lookupThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), this.m_path, cstate);
                this.m_xobcstate = cstate[1];
                break;
            }
            case 0: {
                throw new OperationNotSupportedException(XDBError.getMsg("THIN_NOT_SUPPORTED"));
            }
        }
        if (retVal != 0L) {
            this.throwException(retVal, this.m_path);
        }
        if (this.m_xobcstate == 0L) {
            System.out.println("lookup is null");
        }
        this.m_resElem = (XDBElement)this.getDocumentElement();
    }

    public XDBResourceContext(Hashtable env, String path, long cstate) throws NamingException, OperationNotSupportedException, SQLException {
        super((Connection)env.get(XDBContextFactory.ENV_CONNECTION), path, cstate);
        Locale l = null;
        this.m_env = env != null ? (Hashtable)env.clone() : null;
        this.addToEnvironment("java.naming.provider.url", path);
        if (env != null) {
            String language = (String)env.get("Language");
            String country = (String)env.get("Country");
            l = language == null || country == null ? Locale.getDefault() : new Locale(language, country);
        } else {
            l = Locale.getDefault();
        }
        this.m_path = path;
        this.m_conntype = XMLType.getConnType(this.m_conn);
        this.m_xobcstate = cstate;
        this.m_resElem = (XDBElement)this.getDocumentElement();
    }

    public Object addToEnvironment(String propName, Object propVal) {
        if (this.m_env == null) {
            this.m_env = new Hashtable();
        }
        return this.m_env.put(propName, propVal);
    }

    public void bind(String name, Object obj) throws NamingException {
        long retVal = 0L;
        long bindobjcstate = 0L;
        boolean isres = false;
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        if (obj instanceof XMLTypeBean) {
            XDBDocument doc = (XDBDocument)((XMLTypeBean)obj).getOwnerDocument();
            bindobjcstate = doc.toCState();
        } else if (obj instanceof XDBDocument) {
            bindobjcstate = ((XDBDocument)obj).toCState();
        } else if (obj instanceof XDBResource || obj instanceof XDBResourceContext) {
            isres = true;
            bindobjcstate = ((XDBDocument)obj).toCState();
        } else if (obj instanceof String) {
            ByteArrayInputStream is = new ByteArrayInputStream(((String)obj).getBytes());
            bindobjcstate = this.createBinaryDocFromInputStream(is);
        } else if (obj instanceof InputStream) {
            bindobjcstate = this.createBinaryDocFromInputStream((InputStream)obj);
        } else if (obj instanceof File) {
            try {
                FileInputStream fs = new FileInputStream((File)obj);
                bindobjcstate = this.createBinaryDocFromInputStream(fs);
            }
            catch (FileNotFoundException ex) {
                throw new CannotProceedException(ex.toString());
            }
        } else {
            throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
        String abspath = this.makeAbsoluteName(name, this.m_path);
        switch (this.m_conntype) {
            case 2: {
                retVal = this.bindKprbNative(abspath, bindobjcstate, isres);
                break;
            }
            case 1: {
                retVal = this.bindThick(abspath, bindobjcstate, isres);
                break;
            }
        }
        if (retVal != 0L) {
            this.throwException(retVal, name);
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.bind(name.toString(), obj);
    }

    private native long bindKprbNative(String var1, long var2, boolean var4);

    private long bindThick(String path, long bindobjcstate, boolean isres) {
        String bindStr = "declare retb boolean; begin retb := dbms_xdb.createResource(?, ?); end;";
        long retVal = 0L;
        try {
            OracleCallableStatement s = (OracleCallableStatement)this.m_conn.prepareCall(bindStr);
            XDBDocument xd = new XDBDocument(this.m_conn, bindobjcstate);
            XMLType xt = new XMLType(this.m_conn, xd);
            s.setString(1, path);
            s.setOPAQUE(2, (OPAQUE)xt);
            s.execute();
            s.close();
        }
        catch (Exception exception) {
            retVal = 2L;
        }
        return retVal;
    }

    public void close() {
        this.m_env = null;
        this.m_path = null;
    }

    public String composeName(String name, String prefix) {
        if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) == '/') {
            return String.valueOf(prefix) + name;
        }
        return String.valueOf(prefix) + NAME_COMPONENT_SEPARATOR + name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private long createBinaryDocFromInputStream(InputStream is) throws NamingException {
        buf = new byte[1024];
        stream = 0L;
        off = 0;
        docCState = 0L;
        try {
            objlen = is.available();
            switch (this.m_conntype) {
                case 2: {
                    gp = XDBResource.getServerEnv();
                    if (true) ** GOTO lbl16
                }
                default: {
                    throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
                }
            }
            do {
                stream = this.writeToStreamNative(gp, stream, objlen, buf, off, nread);
                off += buf.length;
lbl16:
                // 2 sources

            } while ((nread = is.read(buf)) != -1);
            docCState = this.createBinaryFromStreamNative(gp, stream);
        }
        catch (Exception ex) {
            throw new CannotProceedException(ex.toString());
        }
        return docCState;
    }

    private native long createBinaryFromStreamNative(long var1, long var3);

    private native long createSubKprbNative(String var1);

    private long createSubThick(String path, long[] cState) {
        String createSubStr = "declare retb boolean; begin retb := dbms_xdb.createFolder(?); end;";
        long retVal = 0L;
        try {
            OracleCallableStatement s = (OracleCallableStatement)this.m_conn.prepareCall(createSubStr);
            s.setString(1, path);
            s.execute();
            s.close();
            retVal = 0L;
            long[] localcState = new long[2];
            localcState[0] = 1L;
            retVal = this.lookupThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), path, localcState);
            cState[0] = localcState[1];
        }
        catch (Exception e) {
            retVal = e instanceof SQLException ? (long)((SQLException)e).getErrorCode() : 2L;
        }
        return retVal;
    }

    public Context createSubcontext(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String abspath = this.makeAbsoluteName(name, this.m_path);
        long retVal = 0L;
        switch (this.m_conntype) {
            case 2: {
                long[] cState = new long[1];
                retVal = this.createSubKprbNative(abspath);
                if (retVal != 0L) {
                    this.throwException(retVal, name);
                }
                try {
                    return new XDBResourceContext(this.m_env, abspath, cState[0]);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            case 1: {
                long[] cState = new long[1];
                retVal = this.createSubThick(abspath, cState);
                if (retVal != 0L) {
                    this.throwException(retVal, name);
                }
                try {
                    return new XDBResourceContext(this.m_env, abspath, cState[0]);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
        }
        return null;
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.createSubcontext(name.toString());
    }

    private native long destroySubKprbNative(String var1);

    private long destroySubThick(String path) {
        return this.unbindThick(path);
    }

    public void destroySubcontext(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String abspath = this.makeAbsoluteName(name, this.m_path);
        long retVal = 0L;
        switch (this.m_conntype) {
            case 2: {
                retVal = this.destroySubKprbNative(abspath);
                if (retVal == 0L) break;
                this.throwException(retVal, name);
                break;
            }
            case 1: {
                retVal = this.destroySubThick(abspath);
                if (retVal == 0L) break;
                this.throwException(retVal, name);
                break;
            }
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.destroySubcontext(name.toString());
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.m_env == null) {
            return new Hashtable();
        }
        return (Hashtable)this.m_env.clone();
    }

    public String getNameInNamespace() throws NamingException {
        return this.m_path;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return s_parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public static native String getSchemaNameNative(long var0, String[] var2);

    public NamingEnumeration list(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String abspath = this.makeAbsoluteName(name, this.m_path);
        long retVal = 0L;
        long[] cState = new long[1];
        switch (this.m_conntype) {
            case 2: {
                retVal = this.listKprbNative(abspath, cState);
                if (retVal != 0L) {
                    this.throwException(retVal, name);
                }
                try {
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, cState[0], abspath, XDBNamingEnumeration.NAMING_TYPE_NAMECLASS);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            case 1: {
                try {
                    retVal = this.listThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), abspath, cState);
                    if (retVal != 0L) {
                        this.throwException(retVal, name);
                    }
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, cState[0], abspath, XDBNamingEnumeration.NAMING_TYPE_NAMECLASS);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
        }
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String abspath = this.makeAbsoluteName(name, this.m_path);
        long retVal = 0L;
        switch (this.m_conntype) {
            case 2: {
                long[] cState = new long[1];
                retVal = this.listKprbNative(abspath, cState);
                if (retVal != 0L) {
                    this.throwException(retVal, name);
                }
                try {
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, cState[0], abspath, XDBNamingEnumeration.NAMING_TYPE_NAMEBINDING);
                }
                catch (SQLException sQLException) {
                    return null;
                }
            }
            case 1: {
                long[] cState = new long[1];
                try {
                    retVal = this.listThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), abspath, cState);
                    if (retVal != 0L) {
                        this.throwException(retVal, name);
                    }
                    return new XDBNamingEnumeration(this.m_env, this.m_conn, cState[0], abspath, XDBNamingEnumeration.NAMING_TYPE_NAMEBINDING);
                }
                catch (SQLException sQLException) {
                    break;
                }
            }
        }
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.listBindings(name.toString());
    }

    private native long listKprbNative(String var1, long[] var2);

    private native long listThickNative(long var1, long var3, String var5, long[] var6);

    public Object lookup(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String absName = this.makeAbsoluteName(name, this.m_path);
        switch (this.m_conntype) {
            case 1: 
            case 2: {
                long[] cstate = new long[2];
                long retVal = 0L;
                cstate[0] = this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE ? 1L : 0L;
                try {
                    retVal = this.m_conntype == 2 ? this.lookupKprbNative(absName, cstate) : this.lookupThickNative(XMLType.getServiceHandle(this.m_conn, this.m_conntype), XMLType.getErrorHandle(this.m_conn, this.m_conntype), absName, cstate);
                }
                catch (SQLException sQLException) {}
                if (retVal != 0L) {
                    this.throwException(retVal, name);
                }
                if (cstate[0] == 0L) {
                    try {
                        return new XDBResourceContext(this.m_env, absName, cstate[1]);
                    }
                    catch (SQLException sQLException) {
                        return null;
                    }
                }
                if (this.m_env.get(XDBContextFactory.RETURN_OBJECT_TYPE) == XDBContextFactory.RETURN_TYPE_RESOURCE) {
                    return new XDBResource(this.m_conn, absName, cstate[1]);
                }
                if (cstate[0] == 2L) {
                    XDBBinaryDocument xtype = new XDBBinaryDocument(this.m_conn, cstate[1]);
                    return xtype;
                }
                XDBDocument xtype = new XDBDocument(this.m_conn, cstate[1]);
                String[] usrName = new String[1];
                if (this.m_conntype == 1) {
                    return xtype;
                }
                String classname = XDBResourceContext.getSchemaNameNative(xtype.toCState(), usrName);
                if (classname == null) {
                    return xtype;
                }
                try {
                    Object obj = DbmsJava.classForNameAndSchema((String)classname, (String)usrName[0].toUpperCase()).newInstance();
                    XMLTypeBean newobj = (XMLTypeBean)obj;
                    newobj.setOwner(xtype);
                    newobj.setKidNum(0L);
                    newobj.setXobCstate(((XDBNode)((Object)xtype.getDocumentElement())).toCState());
                    return newobj;
                }
                catch (Exception exception) {
                    return xtype;
                }
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException();
        }
        return this.lookup(name.toString());
    }

    private native long lookupKprbNative(String var1, long[] var2);

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        return this.lookup(name.toString());
    }

    private native long lookupThickNative(long var1, long var3, String var5, long[] var6);

    private String makeAbsoluteName(String name, String prefix) throws NamingException {
        if (name.charAt(0) == '/') {
            return name;
        }
        return this.composeName(name, prefix);
    }

    public void rebind(String name, Object obj) throws NamingException {
        try {
            this.unbind(name);
        }
        catch (Exception exception) {}
        this.bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.rebind(name.toString(), obj);
    }

    public Object removeFromEnvironment(String propName) {
        if (this.m_env == null) {
            return null;
        }
        return this.m_env.remove(propName);
    }

    public void rename(String oldname, String newname) throws NamingException {
        if (oldname == null || oldname.length() == 0 || newname == null || newname.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String absoldname = this.makeAbsoluteName(oldname, this.m_path);
        String absnewname = this.makeAbsoluteName(newname, this.m_path);
        long retVal = 0L;
        switch (this.m_conntype) {
            case 2: {
                retVal = this.renameKprbNative(absoldname, absnewname);
                break;
            }
            case 1: {
                retVal = this.renameThick(absoldname, absnewname);
                break;
            }
        }
        if (retVal != 0L) {
            this.throwException(retVal, oldname);
        }
    }

    public void rename(Name oldname, Name newname) throws NamingException {
        if (oldname == null || newname == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.rename(oldname.toString(), newname.toString());
    }

    private native long renameKprbNative(String var1, String var2);

    private long renameThick(String oldPath, String newPath) {
        String renStr = "begin dbms_xdb.renameResource(?, ?, ?); end;";
        long retVal = 0L;
        try {
            OracleCallableStatement s = (OracleCallableStatement)this.m_conn.prepareCall(renStr);
            Name newName = s_parser.parse(newPath);
            String newNameStr = newName.get(newName.size() - 1);
            Name destFolder = newName.getPrefix(newName.size() - 1);
            String destFolderStr = destFolder.toString();
            s.setString(1, oldPath);
            s.setString(2, destFolderStr);
            s.setString(3, newNameStr);
            s.execute();
            s.close();
        }
        catch (Exception e) {
            retVal = e instanceof SQLException ? (long)((SQLException)e).getErrorCode() : 2L;
        }
        return retVal;
    }

    private void throwException(long errCode, String path) throws NameNotFoundException, NotContextException, NameAlreadyBoundException, NamingException, ContextNotEmptyException, NoSuchElementException, RuntimeException {
        switch ((int)errCode) {
            case 2: 
            case 31001: {
                throw new NameNotFoundException(path);
            }
            case 31002: {
                throw new NotContextException(path);
            }
            case 31003: {
                throw new NameAlreadyBoundException(path);
            }
            case 31005: {
                throw new NamingException(String.valueOf(path) + " " + XDBError.getMsg("PATH_TOO_LONG"));
            }
            case 31006: {
                throw new NamingException(String.valueOf(path) + " " + XDBError.getMsg("PATH_ELEM_TOO_LONG"));
            }
            case 31007: {
                throw new ContextNotEmptyException(path);
            }
            case 1: {
                throw new NamingException(String.valueOf(path) + " " + XDBError.getMsg("CANT_UNBIND_SUBCONTEXT"));
            }
            case 3: {
                throw new NoSuchElementException(XDBError.getMsg("END_OF_ENUM"));
            }
        }
        throw new RuntimeException(path);
    }

    public void unbind(String name) throws NamingException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        String abspath = this.makeAbsoluteName(name, this.m_path);
        long retVal = 0L;
        switch (this.m_conntype) {
            case 2: {
                retVal = this.unbindKprbNative(abspath);
                break;
            }
            case 1: {
                retVal = this.unbindThick(abspath);
                break;
            }
        }
        if (retVal != 0L) {
            this.throwException(retVal, name);
        }
    }

    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException(XDBError.getMsg("EMPTY_PATH_ERROR"));
        }
        this.unbind(name.toString());
    }

    private native long unbindKprbNative(String var1);

    private long unbindThick(String path) {
        String unbindStr = "begin dbms_xdb.deleteResource(?); end;";
        long retVal = 0L;
        try {
            OracleCallableStatement s = (OracleCallableStatement)this.m_conn.prepareCall(unbindStr);
            s.setString(1, path);
            s.execute();
            s.close();
        }
        catch (Exception e) {
            retVal = e instanceof SQLException ? (long)((SQLException)e).getErrorCode() : 2L;
        }
        return retVal;
    }

    private native long writeToStreamNative(long var1, long var3, int var5, byte[] var6, int var7, int var8);
}

