/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import com.jezhumble.javasysmon.ProcessInfo;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LinuxProcessInfoParser {
    private final String stat;
    private final String status;
    private final String cmdline;
    private final HashMap uids;
    private final int userHz;
    private static final Pattern STATUS_NAME_MATCHER = Pattern.compile("Name:\\s+(\\w+)", 8);
    private static final Pattern STATUS_UID_MATCHER = Pattern.compile("Uid:\\s+(\\d+)\\s.*", 8);
    private static final Pattern STATUS_VM_SIZE_MATCHER = Pattern.compile("VmSize:\\s+(\\d+) kB", 8);
    private static final Pattern STATUS_VM_RSS_MATCHER = Pattern.compile("VmRSS:\\s+(\\d+) kB", 8);

    public LinuxProcessInfoParser(String stat, String status, String cmdline, HashMap uids, int userHz) {
        this.stat = stat;
        this.status = status;
        this.cmdline = cmdline;
        this.uids = uids;
        this.userHz = userHz;
    }

    public ProcessInfo parse() {
        String[] statElements = this.stat.split(" ");
        return new ProcessInfo(Integer.parseInt(statElements[0]), Integer.parseInt(statElements[3]), this.trim(this.cmdline), this.getFirstMatch(STATUS_NAME_MATCHER, this.status), (String)this.uids.get(this.getFirstMatch(STATUS_UID_MATCHER, this.status)), Long.parseLong(statElements[13]) * (long)(1000 / this.userHz), Long.parseLong(statElements[14]) * (long)(1000 / this.userHz), Long.parseLong(this.getFirstMatch(STATUS_VM_RSS_MATCHER, this.status)) * 1024L, Long.parseLong(this.getFirstMatch(STATUS_VM_SIZE_MATCHER, this.status)) * 1024L);
    }

    private String trim(String cmdline) {
        return cmdline.replace('\u0000', ' ').replace('\n', ' ');
    }

    public String getFirstMatch(Pattern pattern, String string) {
        try {
            Matcher matcher = pattern.matcher(string);
            matcher.find();
            return matcher.group(1);
        }
        catch (Exception e) {
            return "0";
        }
    }
}

