/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.video.mpeg4.div3;

import javax.media.Buffer;

public class DisplayOutput {
    private int[] luminance;
    private int[] red;
    private int[] blue;
    private int[] oldLuminance;
    private int[] oldRed;
    private int[] oldBlue;
    private int screenX;
    private int screenY;
    private int chromX;
    private int chromY;
    private static final int W1 = 22725;
    private static final int W2 = 21407;
    private static final int W3 = 19266;
    private static final int W4 = 16383;
    private static final int W5 = 12873;
    private static final int W6 = 8867;
    private static final int W7 = 4520;
    private static final int ROW_SHIFT = 11;
    private static final int COL_SHIFT = 20;
    private int displayX;
    private int displayY;
    private int[] displayArray;

    private static final void idctRowCondDC(int[] nArray, int n) {
        int n2 = nArray[n];
        int n3 = nArray[n + 1];
        int n4 = nArray[n + 2];
        int n5 = nArray[n + 3];
        int n6 = nArray[n + 4];
        int n7 = nArray[n + 5];
        int n8 = nArray[n + 6];
        int n9 = nArray[n + 7];
        if ((n3 | n4 | n5 | n6 | n7 | n8 | n9) == 0) {
            nArray[n] = n2 <<= 3;
            nArray[n + 1] = n2;
            nArray[n + 2] = n2;
            nArray[n + 3] = n2;
            nArray[n + 4] = n2;
            nArray[n + 5] = n2;
            nArray[n + 6] = n2;
            nArray[n + 7] = n2;
            return;
        }
        int n10 = 16383 * n2 + 1024;
        int n11 = n10 + 8867 * n4 - 16383 * n6 - 21407 * n8;
        int n12 = n10 - 8867 * n4 - 16383 * n6 + 21407 * n8;
        int n13 = n10 - 21407 * n4 + 16383 * n6 - 8867 * n8;
        int n14 = 22725 * n3 + 19266 * n5 + 12873 * n7 + 4520 * n9;
        int n15 = 19266 * n3 - 4520 * n5 - 22725 * n7 - 12873 * n9;
        int n16 = 12873 * n3 - 22725 * n5 + 4520 * n7 + 19266 * n9;
        int n17 = 4520 * n3 - 12873 * n5 + 19266 * n7 - 22725 * n9;
        nArray[n + 0] = (n10 += 21407 * n4 + 16383 * n6 + 8867 * n8) + n14 >> 11;
        nArray[n + 7] = n10 - n14 >> 11;
        nArray[n + 1] = n11 + n15 >> 11;
        nArray[n + 6] = n11 - n15 >> 11;
        nArray[n + 2] = n12 + n16 >> 11;
        nArray[n + 5] = n12 - n16 >> 11;
        nArray[n + 3] = n13 + n17 >> 11;
        nArray[n + 4] = n13 - n17 >> 11;
    }

    private static void idctSparseColAdd(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = nArray[n];
        int n5 = nArray[n + 8];
        int n6 = nArray[n + 16];
        int n7 = nArray[n + 24];
        int n8 = nArray[n + 32];
        int n9 = nArray[n + 40];
        int n10 = nArray[n + 48];
        int n11 = nArray[n + 56];
        int n12 = 16383 * n4 + 524288;
        int n13 = n12 + 8867 * n6 - 16383 * n8 - 21407 * n10;
        int n14 = n12 - 8867 * n6 - 16383 * n8 + 21407 * n10;
        int n15 = n12 - 21407 * n6 + 16383 * n8 - 8867 * n10;
        int n16 = 22725 * n5 + 19266 * n7 + 12873 * n9 + 4520 * n11;
        int n17 = 19266 * n5 - 4520 * n7 - 22725 * n9 - 12873 * n11;
        int n18 = 12873 * n5 - 22725 * n7 + 4520 * n9 + 19266 * n11;
        int n19 = 4520 * n5 - 12873 * n7 + 19266 * n9 - 22725 * n11;
        nArray2[n2 += n] = DisplayOutput.crop(nArray2[n2] + ((n12 += 21407 * n6 + 16383 * n8 + 8867 * n10) + n16 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n13 + n17 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n14 + n18 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n15 + n19 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n15 - n19 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n14 - n18 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n13 - n17 >> 20));
        nArray2[n2 += n3] = DisplayOutput.crop(nArray2[n2] + (n12 - n16 >> 20));
    }

    public final void idctAdd(int[] nArray, int[] nArray2, int n, int n2) {
        DisplayOutput.idctRowCondDC(nArray, 0);
        DisplayOutput.idctRowCondDC(nArray, 8);
        DisplayOutput.idctRowCondDC(nArray, 16);
        DisplayOutput.idctRowCondDC(nArray, 24);
        DisplayOutput.idctRowCondDC(nArray, 32);
        DisplayOutput.idctRowCondDC(nArray, 40);
        DisplayOutput.idctRowCondDC(nArray, 48);
        DisplayOutput.idctRowCondDC(nArray, 56);
        DisplayOutput.idctSparseColAdd(nArray, 0, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 1, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 2, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 3, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 4, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 5, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 6, nArray2, n, n2);
        DisplayOutput.idctSparseColAdd(nArray, 7, nArray2, n, n2);
    }

    private static void idctSparseColPut(int[] nArray, int n, int[] nArray2, int n2, int n3) {
        int n4 = nArray[n];
        int n5 = nArray[n + 8];
        int n6 = nArray[n + 16];
        int n7 = nArray[n + 24];
        int n8 = nArray[n + 32];
        int n9 = nArray[n + 40];
        int n10 = nArray[n + 48];
        int n11 = nArray[n + 56];
        int n12 = 16383 * n4 + 524288;
        int n13 = n12 + 8867 * n6 - 16383 * n8 - 21407 * n10;
        int n14 = n12 - 8867 * n6 - 16383 * n8 + 21407 * n10;
        int n15 = n12 - 21407 * n6 + 16383 * n8 - 8867 * n10;
        int n16 = 22725 * n5 + 19266 * n7 + 12873 * n9 + 4520 * n11;
        int n17 = 19266 * n5 - 4520 * n7 - 22725 * n9 - 12873 * n11;
        int n18 = 12873 * n5 - 22725 * n7 + 4520 * n9 + 19266 * n11;
        int n19 = 4520 * n5 - 12873 * n7 + 19266 * n9 - 22725 * n11;
        nArray2[n2 += n] = DisplayOutput.crop((n12 += 21407 * n6 + 16383 * n8 + 8867 * n10) + n16 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n13 + n17 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n14 + n18 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n15 + n19 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n15 - n19 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n14 - n18 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n13 - n17 >> 20);
        nArray2[n2 += n3] = DisplayOutput.crop(n12 - n16 >> 20);
    }

    public final void idctPut(int[] nArray, int[] nArray2, int n, int n2) {
        DisplayOutput.idctRowCondDC(nArray, 0);
        DisplayOutput.idctRowCondDC(nArray, 8);
        DisplayOutput.idctRowCondDC(nArray, 16);
        DisplayOutput.idctRowCondDC(nArray, 24);
        DisplayOutput.idctRowCondDC(nArray, 32);
        DisplayOutput.idctRowCondDC(nArray, 40);
        DisplayOutput.idctRowCondDC(nArray, 48);
        DisplayOutput.idctRowCondDC(nArray, 56);
        DisplayOutput.idctSparseColPut(nArray, 0, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 1, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 2, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 3, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 4, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 5, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 6, nArray2, n, n2);
        DisplayOutput.idctSparseColPut(nArray, 7, nArray2, n, n2);
    }

    public DisplayOutput(int n, int n2) {
        this.displayX = n * 16;
        this.displayY = n2 * 16;
        this.screenX = this.displayX + 32;
        this.screenY = this.displayY + 32;
        this.chromX = this.screenX / 2;
        this.chromY = this.screenY / 2;
        this.luminance = new int[(n += 2) * 16 * (n2 += 2) * 16];
        this.red = new int[n * 8 * n2 * 8];
        this.blue = new int[n * 8 * n2 * 8];
        this.oldLuminance = new int[n * 16 * n2 * 16];
        this.oldRed = new int[n * 8 * n2 * 8];
        this.oldBlue = new int[n * 8 * n2 * 8];
    }

    private static final int crop(int n) {
        if ((n & 0xFF) == n) {
            return n;
        }
        if (n < 0) {
            n = 0;
        } else if (n > 255) {
            n = 255;
        }
        return n;
    }

    public final void putLuminanceIdct(int n, int n2, int[] nArray) {
        this.idctPut(nArray, this.luminance, n * 8 + 16 + (n2 * 8 + 16) * this.screenX, this.screenX);
    }

    public final void putRedIdct(int n, int n2, int[] nArray) {
        this.idctPut(nArray, this.red, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    public final void putBlueIdct(int n, int n2, int[] nArray) {
        this.idctPut(nArray, this.blue, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    public final void addLuminanceIdct(int n, int n2, int[] nArray) {
        this.idctAdd(nArray, this.luminance, n * 8 + 16 + (n2 * 8 + 16) * this.screenX, this.screenX);
    }

    public final void addRedIdct(int n, int n2, int[] nArray) {
        this.idctAdd(nArray, this.red, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    public final void addBlueIdct(int n, int n2, int[] nArray) {
        this.idctAdd(nArray, this.blue, n * 8 + 8 + (n2 * 8 + 8) * this.chromX, this.chromX);
    }

    private final void blitBlock(int[] nArray, int[] nArray2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        switch (n8) {
            case 0: {
                for (int i = n2; i < n3; ++i) {
                    for (int j = n4; j < n5; ++j) {
                        nArray2[j + i * n] = nArray[j + n6 + (i + n7) * n];
                    }
                }
                break;
            }
            case 1: {
                for (int i = n2; i < n3; ++i) {
                    int n9 = nArray[n4 + n6 + (i + n7) * n];
                    for (int j = n4; j < n5; ++j) {
                        int n10 = n9;
                        n9 = nArray[j + n6 + 1 + (i + n7) * n];
                        nArray2[j + i * n] = bl ? (n10 | n9) - ((n10 ^ n9) >> 1) : (n10 & n9) + ((n10 ^ n9) >> 1);
                    }
                }
                break;
            }
            case 2: {
                for (int i = n4; i < n5; ++i) {
                    int n11 = nArray[i + n6 + (n2 + n7) * n];
                    for (int j = n2; j < n3; ++j) {
                        int n12 = n11;
                        n11 = nArray[i + n6 + (j + n7 + 1) * n];
                        nArray2[i + j * n] = bl ? (n12 | n11) - ((n12 ^ n11) >> 1) : (n12 & n11) + ((n12 ^ n11) >> 1);
                    }
                }
                break;
            }
            default: {
                for (int i = n4; i < n5; ++i) {
                    int n13 = nArray[i + n6 + (n2 + n7) * n] + nArray[i + n6 + 1 + (n2 + n7) * n];
                    for (int j = n2; j < n3; ++j) {
                        int n14 = n13;
                        n13 = nArray[i + n6 + (j + n7 + 1) * n] + nArray[i + n6 + 1 + (j + n7 + 1) * n];
                        nArray2[i + j * n] = bl ? n14 + n13 + 2 >> 2 : n14 + n13 + 1 >> 2;
                    }
                }
            }
        }
    }

    private final int clip(int n, int n2, int n3) {
        if (n + n2 < 0) {
            n = -n2;
        }
        if (n + n2 > n3) {
            n = n3 - n2;
        }
        return n;
    }

    public void move(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n2 * 16 + 16;
        int n6 = n * 16 + 16;
        int n7 = n3 & 1 | (n4 & 1) << 1;
        int n8 = n3 / 2;
        int n9 = n4 / 2;
        if (n3 < 0 && (n7 & 1) == 1) {
            --n8;
        }
        if (n4 < 0 && (n7 & 2) == 2) {
            --n9;
        }
        n6 = this.clip(n6, n8, this.screenX - 16);
        n5 = this.clip(n5, n9, this.screenY - 16);
        int n10 = n6 + 16;
        int n11 = n5 + 16;
        if (n10 + n8 == this.screenX) {
            n7 &= 0xFFFFFFFE;
        }
        if (n11 + n9 == this.screenY) {
            n7 &= 0xFFFFFFFD;
        }
        this.blitBlock(this.oldLuminance, this.luminance, this.screenX, n5, n11, n6, n10, n8, n9, n7, bl);
        n5 = n2 * 8 + 8;
        n6 = n * 8 + 8;
        if ((n3 & 1) != 0) {
            n3 = n3 < 0 ? --n3 : ++n3;
        }
        if ((n4 & 1) != 0) {
            n4 = n4 < 0 ? --n4 : ++n4;
        }
        n7 = n4 & 2 | (n3 & 2) >> 1;
        n8 = n3 / 4;
        n9 = n4 / 4;
        if (n3 < 0 && (n7 & 1) == 1) {
            --n8;
        }
        if (n4 < 0 && (n7 & 2) == 2) {
            --n9;
        }
        n6 = this.clip(n6, n8, this.chromX - 8);
        n5 = this.clip(n5, n9, this.chromY - 8);
        n10 = n6 + 8;
        n11 = n5 + 8;
        if (n10 + n8 == this.chromX) {
            n7 &= 0xFFFFFFFE;
        }
        if (n11 + n9 == this.chromY) {
            n7 &= 0xFFFFFFFD;
        }
        this.blitBlock(this.oldBlue, this.blue, this.chromX, n5, n11, n6, n10, n8, n9, n7, bl);
        this.blitBlock(this.oldRed, this.red, this.chromX, n5, n11, n6, n10, n8, n9, n7, bl);
    }

    public final void endFrame() {
        int n;
        int n2;
        int[] nArray = this.oldLuminance;
        this.oldLuminance = this.luminance;
        this.luminance = nArray;
        nArray = this.oldRed;
        this.oldRed = this.red;
        this.red = nArray;
        nArray = this.oldBlue;
        this.oldBlue = this.blue;
        this.blue = nArray;
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 16; n < this.displayY + 16; ++n) {
                this.oldLuminance[n2 + n * this.screenX] = this.oldLuminance[16 + n * this.screenX];
                this.oldLuminance[this.displayX + 32 - n2 - 1 + n * this.screenX] = this.oldLuminance[this.displayX + 15 + n * this.screenX];
                this.oldBlue[n2 / 2 + n / 2 * this.chromX] = this.oldBlue[8 + n / 2 * this.chromX];
                this.oldBlue[(this.displayX + 32 - n2) / 2 - 1 + n / 2 * this.chromX] = this.oldBlue[(this.displayX + 16) / 2 - 1 + n / 2 * this.chromX];
                this.oldRed[n2 / 2 + n / 2 * this.chromX] = this.oldRed[8 + n / 2 * this.chromX];
                this.oldRed[(this.displayX + 32 - n2) / 2 - 1 + n / 2 * this.chromX] = this.oldRed[(this.displayX + 16) / 2 - 1 + n / 2 * this.chromX];
            }
        }
        for (n2 = 0; n2 < 16; ++n2) {
            for (n = 0; n < this.displayX + 32; ++n) {
                this.oldLuminance[n + n2 * this.screenX] = this.oldLuminance[n + 16 * this.screenX];
                this.oldLuminance[n + (this.displayY + 32 - n2 - 1) * this.screenX] = this.oldLuminance[n + (this.displayY + 15) * this.screenX];
                this.oldBlue[n / 2 + n2 / 2 * this.chromX] = this.oldBlue[n / 2 + 8 * this.chromX];
                this.oldBlue[n / 2 + ((this.displayY + 32 - n2) / 2 - 1) * this.chromX] = this.oldBlue[n / 2 + ((this.displayY + 16) / 2 - 1) * this.chromX];
                this.oldRed[n / 2 + n2 / 2 * this.chromX] = this.oldRed[n / 2 + 8 * this.chromX];
                this.oldRed[n / 2 + ((this.displayY + 32 - n2) / 2 - 1) * this.chromX] = this.oldRed[n / 2 + ((this.displayY + 16) / 2 - 1) * this.chromX];
            }
        }
    }

    public void showScreen(Buffer buffer) {
        int[] nArray = (int[])buffer.getData();
        if (nArray == null || nArray.length < this.displayX * this.displayY) {
            nArray = new int[this.displayX * this.displayY];
            buffer.setData((Object)nArray);
        }
        buffer.setLength(nArray.length);
        int n = 0;
        int n2 = this.displayY + 16;
        int n3 = this.displayX + 16;
        for (int i = 16; i < n2; i += 2) {
            int n4 = this.screenX * i;
            int n5 = this.screenX * (i + 1);
            int n6 = i / 2 * this.chromX;
            int n7 = 8;
            for (int j = 16; j < n3; j += 2) {
                int n8 = DisplayOutput.crop(this.red[n7 + n6]) - 128;
                int n9 = DisplayOutput.crop(this.blue[n7++ + n6]) - 128;
                int n10 = (int)((float)n9 * 0.21292114f + (float)n8 * 0.5325775f);
                n8 = (int)((float)n8 * 1.7929688f);
                n9 = (int)((float)n9 * 2.1126099f);
                int n11 = (int)((float)(this.luminance[j + n4] - 16) * 1.1643829f);
                int n12 = (int)((float)(this.luminance[j + n5] - 16) * 1.1643829f);
                int n13 = (int)((float)(this.luminance[j + 1 + n4] - 16) * 1.1643829f);
                int n14 = (int)((float)(this.luminance[j + 1 + n5] - 16) * 1.1643829f);
                nArray[n] = DisplayOutput.crop(n11 + n8) << 16 | DisplayOutput.crop(n11 - n10) << 8 | DisplayOutput.crop(n11 + n9);
                nArray[n + 1] = DisplayOutput.crop(n13 + n8) << 16 | DisplayOutput.crop(n13 - n10) << 8 | DisplayOutput.crop(n13 + n9);
                nArray[n + this.displayX] = DisplayOutput.crop(n12 + n8) << 16 | DisplayOutput.crop(n12 - n10) << 8 | DisplayOutput.crop(n12 + n9);
                nArray[n + this.displayX + 1] = DisplayOutput.crop(n14 + n8) << 16 | DisplayOutput.crop(n14 - n10) << 8 | DisplayOutput.crop(n14 + n9);
                n += 2;
            }
            n += this.displayX;
        }
    }
}

