/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.math.BigDecimal;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Round
extends OXMLFunction {
    Round() {
    }

    public String getFunctionName() {
        return "round";
    }

    public int getNumberArgs() {
        return 1;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            int n = oXMLItem.getPrimitiveType();
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.getConstantType(1, n);
            if (n == 3 || n == 4) {
                double d = oXMLItem.getDouble();
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    oXMLItem2.setDouble(oXMLSequenceType, d);
                    oXMLSequence2.appendItem(oXMLItem2);
                } else {
                    oXMLItem2.setDouble(oXMLSequenceType, Math.floor(d + 0.5));
                    oXMLSequence2.appendItem(oXMLItem2);
                }
            } else if (n == 5 || n == 22) {
                if (oXMLItem.withinRange()) {
                    oXMLItem2.setInt(oXMLSequenceType, oXMLItem.getInt());
                    oXMLSequence2.appendItem(oXMLItem2);
                } else {
                    BigDecimal bigDecimal = oXMLItem.getDecimal();
                    bigDecimal = bigDecimal.compareTo(new BigDecimal(0.0)) < 0 ? bigDecimal.setScale(0, 5) : bigDecimal.setScale(0, 4);
                    oXMLItem2.setDecimal(oXMLSequenceType, bigDecimal);
                    oXMLSequence2.appendItem(oXMLItem2);
                }
            }
        }
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != 1) {
            throw new XQException("FORT0001");
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
    }
}

