/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.comp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.util.Stack;
import oracle.xml.comp.CXMLCodeSpace;
import oracle.xml.comp.CXMLConstants;
import oracle.xml.comp.CXMLContext;
import oracle.xml.comp.CXMLStream;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.util.XMLUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CXMLParser
implements CXMLConstants {
    static int ELEM_STATE = 1;
    static int ATTR_STATE = 2;
    static int CHAR_STATE = 3;
    static int END_STATE = 4;
    static int PI_STATE = 5;
    static int COMMENT_STATE = 6;
    static int CDATA_STATE = 7;
    static int ENTITYREF_STATE = 8;
    Stack nsTagStack = new Stack();
    Stack elemTagStack = new Stack();
    Stack qnameTagStack = new Stack();
    CXMLStream in;
    SAXAttrList attrList = new SAXAttrList(4);
    ContentHandler contentHandler;
    ErrorHandler errorHandler;
    byte inp1;
    String tagURIElem = "";
    String tagElem = "";
    String tagPrefixElem = "";
    String tagQName = "";
    char[] charData;
    int charDataLen;
    int curState = ELEM_STATE;
    int prevState = ELEM_STATE;
    CXMLCodeSpace nsCodeSpace;
    CXMLCodeSpace elemCodeSpace;
    CXMLCodeSpace prefixCodeSpace;
    CXMLCodeSpace attrCodeSpace;
    CXMLContext cxmlContext = new CXMLContext();

    public CXMLParser() {
        this.nsCodeSpace = this.cxmlContext.getNSCodeSpace();
        this.elemCodeSpace = this.cxmlContext.getElemCodeSpace();
        this.prefixCodeSpace = this.cxmlContext.getPrefixCodeSpace();
        this.attrCodeSpace = this.cxmlContext.getAttrCodeSpace();
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(String string) throws IOException, SAXException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            this.in = new CXMLStream(this.cxmlContext);
            this.in.setObjectInput(new ObjectInputStream(bufferedInputStream));
            this.parse(this.in);
            Object var4_3 = null;
            if (this.in != null) {
                this.in.close();
            }
            if (bufferedInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.in != null) {
                this.in.close();
            }
            if (bufferedInputStream == null) throw throwable;
            bufferedInputStream.close();
            throw throwable;
        }
        bufferedInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(ObjectInput objectInput) throws IOException, SAXException {
        try {
            this.in = new CXMLStream(this.cxmlContext);
            this.in.setObjectInput(objectInput);
            this.parse(this.in);
            Object var3_2 = null;
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.in != null) {
                this.in.close();
            }
            throw throwable;
        }
    }

    void parse(CXMLStream cXMLStream) throws IOException, SAXException {
        try {
            char[] cArray = new char[4];
            for (int i = 0; i < 4; ++i) {
                cArray[i] = this.in.readChar();
            }
            byte by = this.in.readByte();
            if (by > 2) {
                throw new IOException("Error: The binary stream version is not compatiblle with this release of parser.");
            }
            this.cxmlContext.setVersion(by);
            if (by == 1) {
                String string = this.in.readUTF();
            }
            if (this.in.peekByte() == 16) {
                this.in.readByte();
                String string = this.in.readUTF();
                String string2 = this.in.readUTF();
                String string3 = by == 2 ? (this.in.readByte() == 1 ? "yes" : "no") : this.in.readUTF();
            }
            this.contentHandler.startDocument();
            this.attrList.reset();
            boolean bl = false;
            boolean bl2 = false;
            this.inp1 = this.in.readByte();
            this.setCurState(this.inp1);
            while (this.in.available() > 0) {
                if (this.curState == ELEM_STATE) {
                    if (bl2) {
                        this.contentHandler.startElement(this.tagURIElem, this.tagElem, this.tagQName, this.attrList);
                        this.attrList.reset();
                        if (bl) {
                            this.contentHandler.characters(this.charData, 0, this.charDataLen);
                            bl = false;
                        }
                    }
                    this.doElemState();
                    bl2 = true;
                    continue;
                }
                if (this.curState == ATTR_STATE) {
                    this.doAttrState();
                    continue;
                }
                if (this.curState == CHAR_STATE) {
                    this.doCharState();
                    bl = true;
                    continue;
                }
                if (this.curState == END_STATE) {
                    boolean bl3 = true;
                    if (by == 1) {
                        bl3 = this.prevState != ATTR_STATE;
                    }
                    if (bl3) {
                        if (bl2) {
                            this.contentHandler.startElement(this.tagURIElem, this.tagElem, this.tagQName, this.attrList);
                            this.attrList.reset();
                        }
                        if (bl) {
                            this.contentHandler.characters(this.charData, 0, this.charDataLen);
                            bl = false;
                        }
                        String string = "";
                        String string4 = "";
                        String string5 = "";
                        if (!this.qnameTagStack.empty()) {
                            string = (String)this.qnameTagStack.pop();
                        }
                        if (!this.nsTagStack.empty()) {
                            string4 = (String)this.nsTagStack.pop();
                        }
                        if (!this.elemTagStack.empty()) {
                            string5 = (String)this.elemTagStack.pop();
                            this.contentHandler.endElement(string4, string5, string);
                        }
                        bl2 = false;
                    }
                    this.doEndState();
                    continue;
                }
                if (this.curState == PI_STATE) {
                    this.doPIState();
                    continue;
                }
                if (this.curState == COMMENT_STATE) {
                    this.doCommentState();
                    continue;
                }
                if (this.curState == CDATA_STATE) {
                    this.doCDATAState();
                    continue;
                }
                if (this.curState != ENTITYREF_STATE) continue;
                this.doEntityRefState();
            }
        }
        catch (IOException iOException) {
            throw new IOException("Error: Error in reading the stream.");
        }
        catch (SAXException sAXException) {
            throw new IOException("Error: Error in reading the stream.");
        }
        finally {
            this.contentHandler.endDocument();
        }
    }

    private void doEndState() throws IOException {
        this.inp1 = this.in.readByte();
        if (this.inp1 == 22) {
            this.prevState = END_STATE;
            this.curState = END_STATE;
        } else if (this.inp1 == 23) {
            this.curState = CHAR_STATE;
            this.prevState = END_STATE;
        } else if (this.inp1 == 29) {
            this.curState = COMMENT_STATE;
            this.prevState = END_STATE;
        } else {
            this.curState = ELEM_STATE;
            this.prevState = END_STATE;
        }
    }

    private void doCharState() throws IOException, SAXException {
        String string = this.in.readUTF();
        this.charDataLen = string.equals("null") ? 0 : string.length();
        this.charData = new char[this.charDataLen];
        for (int i = 0; i < string.length(); ++i) {
            this.charData[i] = string.charAt(i);
        }
        this.inp1 = this.in.readByte();
        this.prevState = CHAR_STATE;
        this.curState = this.inp1 == 22 ? END_STATE : (this.inp1 == 23 ? CHAR_STATE : ELEM_STATE);
    }

    private void doAttrState() throws IOException, SAXException {
        boolean bl;
        int n;
        byte by;
        int n2;
        int n3;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        byte by2 = this.cxmlContext.getVersion();
        if (this.inp1 == 25) {
            string = CXMLConstants.names.create(this.in.readUTF());
            if (by2 == 2) {
                n3 = this.in.peekByte();
                if (n3 == 27 || n3 == 33) {
                    bl2 = true;
                }
            } else {
                bl2 = this.in.readBoolean();
                bl3 = this.in.readBoolean();
            }
        } else if (this.inp1 == 24) {
            this.inp1 = this.in.readByte();
            if ((this.inp1 & 0x80) == 128) {
                bl2 = CXMLCodeSpace.isNamespacePresent(this.inp1);
                if (by2 == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent(this.inp1);
                }
                n2 = this.inp1;
                by = this.in.readByte();
                n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
            } else if ((this.inp1 & 0xC0) == 192) {
                bl2 = CXMLCodeSpace.isNamespacePresent(this.inp1);
                if (by2 == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent(this.inp1);
                }
                n2 = this.in.readByte();
                by = this.in.readByte();
                n = CXMLCodeSpace.extractTokenValueFromThreeByteToken(this.inp1, (byte)n2, by);
            } else {
                n = this.inp1;
            }
            string = CXMLConstants.names.create(this.attrCodeSpace.getElementFromToken(n));
        }
        if (bl2) {
            n3 = this.in.readByte();
            if (n3 == 27) {
                string4 = CXMLConstants.names.create(this.in.readUTF());
                bl = this.nsCodeSpace.addToken(string4);
            } else {
                if (by2 == 2) {
                    if (n3 != 33) {
                        throw new IOException("Error in reading namespace associated with this node.");
                    }
                    n3 = this.in.readByte();
                }
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((this.inp1 & 0xC0) == 192) {
                    n2 = this.in.readByte();
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                string4 = CXMLConstants.names.create(this.nsCodeSpace.getElementFromToken(n));
            }
        }
        if (by2 == 1 && bl3) {
            n3 = this.in.readByte();
            if (n3 == 26) {
                string3 = CXMLConstants.names.create(this.in.readUTF());
                bl = this.prefixCodeSpace.addToken(string3);
            } else {
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = this.in.readByte();
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                string3 = CXMLConstants.names.create(this.prefixCodeSpace.getElementFromToken(n));
            }
        }
        bl = this.attrCodeSpace.addToken(string);
        if (by2 == 2) {
            string2 = string;
            string = XMLUtil.getLocalName(string2);
            string3 = XMLUtil.getPrefix(string2);
        } else {
            string2 = string3 != "" ? string3 + ":" + string : string;
        }
        string5 = CXMLConstants.names.create(this.in.readUTF());
        if (string5.equals("null")) {
            string5 = null;
        }
        this.attrList.addAttr(string3, string, string2, string5, true, 0, string4);
        n3 = this.in.readBoolean() ? 1 : 0;
        this.inp1 = this.in.readByte();
        if (by2 == 2) {
            this.prevState = ATTR_STATE;
            this.setCurState(this.inp1);
        } else if (this.inp1 == 22) {
            this.curState = END_STATE;
            this.prevState = ATTR_STATE;
        } else if (this.inp1 == 25) {
            this.curState = ATTR_STATE;
            this.prevState = ATTR_STATE;
        } else if (this.inp1 == 24) {
            this.curState = ATTR_STATE;
            this.prevState = ATTR_STATE;
        }
    }

    private void doElemState() throws IOException {
        boolean bl;
        int n;
        byte by;
        int n2;
        int n3;
        boolean bl2 = false;
        boolean bl3 = false;
        byte by2 = this.cxmlContext.getVersion();
        if (this.inp1 != 28 && this.inp1 != 15) {
            throw new IOException("Error in reading element node");
        }
        if (this.inp1 == 28) {
            this.tagElem = CXMLConstants.names.create(this.in.readUTF());
            if (by2 == 2) {
                n3 = this.in.peekByte();
                if (n3 == 27 || n3 == 33) {
                    bl2 = true;
                }
            } else {
                bl2 = this.in.readBoolean();
                bl3 = this.in.readBoolean();
            }
        } else if (this.inp1 == 15) {
            this.inp1 = this.in.readByte();
            if ((this.inp1 & 0x80) == 128) {
                bl2 = CXMLCodeSpace.isNamespacePresent(this.inp1);
                if (by2 == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent(this.inp1);
                }
                n2 = this.inp1;
                by = this.in.readByte();
                n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
            } else if ((this.inp1 & 0xC0) == 192) {
                bl2 = CXMLCodeSpace.isNamespacePresent(this.inp1);
                if (by2 == 1) {
                    bl3 = CXMLCodeSpace.isPrefixPresent(this.inp1);
                }
                n2 = this.in.readByte();
                by = this.in.readByte();
                n = CXMLCodeSpace.extractTokenValueFromThreeByteToken(this.inp1, (byte)n2, by);
            } else {
                n = this.inp1;
            }
            this.tagElem = CXMLConstants.names.create(this.elemCodeSpace.getElementFromToken(n));
        }
        if (bl2) {
            n3 = this.in.readByte();
            if (n3 == 27) {
                this.tagURIElem = CXMLConstants.names.create(this.in.readUTF());
                bl = this.nsCodeSpace.addToken(this.tagURIElem);
            } else {
                if (by2 == 2) {
                    if (n3 != 33) {
                        throw new IOException("Error in reading Namespace associated with the node");
                    }
                    n3 = this.in.readByte();
                }
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = this.in.readByte();
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                this.tagURIElem = CXMLConstants.names.create(this.nsCodeSpace.getElementFromToken(n));
            }
            this.nsTagStack.push(this.tagURIElem);
        }
        if (by2 == 1 && bl3) {
            n3 = this.in.readByte();
            if (n3 == 26) {
                this.tagPrefixElem = CXMLConstants.names.create(this.in.readUTF());
                bl = this.prefixCodeSpace.addToken(this.tagPrefixElem);
            } else {
                if ((n3 & 0x80) == 128) {
                    n2 = n3;
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromTwoByteToken((byte)n2, by);
                } else if ((n3 & 0xC0) == 192) {
                    n2 = this.in.readByte();
                    by = this.in.readByte();
                    n = CXMLCodeSpace.extractTokenValueFromThreeByteToken((byte)n3, (byte)n2, by);
                } else {
                    n = n3;
                }
                this.tagPrefixElem = CXMLConstants.names.create(this.prefixCodeSpace.getElementFromToken(n));
            }
        }
        bl = this.elemCodeSpace.addToken(this.tagElem);
        if (by2 == 2) {
            this.tagQName = this.tagElem;
            this.tagElem = XMLUtil.getLocalName(this.tagQName);
            this.tagPrefixElem = XMLUtil.getPrefix(this.tagQName);
        } else if (by2 == 1) {
            this.tagQName = this.tagPrefixElem != "" ? this.tagPrefixElem + ":" + this.tagElem : this.tagElem;
        }
        this.qnameTagStack.push(this.tagQName);
        this.elemTagStack.push(this.tagElem);
        this.inp1 = this.in.readByte();
        this.prevState = ELEM_STATE;
        this.setCurState(this.inp1);
    }

    private void doPIState() throws IOException, SAXException {
        String string = this.in.readUTF();
        String string2 = "";
        boolean bl = false;
        if (!string.equals("xml")) {
            string2 = this.in.readUTF();
            if (string2.equals("null")) {
                string2 = "";
            }
            bl = this.in.readBoolean();
        }
        this.contentHandler.processingInstruction(string, string2);
        this.inp1 = this.in.readByte();
        this.setCurState(this.inp1);
    }

    private void doCommentState() throws IOException {
        String string = this.in.readUTF();
        boolean bl = this.in.readBoolean();
        this.inp1 = this.in.readByte();
        this.setCurState(this.inp1);
    }

    private void doCDATAState() throws IOException {
        String string = this.in.readUTF();
        this.inp1 = this.in.readByte();
        this.setCurState(this.inp1);
    }

    private void doEntityRefState() throws IOException {
        String string = this.in.readUTF();
        this.inp1 = this.in.readByte();
        this.setCurState(this.inp1);
    }

    private void setCurState(byte by) {
        this.prevState = this.curState;
        if (by == 23) {
            this.curState = CHAR_STATE;
        } else if (by == 22) {
            this.curState = END_STATE;
        } else if (by == 25 || by == 24) {
            this.curState = ATTR_STATE;
        } else if (by == 20) {
            this.curState = PI_STATE;
        } else if (by == 29) {
            this.curState = COMMENT_STATE;
        } else if (by == 21) {
            this.curState = CDATA_STATE;
        } else if (by == 30) {
            this.curState = ENTITYREF_STATE;
        } else if (by == 28) {
            this.curState = ELEM_STATE;
        } else {
            this.curState = ELEM_STATE;
            this.prevState = ELEM_STATE;
        }
    }
}

