/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.TextPiece;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;

public class TextPieceTable {
    ArrayList _textPieces = new ArrayList();
    int _cpMin;

    public TextPieceTable(byte[] byArray, byte[] byArray2, int n, int n2, int n3) throws UnsupportedEncodingException {
        int n4;
        PlexOfCps plexOfCps = new PlexOfCps(byArray2, n, n2, PieceDescriptor.getSizeInBytes());
        int n5 = plexOfCps.length();
        PieceDescriptor[] pieceDescriptorArray = new PieceDescriptor[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(n4);
            pieceDescriptorArray[n4] = new PieceDescriptor(genericPropertyNode.getBytes(), 0);
        }
        this._cpMin = pieceDescriptorArray[0].getFilePosition() - n3;
        n4 = 0;
        for (int i = 0; i < pieceDescriptorArray.length; ++i) {
            int n6 = pieceDescriptorArray[i].getFilePosition();
            GenericPropertyNode genericPropertyNode = plexOfCps.getProperty(i);
            int n7 = genericPropertyNode.getStart();
            boolean bl = pieceDescriptorArray[i].isUnicode();
            int n8 = 1;
            if (bl) {
                n8 = 2;
            }
            int n9 = (genericPropertyNode.getEnd() - n7) * n8 + n7;
            int n10 = n9 - n7;
            byte[] byArray3 = new byte[n10];
            System.arraycopy(byArray, n6, byArray3, 0, n10);
            this._textPieces.add(new TextPiece(n7 + n4, n9 + n4, byArray3, pieceDescriptorArray[i]));
            if (!bl) continue;
            n4 += genericPropertyNode.getEnd() - n7;
        }
    }

    public int getCpMin() {
        return this._cpMin;
    }

    public List getTextPieces() {
        return this._textPieces;
    }

    public byte[] writeTo(HWPFOutputStream hWPFOutputStream) throws IOException {
        PlexOfCps plexOfCps = new PlexOfCps(PieceDescriptor.getSizeInBytes());
        int n = this._textPieces.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TextPiece textPiece = (TextPiece)this._textPieces.get(i);
            PieceDescriptor pieceDescriptor = textPiece.getPieceDescriptor();
            int n3 = hWPFOutputStream.getOffset();
            int n4 = n3 % 512;
            if (n4 != 0) {
                n4 = 512 - n4;
                byte[] byArray = new byte[n4];
                hWPFOutputStream.write(byArray);
            }
            pieceDescriptor.setFilePosition(hWPFOutputStream.getOffset());
            hWPFOutputStream.write(textPiece.getRawBytes());
            int n5 = textPiece.getStart();
            int n6 = 1;
            if (pieceDescriptor.isUnicode()) {
                n6 = 2;
            }
            plexOfCps.addProperty(new GenericPropertyNode(n5 - n2, (textPiece.getEnd() - n5) / n6 + n5 - n2, pieceDescriptor.toByteArray()));
            if (!pieceDescriptor.isUnicode()) continue;
            n2 += (textPiece.getEnd() - n5) / n6;
        }
        return plexOfCps.toByteArray();
    }

    public int adjustForInsert(int n, int n2) {
        TextPiece textPiece;
        int n3 = this._textPieces.size();
        textPiece.setEnd(textPiece.getEnd() + (n2 *= (textPiece = (TextPiece)this._textPieces.get(n)).usesUnicode() ? 2 : 1));
        for (int i = n + 1; i < n3; ++i) {
            textPiece = (TextPiece)this._textPieces.get(i);
            textPiece.setStart(textPiece.getStart() + n2);
            textPiece.setEnd(textPiece.getEnd() + n2);
        }
        return n2;
    }

    public boolean equals(Object object) {
        TextPieceTable textPieceTable = (TextPieceTable)object;
        int n = textPieceTable._textPieces.size();
        if (n == this._textPieces.size()) {
            for (int i = 0; i < n; ++i) {
                if (textPieceTable._textPieces.get(i).equals(this._textPieces.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

