#! /usr/bin/env python
"""Test dlmodule.c
   Roger E. Masse  revised strategy by Barry Warsaw
"""

import dl
from test.test_support import verbose,TestSkipped
import dircache

libcNames = []
libcName = ''
for file in dircache.listdir('/usr/lib/'):
        if '/libc.so.' in file:
                libcNames.append(file)
# Pick the most recent (highest number) libc
if len(libcNames) > 0:
	libcName = sorted(libcNames)[-1]
if not libcName:
	raise TestSkipped

sharedlibs = [
    (libcName, 'getpid'),
]

for s, func in sharedlibs:
    try:
        if verbose:
            print 'trying to open:', s,
        l = dl.open(s)
    except dl.error, err:
        if verbose:
            print 'failed', repr(str(err))
        pass
    else:
        if verbose:
            print 'succeeded...',
        l.call(func)
        l.close()
        if verbose:
            print 'worked!'
        break
else:
    raise TestSkipped, 'Could not open any shared libraries'
