/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.refactoring.PepticPlugin;
import org.python.pydev.refactoring.messages.Messages;

public class PepticImageCache {
    private Map<String, Image> imageHash = new HashMap<String, Image>(10);
    private Image missing = null;

    public void dispose() {
        Iterator<Image> iterator = this.imageHash.values().iterator();
        while (iterator.hasNext()) {
            Image image = iterator.next();
            image.dispose();
        }
        if (this.missing != null) {
            this.missing.dispose();
        }
    }

    public Image get(String key) {
        Image image = this.imageHash.get(key);
        if (image == null) {
            try {
                ImageDescriptor desc = this.getDescriptor(key);
                image = desc.createImage();
                this.imageHash.put(key, image);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return null;
            }
        }
        return image;
    }

    public ImageDescriptor getDescriptor(String key) {
        return PepticPlugin.imageDescriptorFromPlugin((String)"org.python.pydev.refactoring", (String)(String.valueOf(Messages.imagePath) + key));
    }
}

