/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.plugin.PydevPlugin;

public class ColorCache {
    private Map fColorTable = new HashMap(10);
    private Map fNamedColorTable = new HashMap(10);
    private IPreferenceStore preferences;

    public ColorCache(IPreferenceStore prefs) {
        this.preferences = prefs;
    }

    public void dispose() {
        Iterator e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
        e = this.fNamedColorTable.values().iterator();
        while (e.hasNext()) {
            ((Color)e.next()).dispose();
        }
    }

    public Color getColor(RGB rgb) {
        Color color = (Color)this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public Color getNamedColor(String name) {
        Color color = (Color)this.fNamedColorTable.get(name);
        if (color == null) {
            String colorCode = this.preferences.getString(name);
            if (colorCode.length() == 0) {
                if (name.equals("RED")) {
                    color = this.getColor(new RGB(255, 0, 0));
                } else if (name.equals("BLACK")) {
                    color = this.getColor(new RGB(0, 0, 0));
                } else {
                    PydevPlugin.log("Unknown color:" + name);
                    color = this.getColor(new RGB(255, 0, 0));
                }
            } else {
                try {
                    RGB rgb = StringConverter.asRGB((String)colorCode);
                    color = new Color((Device)Display.getCurrent(), rgb);
                    this.fNamedColorTable.put(name, color);
                }
                catch (DataFormatException e) {
                    PydevPlugin.log(e);
                    color = new Color((Device)Display.getCurrent(), new RGB(255, 50, 0));
                }
            }
        }
        return color;
    }

    public void reloadNamedColor(String name) {
        if (this.fNamedColorTable.containsKey(name)) {
            ((Color)this.fNamedColorTable.get(name)).dispose();
            this.fNamedColorTable.remove(name);
        }
    }
}

