/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.REF;
import org.python.pydev.editor.codecompletion.revisited.ModulesKeyTreeMap;
import org.python.pydev.editor.codecompletion.revisited.ModulesManager;

public abstract class ProjectModulesManagerBuild
extends ModulesManager
implements IProjectModulesManager {
    public void removeModule(File file, IProject project, IProgressMonitor monitor) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this.removeModulesBelow(file, project, monitor);
        } else if (file.getName().startsWith("__init__.")) {
            this.removeModulesBelow(file.getParentFile(), project, monitor);
        } else {
            this.removeModulesWithFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModulesWithFile(File file) {
        if (file == null) {
            return;
        }
        ArrayList<ModulesKey> toRem = new ArrayList<ModulesKey>();
        ModulesKeyTreeMap modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            Iterator iter = this.modulesKeys.keySet().iterator();
            while (iter.hasNext()) {
                ModulesKey key = (ModulesKey)iter.next();
                if (key.file == null || !key.file.equals(file)) continue;
                toRem.add(key);
            }
            this.removeThem(toRem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModulesBelow(File file, IProject project, IProgressMonitor monitor) {
        if (file == null) {
            return;
        }
        String absolutePath = REF.getFileAbsolutePath((File)file);
        ArrayList<ModulesKey> toRem = new ArrayList<ModulesKey>();
        ModulesKeyTreeMap modulesKeyTreeMap = this.modulesKeys;
        synchronized (modulesKeyTreeMap) {
            Iterator iterator = this.modulesKeys.keySet().iterator();
            while (iterator.hasNext()) {
                ModulesKey key = (ModulesKey)iterator.next();
                if (key.file == null || !REF.getFileAbsolutePath((File)key.file).startsWith(absolutePath)) continue;
                toRem.add(key);
            }
            this.removeThem(toRem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildModule(File f, IDocument doc, IProject project, IProgressMonitor monitor, IPythonNature nature) {
        String m = this.pythonPathHelper.resolveModule(REF.getFileAbsolutePath((File)f));
        if (m != null) {
            this.addModule(new ModulesKey(m, f));
        } else if (f != null) {
            ModulesKeyTreeMap modulesKeyTreeMap = this.modulesKeys;
            synchronized (modulesKeyTreeMap) {
                HashSet<ModulesKey> toRemove = new HashSet<ModulesKey>();
                Iterator iter = this.modulesKeys.keySet().iterator();
                while (iter.hasNext()) {
                    ModulesKey key = (ModulesKey)iter.next();
                    if (key.file == null || !key.file.equals(f)) continue;
                    toRemove.add(key);
                }
                this.removeThem(toRemove);
            }
        }
    }
}

