/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.util.Date;
import java.util.Map;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Group;
import net.sf.mpxj.GroupClause;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.mpp.BackgroundPattern;
import net.sf.mpxj.mpp.ColorType;
import net.sf.mpxj.mpp.FixedData;
import net.sf.mpxj.mpp.FontBase;
import net.sf.mpxj.mpp.FontStyle;
import net.sf.mpxj.mpp.MPPUtility;
import net.sf.mpxj.mpp.Var2Data;
import net.sf.mpxj.utility.FieldTypeUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GroupReader {
    protected abstract Integer getVarDataType();

    public void process(ProjectFile projectFile, FixedData fixedData, Var2Data var2Data, Map<Integer, FontBase> map) {
        int n = fixedData.getItemCount();
        for (int i = 0; i < n; ++i) {
            Integer n2;
            byte[] byArray;
            byte[] byArray2 = fixedData.getByteArrayValue(i);
            if (byArray2 == null || byArray2.length < 4 || (byArray = var2Data.getByteArray(n2 = Integer.valueOf(MPPUtility.getInt(byArray2, 0)), this.getVarDataType())) == null) continue;
            String string = MPPUtility.getUnicodeString(byArray2, 4);
            boolean bl = MPPUtility.getShort(byArray, 4) != 0;
            Group group = new Group(n2, string, bl);
            projectFile.addGroup(group);
            int n3 = MPPUtility.getShort(byArray, 6);
            int n4 = 8;
            for (int j = 0; j < n3 && n4 + 47 <= byArray.length; ++j) {
                GroupClause groupClause = new GroupClause();
                group.addGroupClause(groupClause);
                int n5 = MPPUtility.getInt(byArray, n4);
                FieldType fieldType = FieldTypeUtility.getInstance(n5);
                groupClause.setField(fieldType);
                boolean bl2 = MPPUtility.getByte(byArray, n4 + 4) != 0;
                groupClause.setAscending(bl2);
                int n6 = MPPUtility.getByte(byArray, n4 + 8);
                FontBase fontBase = map.get(n6);
                int n7 = MPPUtility.getByte(byArray, n4 + 9);
                boolean bl3 = (n7 & 1) != 0;
                boolean bl4 = (n7 & 2) != 0;
                boolean bl5 = (n7 & 4) != 0;
                int n8 = MPPUtility.getByte(byArray, n4 + 10);
                ColorType colorType = ColorType.getInstance(n8);
                FontStyle fontStyle = new FontStyle(fontBase, bl4, bl3, bl5, false, colorType.getColor(), null, BackgroundPattern.SOLID);
                groupClause.setFont(fontStyle);
                int n9 = MPPUtility.getByte(byArray, n4 + 12);
                ColorType colorType2 = ColorType.getInstance(n9);
                groupClause.setCellBackgroundColor(colorType2.getColor());
                groupClause.setPattern(BackgroundPattern.getInstance(MPPUtility.getByte(byArray, n4 + 13) & 0xF));
                int n10 = MPPUtility.getShort(byArray, n4 + 14);
                groupClause.setGroupOn(n10);
                Comparable<Date> comparable = null;
                Number number = null;
                if (fieldType != null) {
                    switch (fieldType.getDataType()) {
                        case DURATION: 
                        case NUMERIC: 
                        case CURRENCY: {
                            comparable = MPPUtility.getDouble(byArray, n4 + 24);
                            number = MPPUtility.getDouble(byArray, n4 + 40);
                            break;
                        }
                        case PERCENTAGE: {
                            comparable = MPPUtility.getInt(byArray, n4 + 24);
                            number = MPPUtility.getInt(byArray, n4 + 40);
                            break;
                        }
                        case BOOLEAN: {
                            comparable = MPPUtility.getShort(byArray, n4 + 24) == 1 ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case DATE: {
                            comparable = MPPUtility.getTimestamp(byArray, n4 + 24);
                            number = MPPUtility.getInt(byArray, n4 + 40);
                            break;
                        }
                    }
                }
                groupClause.setStartAt(comparable);
                groupClause.setGroupInterval(number);
                n4 += 48;
            }
        }
    }
}

