/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import net.sf.mpxj.mpp.MPPComponent;
import net.sf.mpxj.mpp.MPPUtility;

final class FixedMeta
extends MPPComponent {
    private int m_itemCount;
    private Object[] m_array;
    private static final int MAGIC = -86004294;

    FixedMeta(InputStream inputStream, int n) throws IOException {
        int n2 = inputStream.available();
        if (this.readInt(inputStream) != -86004294) {
            throw new IOException("Bad magic number");
        }
        this.readInt(inputStream);
        this.m_itemCount = this.readInt(inputStream);
        this.readInt(inputStream);
        this.m_itemCount = (n2 - 16) / n;
        this.m_array = new Object[this.m_itemCount];
        for (int i = 0; i < this.m_itemCount; ++i) {
            this.m_array[i] = this.readByteArray(inputStream, n);
        }
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public byte[] getByteArrayValue(int n) {
        byte[] byArray = null;
        if (n >= 0 && n < this.m_array.length && this.m_array[n] != null) {
            byArray = (byte[])this.m_array[n];
        }
        return byArray;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("BEGIN: FixedMeta");
        printWriter.println("   Item count: " + this.m_itemCount);
        for (int i = 0; i < this.m_itemCount; ++i) {
            printWriter.println("   Data at index: " + i);
            printWriter.println("  " + MPPUtility.hexdump((byte[])this.m_array[i], true));
        }
        printWriter.println("END: FixedMeta");
        printWriter.println();
        printWriter.close();
        return stringWriter.toString();
    }
}

