/*
 * Decompiled with CFR 0.152.
 */
package com.projity.session;

import com.projity.exchange.FileImporter;
import com.projity.grouping.core.model.DefaultNodeModel;
import com.projity.job.Job;
import com.projity.job.JobRunnable;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.resource.ResourcePoolFactory;
import com.projity.pm.task.Project;
import com.projity.pm.task.ProjectFactory;
import com.projity.session.AbstractSession;
import com.projity.session.FileHelper;
import com.projity.session.LoadOptions;
import com.projity.session.SaveOptions;
import com.projity.session.SessionFactory;
import com.projity.strings.Messages;
import com.projity.undo.DataFactoryUndoController;
import com.projity.util.Alert;
import com.projity.util.ClassUtils;
import com.projity.util.Environment;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.Closure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalSession
extends AbstractSession {
    public static final String LOCAL_PROJECT_IMPORTER = "com.projity.exchange.LocalFileImporter";
    public static final String SERVER_LOCAL_PROJECT_IMPORTER = "com.projity.exchange.ServerLocalFileImporter";
    public static final String MICROSOFT_PROJECT_IMPORTER = "com.projity.exchange.MicrosoftImporter";
    protected long localSeed;
    private FileHelper fileHelper = null;

    @Override
    public synchronized long getId() {
        return this.localSeed++;
    }

    @Override
    public Job getCloseProjectsJob(Collection collection) {
        Job job = new Job(this.jobQueue, "closeProjects", "Closing...", false);
        job.addRunnable(new JobRunnable("LocalAccess: closeProjects", 0.1f){

            public Object run() throws Exception {
                this.setProgress(1.0f);
                return null;
            }
        });
        job.addExceptionRunnable(new JobRunnable("Local: exception"){

            public Object run() throws Exception {
                Alert.error(Messages.getString("Message.serverError"));
                return null;
            }
        });
        return job;
    }

    @Override
    public Job getLoadProjectJob(final LoadOptions loadOptions) {
        final Job job = new Job(this.jobQueue, "loadProject", "Loading...", true);
        job.setCancelMonitorClosure(new Closure(){

            public void execute(Object object) {
                System.out.println("Monitor Canceled");
                LocalSession.this.jobQueue.endCriticalSection(job);
            }
        });
        try {
            final FileImporter fileImporter = (FileImporter)ClassUtils.forName(loadOptions.getImporter()).newInstance();
            fileImporter.setFileName(loadOptions.getFileName());
            fileImporter.setResourceMapping(loadOptions.getResourceMapping());
            fileImporter.setProjectFactory(ProjectFactory.getInstance());
            fileImporter.setJobQueue(this.jobQueue);
            job.addSwingRunnable(new JobRunnable("LocalAccess: loadProject.begin", 1.0f){

                public Object run() throws Exception {
                    ResourcePool resourcePool = null;
                    if (LocalSession.MICROSOFT_PROJECT_IMPORTER.equals(loadOptions.getImporter())) {
                        DataFactoryUndoController dataFactoryUndoController = new DataFactoryUndoController();
                        resourcePool = ResourcePoolFactory.getInstance().createResourcePool("", dataFactoryUndoController);
                        resourcePool.setLocal(fileImporter.getResourceMapping() == null);
                        Project project = Project.createProject(resourcePool, dataFactoryUndoController);
                        ((DefaultNodeModel)project.getTaskOutline()).setDataFactory(project);
                        fileImporter.setProject(project);
                    }
                    this.setProgress(1.0f);
                    return null;
                }
            });
            job.addJob(fileImporter.getImportFileJob());
            job.addRunnable(new JobRunnable("LocalAccess: loadProject.end", 1.0f){

                public Object run() throws Exception {
                    Project project = fileImporter.getProject();
                    project.setFileName(loadOptions.getFileName());
                    if (LocalSession.MICROSOFT_PROJECT_IMPORTER.equals(loadOptions.getImporter())) {
                        project.getResourcePool().setName(project.getName());
                    }
                    if (Environment.getStandAlone()) {
                        project.setMaster(true);
                        project.setLocal(true);
                    }
                    this.setProgress(1.0f);
                    return project;
                }
            });
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return job;
    }

    @Override
    public Job getSaveProjectJob(List<Project> list, final SaveOptions saveOptions) {
        final Job job = new Job(this.jobQueue, "saveProject", "Saving...", true);
        job.setCancelMonitorClosure(new Closure(){

            public void execute(Object object) {
                System.out.println("Monitor Canceled");
                LocalSession.this.jobQueue.endCriticalSection(job);
            }
        });
        FileImporter fileImporter = null;
        try {
            fileImporter = (FileImporter)ClassUtils.forName(saveOptions.getImporter()).newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        fileImporter.setJobQueue(this.jobQueue);
        fileImporter.setProjectFactory(ProjectFactory.getInstance());
        int n = list.size();
        boolean bl = false;
        for (final Project project : list) {
            String string;
            String string2;
            String string3 = string2 = saveOptions.getFileName() == null ? project.getGuessedFileName() : saveOptions.getFileName();
            if (!FileHelper.isFileNameAllowed(string2, true)) {
                string2 = SessionFactory.getInstance().getLocalSession().chooseFileName(true, FileHelper.changeFileExtension(string2, 1));
            }
            if ((string = string2) == null) continue;
            fileImporter.setFileName(string);
            fileImporter.setProject(project);
            if (saveOptions.getPreSaving() != null) {
                saveOptions.getPreSaving().execute(project);
            }
            job.addJob(fileImporter.getExportFileJob());
            job.addRunnable(new JobRunnable("Local: saveProject end"){

                public Object run() throws Exception {
                    project.setFileName(string);
                    project.setGroupDirty(false);
                    if (saveOptions.getPostSaving() != null) {
                        saveOptions.getPostSaving().execute(project);
                    }
                    return null;
                }
            });
        }
        job.addExceptionRunnable(new JobRunnable("Local: exception"){

            public Object run() throws Exception {
                Alert.error(Messages.getString("Message.serverError"));
                return null;
            }
        });
        return job;
    }

    private FileHelper getFileHelper() {
        if (this.fileHelper == null) {
            this.fileHelper = new FileHelper();
        }
        return this.fileHelper;
    }

    public String chooseFileName(boolean bl, String string) {
        return this.getFileHelper().chooseFileName(bl, string, this.getJobQueue().getComponent());
    }

    public static String getImporter(int n) {
        switch (n) {
            case 1: {
                return LOCAL_PROJECT_IMPORTER;
            }
            case 101: {
                return MICROSOFT_PROJECT_IMPORTER;
            }
        }
        return null;
    }

    @Override
    public boolean projectExists(long l) {
        return true;
    }
}

