/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment;

import com.projity.association.AssociationFormat;
import com.projity.association.AssociationFormatParameters;
import com.projity.configuration.Settings;
import com.projity.datatype.Rate;
import com.projity.field.FieldParseException;
import com.projity.options.GeneralOption;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.resource.Resource;
import com.projity.pm.task.Task;
import com.projity.strings.Messages;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AssignmentFormat
extends AssociationFormat {
    private static NumberFormat percentFormat = NumberFormat.getPercentInstance();
    private static String typePatternString = "\\s*([^" + Messages.getString("Symbol.leftBracketRegex") + "]+" + ")" + "(?:" + Messages.getString("Symbol.leftBracketRegex") + "(" + "\\d+" + ".*" + ")" + Messages.getString("Symbol.rightBracketRegex") + ")?" + "\\s*";
    private static Pattern pattern = Pattern.compile(typePatternString);

    public static AssignmentFormat getInstance(AssociationFormatParameters associationFormatParameters) {
        return new AssignmentFormat(associationFormatParameters);
    }

    private AssignmentFormat(AssociationFormatParameters associationFormatParameters) {
        super(associationFormatParameters);
    }

    private String getErrorMessage(String string) {
        return Messages.getString("Message.invalidAssignments");
    }

    private Object doParse(String string, ParsePosition parsePosition) throws ParseException {
        Cloneable cloneable;
        Matcher matcher = pattern.matcher(string.substring(parsePosition.getIndex()));
        if (!matcher.matches()) {
            throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
        }
        Object object = this.parameters.getIdField().find(matcher.group(1), this.getContainer(this.parameters.isLeftAssociation()));
        if (object == null) {
            if (GeneralOption.getInstance().isAutomaticallyAddNewResourcesAndTasks()) {
                object = this.createNewObject(this.parameters.isLeftAssociation());
                if (object == null) {
                    throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
                }
                try {
                    this.parameters.getIdField().setText(object, matcher.group(1), null);
                }
                catch (FieldParseException fieldParseException) {
                    throw new ParseException(fieldParseException.getMessage(), 0);
                }
            } else {
                throw new ParseException(this.getErrorMessage(string), parsePosition.getIndex());
            }
        }
        double d = 1.0;
        Resource resource = (Resource)(this.parameters.isLeftAssociation() ? object : this.parameters.getThisObject());
        Rate rate = null;
        if (matcher.group(2) != null) {
            if (!this.getParameters().isAllowDetailsEntry()) {
                throw new ParseException(Messages.getString("Message.cannotEnterUnits"), 0);
            }
            cloneable = resource.getRateFormat();
            rate = (Rate)cloneable.parseObject(matcher.group(2));
            d = rate.getValue();
        } else if (resource.isMaterial()) {
            rate = new Rate(1.0, -2);
        }
        cloneable = Assignment.getInstance((Task)(this.parameters.isLeftAssociation() ? this.parameters.getThisObject() : object), resource, d, 0);
        if (rate != null) {
            ((Assignment)cloneable).detail.setRate(rate);
        }
        return cloneable;
    }

    public Object parseObject(String string, ParsePosition parsePosition) {
        try {
            return this.doParse(string, parsePosition);
        }
        catch (ParseException parseException) {
            this.parameters.setError(parseException.getMessage());
            return null;
        }
    }

    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        double d;
        Assignment assignment = (Assignment)object;
        Cloneable cloneable = this.parameters.isLeftAssociation() ? assignment.getResource() : assignment.getTask();
        stringBuffer.append(this.parameters.getIdField().getValue(cloneable, null));
        if (this.parameters.isEncloseInBrackets() && (d = assignment.getUnits()) != 1.0) {
            stringBuffer.append(Settings.LEFT_BRACKET);
            stringBuffer.append(assignment.getRateFormat().format(assignment.getRate()));
            stringBuffer.append(Settings.RIGHT_BRACKET);
        }
        return stringBuffer;
    }

    protected Collection getContainer(boolean bl) {
        if (bl) {
            return ((Task)this.parameters.getThisObject()).getProject().getResourcePool().getResourceList();
        }
        return null;
    }

    protected Object createNewObject(boolean bl) {
        if (bl) {
            return ((Task)this.parameters.getThisObject()).getProject().getResourcePool().newResourceInstance();
        }
        return null;
    }
}

