/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingMetadataReaderFactory
extends SimpleMetadataReaderFactory {
    private static final int MAX_ENTRIES = 256;
    private final Map<Resource, MetadataReader> classReaderCache = CachingMetadataReaderFactory.createLRUCache();

    public CachingMetadataReaderFactory() {
    }

    public CachingMetadataReaderFactory(ResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    public CachingMetadataReaderFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        Map<Resource, MetadataReader> map = this.classReaderCache;
        synchronized (map) {
            MetadataReader metadataReader = this.classReaderCache.get(resource);
            if (metadataReader == null) {
                metadataReader = super.getMetadataReader(resource);
                this.classReaderCache.put(resource, metadataReader);
            }
            return metadataReader;
        }
    }

    private static <K, V> Map<K, V> createLRUCache() {
        return new LinkedHashMap<K, V>(256, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > 256;
            }
        };
    }
}

