/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.filemodels;

import com.sun.javacard.AID;
import com.sun.javacard.Portability;
import com.sun.javacard.filemodels.AppletXmlAppletEntry;
import com.sun.javacard.filemodels.FileModel;
import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.WrapperParseErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AppletXmlModel
extends FileModel<AppletXmlAppletEntry> {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<applet-app xmlns=\"http://java.sun.com/xml/ns/javacard\"\n           xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n           xsi:schemaLocation=\"http://java.sun.com/xml/ns/javacard http://java.sun.com/xml/ns/javacard/applet-app_3_0.xsd\"\n           version=\"3.0\">\n";
    private static final String[] KNOWN_TAGS = new String[]{"display-name", "applet", "applet-class", "applet-AID", "applet-app"};
    private AID defaultApplet;

    public AppletXmlModel(InputStream in, ParseErrorHandler handler) throws IOException {
        if (in == null) {
            throw new NullPointerException("in");
        }
        this.parse(in, handler);
        this.close();
    }

    public AppletXmlModel(InputStream in) throws IOException {
        this(in, null);
    }

    public AppletXmlModel() {
    }

    public Iterable<AID> allAIDs() {
        ArrayList<AID> result = new ArrayList<AID>();
        for (AppletXmlAppletEntry info : this.getData()) {
            if (info.aid == null) continue;
            result.add(info.aid);
        }
        return result;
    }

    public boolean containsClass(String fqn) {
        if (fqn == null) {
            return false;
        }
        for (AppletXmlAppletEntry info : this.getData()) {
            if (!fqn.equals(info.clazz)) continue;
            return true;
        }
        return false;
    }

    private AppletXmlAppletEntry getByName(String name) {
        for (AppletXmlAppletEntry info : this.getData()) {
            if (!name.equals(info.displayName)) continue;
            return info;
        }
        return null;
    }

    private AppletXmlAppletEntry getByAID(AID aid) {
        for (AppletXmlAppletEntry info : this.getData()) {
            if (!aid.equals(info.aid)) continue;
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream in, ParseErrorHandler handler) throws IOException {
        try {
            handler = handler == null ? ParseErrorHandler.DEFAULT : handler;
            handler = new WrapperParseErrorHandler(handler, this);
            Document doc = null;
            doc = Portability.parse(in);
            NodeList applets = doc.getElementsByTagName("applet");
            int len = applets.getLength();
            int ix = 0;
            for (int i = 0; i < len; ++i) {
                String displayName = null;
                String clazz = null;
                String aidString = null;
                Node parent = applets.item(i);
                NodeList kids = parent.getChildNodes();
                int kl = kids.getLength();
                for (int j = 0; j < kl; ++j) {
                    Node child = kids.item(j);
                    if (child.getNodeType() != 1) continue;
                    if ("display-name".equals(child.getNodeName())) {
                        displayName = child.getTextContent();
                        continue;
                    }
                    if ("applet-class".equals(child.getNodeName())) {
                        clazz = child.getTextContent();
                        continue;
                    }
                    if ("applet-AID".equals(child.getNodeName())) {
                        aidString = child.getTextContent();
                        continue;
                    }
                    handler.unrecognizedElementEncountered(child.getNodeName());
                }
                if (displayName == null || clazz == null) continue;
                AppletXmlAppletEntry info = this.getByName(displayName);
                AID aid = null;
                IllegalArgumentException ex = null;
                try {
                    aid = aidString == null ? null : AID.parse(aidString);
                }
                catch (IllegalArgumentException e) {
                    handler.handleBadAIDError(e, aidString);
                    ex = e;
                }
                if (aid == null) {
                    String pkg;
                    int lastDot = clazz.lastIndexOf(46);
                    String cl = lastDot != (pkg = clazz.substring(0, lastDot)).length() - 1 ? clazz.substring(lastDot + 1, clazz.length()) : clazz;
                    Logger.getLogger(AppletXmlModel.class.getName()).log(Level.INFO, "Invalid AID in applet.xml " + aidString + " - " + "generating random one " + aid, ex == null ? new Exception() : ex);
                }
                if (info != null) continue;
                info = new AppletXmlAppletEntry(displayName, clazz, aid, ix);
                ++ix;
                this.add(info);
            }
        }
        catch (IOException ex) {
            handler.handleError(ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                Portability.logException(ex);
            }
        }
    }

    public synchronized AID defaultApplet() {
        return this.defaultApplet;
    }

    public synchronized void setDefaultApplet(AID aid) {
        this.defaultApplet = aid;
    }

    public void writeTo(Node[] nodes) {
    }

    @Override
    public boolean equals(Object o) {
        boolean result;
        boolean bl = result = o != this && o != null && o.getClass() == AppletXmlModel.class;
        if (result) {
            AppletXmlModel other = (AppletXmlModel)o;
            List odata = other.getData();
            List myData = this.getData();
            result = ((Object)myData).equals(odata);
        }
        return result;
    }

    public boolean deploymentDataEquals(AppletXmlModel mdl) {
        if (!this.equals(mdl)) {
            return false;
        }
        for (AppletXmlAppletEntry info : this.getData()) {
            AppletXmlAppletEntry other;
            AID aid = info.aid;
            if (aid == null || (other = mdl.getByAID(aid)) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        List myData = this.getData();
        hash = 23 * hash + ((Object)myData).hashCode();
        return hash;
    }

    public String toString() {
        return this.toXml();
    }

    @Override
    public String toXml() {
        StringBuilder sb = new StringBuilder(HEADER);
        List dataCopy = this.getData();
        for (AppletXmlAppletEntry i : dataCopy) {
            sb.append(i.toXml());
        }
        sb.append("</applet-app>\n");
        return sb.toString();
    }
}

