/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.rubyproject.RubyProjectGenerator;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.netbeans.modules.ruby.rubyproject.ui.FoldersListSettings;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.rubyproject.ui.wizards.PanelSourceFolders;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewRubyProjectWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator {
    static final String PROP_NAME_INDEX = "nameIndex";
    private static final long serialVersionUID = 1L;
    private Type type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private static final Logger LOGGER = Logger.getLogger(NewRubyProjectWizardIterator.class.getName());

    public NewRubyProjectWizardIterator() {
        this(Type.APPLICATION);
    }

    NewRubyProjectWizardIterator(Type type) {
        this.type = type;
    }

    public static NewRubyProjectWizardIterator existing() {
        return new NewRubyProjectWizardIterator(Type.EXISTING);
    }

    private WizardDescriptor.Panel[] createPanels() {
        WizardDescriptor.Panel[] result;
        switch (this.type) {
            case APPLICATION: {
                result = new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type)};
                break;
            }
            case EXISTING: {
                result = new WizardDescriptor.Panel[]{new PanelConfigureProject(this.type), new PanelSourceFolders.Panel()};
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + (Object)((Object)this.type));
            }
        }
        return result;
    }

    private String[] createSteps() {
        String[] result;
        switch (this.type) {
            case APPLICATION: {
                result = new String[]{NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"LAB_ConfigureProject")};
                break;
            }
            case EXISTING: {
                result = new String[]{NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"LAB_ConfigureProject"), NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"LAB_ConfigureSourceRoots")};
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + (Object)((Object)this.type));
            }
        }
        return result;
    }

    public Set<FileObject> instantiate() throws IOException {
        assert (false) : "Cannot call this method if implements WizardDescriptor.ProgressInstantiatingIterator.";
        return null;
    }

    public Set<FileObject> instantiate(ProgressHandle handle) throws IOException {
        handle.start(4);
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        File dirF = (File)this.wiz.getProperty("projdir");
        if (dirF != null) {
            dirF = FileUtil.normalizeFile((File)dirF);
        }
        String name = (String)this.wiz.getProperty("name");
        handle.progress(NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"LBL_NewRubyProjectWizardIterator_WizardProgress_CreatingProject"), 1);
        RubyPlatform platform = (RubyPlatform)this.wiz.getProperty("platform");
        if (platform == null) {
            LOGGER.severe("Can not find the selected plaform for the project. Check the platform configurations in Tools | Ruby Platforms");
            return resultSet;
        }
        if (this.type == Type.EXISTING) {
            File[] sourceFolders = (File[])this.wiz.getProperty("sourceRoot");
            File[] testFolders = (File[])this.wiz.getProperty("testRoot");
            RubyProjectGenerator.createProject(dirF, name, sourceFolders, testFolders, platform);
            handle.progress(2);
            for (int i = 0; i < sourceFolders.length; ++i) {
                FileObject srcFo = FileUtil.toFileObject((File)sourceFolders[i]);
                if (srcFo == null) continue;
                resultSet.add(srcFo);
            }
        } else {
            String mainClass = (String)this.wiz.getProperty("mainClass");
            RakeProjectHelper h = RubyProjectGenerator.createProject(dirF, name, mainClass, platform);
            handle.progress(2);
            if (mainClass != null && mainClass.length() > 0) {
                try {
                    FileObject sourcesRoot = h.getProjectDirectory().getFileObject("lib");
                    FileObject mainClassFo = this.getMainClassFO(sourcesRoot, mainClass);
                    assert (mainClassFo != null) : "sourcesRoot: " + sourcesRoot + ", mainClass: " + mainClass;
                    resultSet.add(mainClassFo);
                }
                catch (Exception x) {
                    ErrorManager.getDefault().notify((Throwable)x);
                }
            }
        }
        FileObject dir = FileUtil.toFileObject((File)dirF);
        handle.progress(3);
        Integer index = (Integer)this.wiz.getProperty(PROP_NAME_INDEX);
        switch (this.type) {
            case APPLICATION: {
                FoldersListSettings.getDefault().setNewApplicationCount(index);
                break;
            }
            case EXISTING: {
                FoldersListSettings.getDefault().setNewProjectCount(index);
                break;
            }
            default: {
                throw new IllegalStateException("unknown type: " + (Object)((Object)this.type));
            }
        }
        resultSet.add(dir);
        handle.progress(NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"LBL_NewRubyProjectWizardIterator_WizardProgress_PreparingToOpen"), 4);
        File file = dirF = dirF != null ? dirF.getParentFile() : null;
        if (dirF != null && dirF.exists()) {
            ProjectChooser.setProjectsFolder((File)dirF);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
        this.wiz.putProperty("sourceRoot", (Object)new File[0]);
        this.wiz.putProperty("testRoot", (Object)new File[0]);
    }

    public void uninitialize(WizardDescriptor wiz) {
        if (this.wiz != null) {
            this.wiz.putProperty("projdir", null);
            this.wiz.putProperty("name", null);
            this.wiz.putProperty("mainClass", null);
            this.wiz.putProperty("platform", null);
            if (this.type == Type.EXISTING) {
                this.wiz.putProperty("sourceRoot", null);
                this.wiz.putProperty("testRoot", null);
            }
            this.wiz = null;
            this.panels = null;
        }
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"LAB_IteratorName"), this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    private FileObject getMainClassFO(FileObject sourcesRoot, String mainClass) {
        return sourcesRoot.getFileObject(Util.stripExtension(mainClass, ".rb") + ".rb");
    }

    static String getPackageName(String displayName) {
        StringBuffer builder = new StringBuffer();
        boolean firstLetter = true;
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if ((firstLetter || !Character.isJavaIdentifierPart(c)) && (!firstLetter || !Character.isJavaIdentifierStart(c))) continue;
            firstLetter = false;
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            }
            builder.append(c);
        }
        return builder.length() == 0 ? NbBundle.getMessage(NewRubyProjectWizardIterator.class, (String)"TXT_DefaultPackageName") : builder.toString();
    }

    static enum Type {
        APPLICATION,
        EXISTING;

    }
}

