/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyTestingSettings;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class Util {
    private static final String LAST_PLATFORM_ID = "projectPanelLastPlatformID";
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.ruby");

    private Util() {
    }

    public static RubyBaseProject inferRubyProject() {
        Lookup globalContext;
        RubyBaseProject result;
        Node[] activatedNodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        if (activatedNodes != null) {
            for (Node n : activatedNodes) {
                RubyBaseProject result2 = Util.lookupRubyBaseProject(n.getLookup());
                if (result2 == null) continue;
                return result2;
            }
        }
        if ((result = Util.lookupRubyBaseProject(globalContext = Utilities.actionsGlobalContext())) != null) {
            return result;
        }
        FileObject fo = (FileObject)globalContext.lookup(FileObject.class);
        if (fo != null && (result = Util.lookupRubyBaseProject(FileOwnerQuery.getOwner((FileObject)fo))) != null) {
            return result;
        }
        OpenProjects projects = OpenProjects.getDefault();
        result = Util.lookupRubyBaseProject(projects.getMainProject());
        if (result != null) {
            return result;
        }
        for (Project project : projects.getOpenProjects()) {
            result = Util.lookupRubyBaseProject(project);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static RubyBaseProject lookupRubyBaseProject(Project project) {
        if (project != null) {
            return Util.lookupRubyBaseProject(project.getLookup());
        }
        return null;
    }

    private static RubyBaseProject lookupRubyBaseProject(Lookup lookup) {
        RubyBaseProject result = (RubyBaseProject)lookup.lookup(RubyBaseProject.class);
        if (result != null) {
            return result;
        }
        Project project = (Project)lookup.lookup(Project.class);
        if (project != null && (result = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class)) != null) {
            return result;
        }
        return null;
    }

    public static void preselectWizardPlatform(JComboBox platforms) {
        org.netbeans.modules.ruby.platform.Util.preselectPlatform((JComboBox)platforms, (String)LAST_PLATFORM_ID);
    }

    public static void storeWizardPlatform(JComboBox platforms) {
        RubyPlatform selectedPlatform = PlatformComponentFactory.getPlatform((JComboBox)platforms);
        if (selectedPlatform != null) {
            RubyPreferences.getPreferences().put(LAST_PLATFORM_ID, selectedPlatform.getID());
        }
    }

    public static String stripExtension(String fileName, String ext) {
        int extIndex = fileName.lastIndexOf(46);
        String extension = extIndex == -1 ? "" : fileName.substring(extIndex);
        return ext.equals(extension) ? fileName.substring(0, extIndex) : fileName;
    }

    public static String getProjectNameWarning(String projectNameTextField) {
        return RubyUtils.getIdentifierWarning((String)projectNameTextField.replace('-', '_'), (int)0);
    }

    public static void logUsage(Class srcClass, String message, Object ... params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    public static TestRunner getTestRunner(TestRunner.TestType testType) {
        if (!RubyTestingSettings.getDefault().useRunner(testType)) {
            return null;
        }
        Collection testRunners = Lookup.getDefault().lookupAll(TestRunner.class);
        for (TestRunner each : testRunners) {
            if (!each.supports(testType)) continue;
            return each;
        }
        return null;
    }

    public static boolean isProjectAlready(File folder) {
        boolean foundButBroken;
        Project prj;
        block5: {
            if (!folder.exists()) {
                return false;
            }
            assert (folder.isDirectory()) : "Directory must be given: " + folder;
            prj = null;
            foundButBroken = false;
            try {
                prj = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)folder));
            }
            catch (IOException ex) {
                foundButBroken = true;
            }
            catch (IllegalArgumentException ex) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"Should not get here");
            }
        }
        return prj != null || foundButBroken;
    }
}

