/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.unit;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.EntityClassScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.util.MetadataModelReadHelper;
import org.openide.util.Exceptions;

public class AddEntityPanel
extends JPanel {
    private final MetadataModelReadHelper<EntityMappingsMetadata, List<String>> readHelper;
    private JList entityList;
    private JScrollPane jScrollPane1;

    public static AddEntityPanel create(EntityClassScope entityClassScope, Set<String> set) {
        AddEntityPanel addEntityPanel = new AddEntityPanel(entityClassScope, set);
        addEntityPanel.initialize();
        return addEntityPanel;
    }

    private AddEntityPanel(EntityClassScope entityClassScope, final Set<String> set) {
        this.initComponents();
        MetadataModel metadataModel = entityClassScope.getEntityMappingsModel(true);
        this.readHelper = MetadataModelReadHelper.create(metadataModel, new MetadataModelAction<EntityMappingsMetadata, List<String>>(){

            public List<String> run(EntityMappingsMetadata entityMappingsMetadata) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Entity entity : entityMappingsMetadata.getRoot().getEntity()) {
                    String string = entity.getClass2();
                    if (set.contains(string)) continue;
                    arrayList.add(string);
                }
                Collections.sort(arrayList);
                return arrayList;
            }
        });
    }

    private void initialize() {
        this.readHelper.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (AddEntityPanel.this.readHelper.getState() == MetadataModelReadHelper.State.FINISHED) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AddEntityPanel.this.setEntityClassModel((List)AddEntityPanel.this.readHelper.getResult());
                            }
                            catch (ExecutionException executionException) {
                                Exceptions.printStackTrace((Throwable)executionException);
                            }
                        }
                    });
                }
            }
        });
        this.readHelper.start();
    }

    private void setEntityClassModel(List<String> list) {
        assert (SwingUtilities.isEventDispatchThread());
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string : list) {
            defaultListModel.addElement(string);
        }
        this.entityList.setModel(defaultListModel);
    }

    public List<String> getSelectedEntityClasses() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object : this.entityList.getSelectedValues()) {
            arrayList.add((String)object);
        }
        return arrayList;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.entityList = new JList();
        this.jScrollPane1.setViewportView(this.entityList);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 377, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -2, 143, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

