/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.editor.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.mobility.antext.preprocessor.PPLine;
import org.netbeans.modules.mobility.editor.actions.PreprocessorEditorContextAction;
import org.netbeans.modules.mobility.editor.actions.RecommentAction;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.ErrorManager;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;

public class CreateIfElseBlockAction
extends PreprocessorEditorContextAction {
    public static final String NAME = "create-if-else-block-action";

    public CreateIfElseBlockAction() {
        super(NAME);
    }

    @Override
    public boolean isEnabled(ProjectConfigurationsHelper cfgProvider, ArrayList<PPLine> preprocessorLineList, JTextComponent target) {
        return cfgProvider != null && cfgProvider.isPreprocessorOn() && cfgProvider.getConfigurations().size() > 1 && !this.overlapsBlockBorders(target, preprocessorLineList) && !this.overlapsGuardedBlocks(target);
    }

    @Override
    public String getPopupMenuText(ProjectConfigurationsHelper cfgProvider, ArrayList<PPLine> preprocessorLineList, JTextComponent target) {
        return this.getBlock(target, preprocessorLineList) != null ? NbBundle.getMessage(CreateIfElseBlockAction.class, (String)"LBL_Create_Nested_If_Else_Block") : NbBundle.getMessage(CreateIfElseBlockAction.class, (String)"LBL_Create_If_Else_Block");
    }

    public void actionPerformed(ActionEvent evt, final JTextComponent txt) {
        ProjectConfigurationProvider prov = J2MEProjectUtils.getConfigProviderForDoc((Document)txt.getDocument());
        if (prov == null) {
            return;
        }
        NbDocument.runAtomic((StyledDocument)((StyledDocument)txt.getDocument()), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    BaseDocument doc = (BaseDocument)txt.getDocument();
                    int s = Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(CreateIfElseBlockAction.this.getSelectionStartLine(txt) - 1));
                    int e = Utilities.getRowEnd((JTextComponent)txt, (int)Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(CreateIfElseBlockAction.this.getSelectionEndLine(txt) - 1)));
                    String text = doc.getText(s, e - s);
                    doc.insertString(e, "\n//#else\n" + text + "\n//#endif", null);
                    doc.insertString(s, "//#if \n", null);
                    txt.setSelectionStart(s + 6);
                    txt.setSelectionEnd(s + 6);
                }
                catch (BadLocationException ble) {
                    ErrorManager.getDefault().notify((Throwable)ble);
                }
                RecommentAction.actionPerformed(txt);
            }
        });
        Completion.get().showCompletion();
    }
}

