/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class InstallDocSourcePanel
extends JPanel {
    private static File lastFolder = new File(System.getProperty("user.home"));
    private boolean docs;
    private JButton btnFile;
    private JLabel lblFile;
    private JTextField txtFile;

    private InstallDocSourcePanel(boolean javadoc) {
        this.initComponents();
        this.docs = javadoc;
        if (javadoc) {
            this.lblFile.setText(NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TXT_Javadoc_Loc"));
        } else {
            this.lblFile.setText(NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TXT_Sources_Loc"));
        }
    }

    boolean isJavadoc() {
        return this.docs;
    }

    private void initComponents() {
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.btnFile = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lblFile, (String)"Javadoc Location :");
        Mnemonics.setLocalizedText((AbstractButton)this.btnFile, (String)NbBundle.getMessage(InstallDocSourcePanel.class, (String)"BTN_Browse"));
        this.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallDocSourcePanel.this.btnFileActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblFile).addPreferredGap(0).add((Component)this.txtFile, -1, 247, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.btnFile).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.lblFile).add((Component)this.btnFile).add((Component)this.txtFile, -2, -1, -2)).addContainerGap(36, Short.MAX_VALUE)));
    }

    private void btnFileActionPerformed(ActionEvent evt) {
        int ret;
        File fil;
        JFileChooser chooser = new JFileChooser(lastFolder);
        chooser.setDialogTitle(this.isJavadoc() ? NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Select_javadoc_zip") : NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Select_source_zip"));
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".jar") || f.getName().toLowerCase().endsWith(".zip");
            }

            @Override
            public String getDescription() {
                return InstallDocSourcePanel.this.isJavadoc() ? NbBundle.getMessage(InstallDocSourcePanel.class, (String)"LBL_Select_javadoc_zip") : NbBundle.getMessage(InstallDocSourcePanel.class, (String)"LBL_Select_source_zip");
            }
        });
        chooser.setMultiSelectionEnabled(false);
        if (this.txtFile.getText().trim().length() > 0 && (fil = new File(this.txtFile.getText().trim())).exists()) {
            chooser.setSelectedFile(fil);
        }
        if ((ret = chooser.showDialog(SwingUtilities.getWindowAncestor(this), NbBundle.getMessage(InstallDocSourcePanel.class, (String)"BTN_Select"))) == 0) {
            this.txtFile.setText(chooser.getSelectedFile().getAbsolutePath());
            this.txtFile.requestFocusInWindow();
        }
    }

    File getFile() {
        File fil = this.txtFile.getText().trim().length() > 0 ? new File(this.txtFile.getText().trim()) : null;
        return fil != null && fil.exists() ? fil : null;
    }

    public static File showInstallDialog(boolean javadoc) {
        final InstallDocSourcePanel panel = new InstallDocSourcePanel(javadoc);
        final JButton btnSelect = new JButton(NbBundle.getMessage(InstallDocSourcePanel.class, (String)"BTN_Select"));
        btnSelect.setEnabled(panel.getFile() != null);
        panel.addDocListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                btnSelect.setEnabled(panel.getFile() != null);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                btnSelect.setEnabled(panel.getFile() != null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                btnSelect.setEnabled(panel.getFile() != null);
            }
        });
        Object[] options = new Object[]{btnSelect, NotifyDescriptor.CANCEL_OPTION};
        String tit = panel.isJavadoc() ? NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Use_local_docs") : NbBundle.getMessage(InstallDocSourcePanel.class, (String)"TIT_Use_local_source");
        DialogDescriptor dd = new DialogDescriptor((Object)panel, tit, true, options, (Object)btnSelect, 0, HelpCtx.DEFAULT_HELP, null);
        dd.setClosingOptions(options);
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (ret == btnSelect) {
            lastFolder = panel.getFile().getParentFile();
            return panel.getFile();
        }
        return null;
    }

    private void addDocListener(DocumentListener documentListener) {
        this.txtFile.getDocument().addDocumentListener(documentListener);
    }
}

