/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import hidden.org.codehaus.plexus.util.FileUtils;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.maven.actions.CreateLibraryPanel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateLibraryAction
extends AbstractAction
implements LookupListener {
    private Lookup lookup;
    private Lookup.Result<DependencyNode> result;
    private int TYPE_BINARY = 0;
    private int TYPE_JAVADOC = 1;
    private int TYPE_SOURCE = 2;

    public CreateLibraryAction(Lookup lkp) {
        this.lookup = lkp;
        this.putValue("Name", NbBundle.getMessage(CreateLibraryAction.class, (String)"ACT_Library"));
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/actions/libraries.gif", (boolean)true)));
        this.putValue("iconBase", "org/netbeans/modules/maven/actions/libraries.gif");
        this.result = this.lookup.lookupResult(DependencyNode.class);
        this.setEnabled(this.result.allInstances().size() > 0);
        this.result.addLookupListener((LookupListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterator roots = this.result.allInstances().iterator();
        if (!roots.hasNext()) {
            return;
        }
        DependencyNode root = (DependencyNode)roots.next();
        final MavenProject project = (MavenProject)this.lookup.lookup(MavenProject.class);
        final CreateLibraryPanel pnl = new CreateLibraryPanel(root);
        DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(CreateLibraryPanel.class, (String)"LBL_CreateLibrary"));
        pnl.createValidations(dd);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    Library lib = CreateLibraryAction.this.createLibrary(pnl.getLibraryManager(), pnl.getLibraryName(), pnl.getIncludeArtifacts(), pnl.isAllSourceAndJavadoc(), project, pnl.getCopyDirectory());
                    if (lib != null) {
                        LibrariesCustomizer.showCustomizer((Library)lib, (LibraryManager)pnl.getLibraryManager());
                    }
                }
            });
        }
    }

    public void resultChanged(LookupEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateLibraryAction.this.setEnabled(CreateLibraryAction.this.result.allInstances().size() > 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Library createLibrary(LibraryManager libraryManager, String libraryName, List<Artifact> includeArtifacts, boolean allSourceAndJavadoc, MavenProject project, String copyTo) {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Create_Library"));
        int count = includeArtifacts.size() * (allSourceAndJavadoc ? 3 : 1) + 5;
        handle.start(count);
        try {
            MavenEmbedder online = EmbedderFactory.getOnlineEmbedder();
            int index = 1;
            ArrayList<Artifact> failed = new ArrayList<Artifact>();
            ArrayList<URI> classpathVolume = new ArrayList<URI>();
            ArrayList<URI> javadocVolume = new ArrayList<URI>();
            ArrayList<URI> sourceVolume = new ArrayList<URI>();
            HashMap<String, ArrayList<URI>> volumes = new HashMap<String, ArrayList<URI>>();
            File baseFolder = null;
            File nonDefaultLibBase = null;
            if (copyTo != null) {
                URL libRoot = libraryManager.getLocation();
                File base = null;
                if (libRoot != null) {
                    try {
                        base = new File(libRoot.toURI());
                        nonDefaultLibBase = base = base.getParentFile();
                    }
                    catch (URISyntaxException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        base = new File(System.getProperty("netbeans.user"), "libraries");
                    }
                } else {
                    base = new File(System.getProperty("netbeans.user"), "libraries");
                }
                base = FileUtil.normalizeFile((File)base);
                baseFolder = FileUtilities.resolveFilePath(base, copyTo);
                baseFolder.mkdirs();
            }
            volumes.put("classpath", classpathVolume);
            if (allSourceAndJavadoc) {
                volumes.put("javadoc", javadocVolume);
                volumes.put("src", sourceVolume);
            }
            for (Artifact a : includeArtifacts) {
                handle.progress(NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Downloading", (Object)a.getId()), index);
                try {
                    online.resolve(a, project.getRemoteArtifactRepositories(), online.getLocalRepository());
                    classpathVolume.add(this.getJarUri(a, baseFolder, nonDefaultLibBase, this.TYPE_BINARY));
                    try {
                        if (allSourceAndJavadoc) {
                            handle.progress(NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Downloading_javadoc", (Object)a.getId()), index + 1);
                            Artifact javadoc = online.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), "javadoc");
                            online.resolve(javadoc, project.getRemoteArtifactRepositories(), online.getLocalRepository());
                            if (javadoc.getFile().exists()) {
                                URI javadocUri = this.getJarUri(javadoc, baseFolder, nonDefaultLibBase, this.TYPE_JAVADOC);
                                javadocVolume.add(javadocUri);
                            }
                            handle.progress(NbBundle.getMessage(CreateLibraryAction.class, (String)"MSG_Downloading_sources", (Object)a.getId()), index + 2);
                            Artifact sources = online.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), "sources");
                            online.resolve(sources, project.getRemoteArtifactRepositories(), online.getLocalRepository());
                            if (sources.getFile().exists()) {
                                sourceVolume.add(this.getJarUri(sources, baseFolder, nonDefaultLibBase, this.TYPE_SOURCE));
                            }
                        }
                    }
                    catch (Exception ex) {
                        Logger.getLogger(CreateLibraryAction.class.getName()).log(Level.FINE, "Failed to download artifact", ex);
                    }
                }
                catch (Exception ex) {
                    failed.add(a);
                    Logger.getLogger(CreateLibraryAction.class.getName()).log(Level.FINE, "Failed to download artifact", ex);
                }
                index += allSourceAndJavadoc ? 3 : 1;
            }
            try {
                handle.progress("Adding library", index + 4);
                Library i$ = libraryManager.createURILibrary("j2se", libraryName, volumes);
                return i$;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                handle.finish();
            }
        }
        finally {
            handle.finish();
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    URI getJarUri(Artifact a, File copyTo, File nonDefaultLibBase, int type) throws IOException {
        FileObject srcRoot;
        File res = a.getFile();
        URI uri = res.toURI();
        String jarPath = null;
        if (copyTo != null) {
            String path;
            res = new File(copyTo, a.getFile().getName());
            FileUtils.copyFile((File)a.getFile(), (File)res);
            if (nonDefaultLibBase != null && (path = FileUtilities.getRelativePath(nonDefaultLibBase, res)) != null) {
                uri = LibrariesSupport.convertFilePathToURI((String)path);
            }
        }
        FileUtil.refreshFor((File[])new File[]{res});
        FileObject fo = FileUtil.toFileObject((File)res);
        if (type == this.TYPE_JAVADOC && FileUtil.isArchiveFile((FileObject)fo)) {
            FileObject docRoot = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)(fo = FileUtil.getArchiveRoot((FileObject)fo)));
            if (docRoot != null) {
                jarPath = FileUtil.getRelativePath((FileObject)fo, (FileObject)docRoot);
            }
        } else if (type == this.TYPE_SOURCE && FileUtil.isArchiveFile((FileObject)fo) && (srcRoot = JavadocAndSourceRootDetection.findSourceRoot((FileObject)(fo = FileUtil.getArchiveRoot((FileObject)fo)))) != null) {
            jarPath = FileUtil.getRelativePath((FileObject)fo, (FileObject)srcRoot);
        }
        return CreateLibraryAction.appendJarFolder(uri, jarPath);
    }
}

