/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.File;
import java.io.IOException;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.util.Utils;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    public File getFileRevision(File base, String revision) throws IOException {
        if (revision.equals("-1")) {
            return null;
        }
        File repository = Mercurial.getInstance().getRepositoryRoot(base);
        if ("LOCAL".equals(revision)) {
            return base;
        }
        try {
            File tempFile = new File(Utils.getTempFolder(), "nb-hg-" + base.getName());
            tempFile.deleteOnExit();
            if ("BASE".equals(revision)) {
                HgCommand.doCat(repository, base, tempFile, null);
            } else {
                HgCommand.doCat(repository, base, tempFile, revision, null);
            }
            if (tempFile.length() == 0L) {
                tempFile.delete();
                return null;
            }
            return tempFile;
        }
        catch (HgException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }
}

