/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.dataobjects;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelAccessor;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public class AsmObjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(AsmObjectUtilities.class.getName());

    public static Document getDocument(DataObject dob) {
        EditorCookie editorCookie = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            LOGGER.log(Level.INFO, "Can't determine document");
            return null;
        }
        return editorCookie.getDocument();
    }

    public static Document getDocument(JTextComponent pane) {
        return pane.getDocument();
    }

    public static AsmModel getModel(DataObject dob) {
        Document doc = AsmObjectUtilities.getDocument(dob);
        if (doc == null) {
            LOGGER.log(Level.INFO, "Can't determine model for " + dob);
            return null;
        }
        return (AsmModel)doc.getProperty(AsmModel.class);
    }

    public static AsmModelAccessor getAccessor(DataObject dob) {
        Document doc = AsmObjectUtilities.getDocument(dob);
        if (doc == null) {
            return null;
        }
        return AsmObjectUtilities.getAccessor(doc);
    }

    public static AsmModelAccessor getAccessor(Document doc) {
        return (AsmModelAccessor)doc.getProperty(AsmModelAccessor.class);
    }

    public static AsmModelAccessor getAccessor(JTextComponent pane) {
        Document doc = AsmObjectUtilities.getDocument(pane);
        return AsmObjectUtilities.getAccessor(doc);
    }

    public static String getText(final Document doc) {
        final String[] text = new String[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    text[0] = doc.getLength() == 0 ? "" : doc.getText(0, doc.getLength() - 1);
                }
                catch (BadLocationException ex) {
                    text[0] = "";
                    LOGGER.log(Level.INFO, "Impossible error with getText()");
                }
            }
        });
        return text[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getText(FileObject fo) {
        if (fo == null) {
            return "";
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(fo.getInputStream());
            InputStreamReader reader = new InputStreamReader(is);
            String string = new String(AsmObjectUtilities.readContents(reader));
            return string;
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Can't load FileObject text " + ex.getMessage());
            String string = "";
            return string;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Can't load FileObject text " + ex.getMessage());
                return "";
            }
        }
    }

    public static char[] readContents(Reader r) throws IOException {
        int offset;
        char[] buf;
        int READ_BY = 1024;
        LinkedList<char[]> list = new LinkedList<char[]>();
        int count = 0;
        int wasRead = 0;
        while ((wasRead = r.read(buf = new char[1024], offset = 0, buf.length)) != -1) {
            if ((offset += wasRead) > 0) {
                list.add(buf);
            }
            count += offset;
            if (wasRead >= 0) continue;
        }
        r.close();
        char[] res = new char[count];
        Iterator it = list.iterator();
        int offset2 = 0;
        while (it.hasNext()) {
            char[] buf2 = (char[])it.next();
            int size = it.hasNext() ? buf2.length : count - offset2;
            System.arraycopy(buf2, 0, res, offset2, size);
            offset2 += size;
        }
        return res;
    }

    public static void goToSource(DataObject ob, int offset) {
        if (!AsmObjectUtilities.openFileInEditor(ob)) {
            return;
        }
        EditorCookie ed = (EditorCookie)ob.getCookie(EditorCookie.class);
        if (ed != null) {
            try {
                ed.openDocument();
            }
            catch (IOException ex) {
                return;
            }
            JEditorPane pane = ed.getOpenedPanes()[0];
            pane.setCaretPosition(offset);
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, pane);
            if (tc != null) {
                tc.requestActive();
            }
        }
    }

    public static boolean openFileInEditor(DataObject ob) {
        EditCookie ck = (EditCookie)ob.getCookie(EditCookie.class);
        if (ck != null) {
            ck.edit();
            return true;
        }
        OpenCookie oc = (OpenCookie)ob.getCookie(OpenCookie.class);
        if (oc != null) {
            oc.open();
            return true;
        }
        return false;
    }
}

