/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public class CndFileVisibilityQuery
implements VisibilityQueryImplementation2,
ChangeListener {
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static CndFileVisibilityQuery INSTANCE = new CndFileVisibilityQuery();
    private Pattern acceptedFilesPattern = null;
    private static final String DEFAULT_IGNORE_BYNARY_PATTERN = ".*\\.(o|so|a|dll|dylib|lib|lo|la|Po|Plo)$";
    private Pattern ignoredFilesPattern = Pattern.compile(".*\\.(o|so|a|dll|dylib|lib|lo|la|Po|Plo)$");

    private CndFileVisibilityQuery() {
        MIMEExtensions.get((String)"text/x-c").addChangeListener((ChangeListener)this);
        MIMEExtensions.get((String)"text/x-c++").addChangeListener((ChangeListener)this);
        MIMEExtensions.get((String)"text/x-h").addChangeListener((ChangeListener)this);
    }

    public static CndFileVisibilityQuery getDefault() {
        return INSTANCE;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.acceptedFilesPattern = null;
        this.cs.fireChange();
    }

    public boolean isVisible(FileObject file) {
        return this.isVisible(file.getNameExt());
    }

    public boolean isVisible(File file) {
        return this.isVisible(file.getName());
    }

    boolean isVisible(String fileName) {
        Pattern pattern = this.getAcceptedFilesPattern();
        return pattern != null ? pattern.matcher(fileName).find() : true;
    }

    public boolean isIgnored(File file) {
        return this.isIgnored(file.getName());
    }

    public boolean isIgnored(String fileName) {
        return this.ignoredFilesPattern.matcher(fileName).find();
    }

    public void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    private List<Collection<String>> getAcceptedFilesExtensions() {
        ArrayList<Collection<String>> suffixes = new ArrayList<Collection<String>>();
        suffixes.add(MIMEExtensions.get((String)"text/x-c").getValues());
        suffixes.add(MIMEExtensions.get((String)"text/x-c++").getValues());
        suffixes.add(MIMEExtensions.get((String)"text/x-h").getValues());
        return suffixes;
    }

    private Pattern getAcceptedFilesPattern() {
        if (this.acceptedFilesPattern == null) {
            List<Collection<String>> acceptedFileExtensions = this.getAcceptedFilesExtensions();
            StringBuilder pat = new StringBuilder();
            for (Collection<String> col : acceptedFileExtensions) {
                for (String s : col) {
                    if (pat.length() > 0) {
                        pat.append('|');
                    }
                    if (s.indexOf(43) >= 0) {
                        s = s.replace("+", "\\+");
                    }
                    pat.append(s);
                }
                String ignoredFiles = ".*\\.(" + pat.toString() + ")$";
                this.acceptedFilesPattern = Pattern.compile(ignoredFiles);
            }
        }
        return this.acceptedFilesPattern;
    }
}

