/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.InstanceListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.LogHyperLinkSupport;
import org.openide.ErrorManager;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;

public final class LogViewerSupport
extends Thread {
    private InputOutput io;
    private String url;
    private static final HashMap logsMap = new HashMap();
    private long sampleInterval = 10000L;
    private File logfile;
    private boolean startAtBeginning = false;
    private boolean working = false;
    private LogHyperLinkSupport.AppServerLogSupport logSupport;
    private BufferedReader reader = null;
    private boolean initRingerDone = false;
    private static int OLD_LINES = 600;
    private static int MAX_LINES = 25000;
    private static int LINES = 2000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogViewerSupport getLogViewerSupport(File file, final String string, long l, boolean bl) {
        HashMap hashMap = logsMap;
        synchronized (hashMap) {
            LogViewerSupport logViewerSupport = (LogViewerSupport)logsMap.get(string);
            if (logViewerSupport == null) {
                logViewerSupport = new LogViewerSupport(file, string, l, bl);
                logsMap.put(string, logViewerSupport);
            }
            logViewerSupport.sampleInterval = l;
            logViewerSupport.startAtBeginning = bl;
            Deployment.getDefault().addInstanceListener(new InstanceListener(){

                public void instanceAdded(String string2) {
                }

                public void instanceRemoved(String string2) {
                    if (string2 != null && string2.equals(string)) {
                        LogViewerSupport.removeLogViewerSupport(string);
                        Deployment.getDefault().removeInstanceListener((InstanceListener)this);
                    }
                }
            });
            return logViewerSupport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLogViewerSupport(String string) {
        HashMap hashMap = logsMap;
        synchronized (hashMap) {
            LogViewerSupport logViewerSupport = (LogViewerSupport)logsMap.get(string);
            if (logViewerSupport != null) {
                logsMap.remove(string);
                logViewerSupport.working = false;
            }
        }
    }

    private LogViewerSupport(File file, String string, long l, boolean bl) {
        this.logfile = file;
        this.url = string;
        this.sampleInterval = l;
        this.startAtBeginning = bl;
        this.io = UISupport.getServerIO((String)string);
        this.logSupport = new LogHyperLinkSupport.AppServerLogSupport("", "/");
        this.setDaemon(true);
        this.start();
    }

    protected void printLine(String string) {
        String string2 = this.filterLine(string);
        if (!string2.equals("") && !string2.equals(" ")) {
            LogHyperLinkSupport.LineInfo lineInfo = this.logSupport.analyzeLine(string2);
            if (lineInfo.isError()) {
                if (lineInfo.isAccessible()) {
                    try {
                        this.io.getOut().println(string2, (OutputListener)this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                } else {
                    this.io.getOut().println(string2);
                }
            } else {
                this.io.getOut().println(string2);
            }
        }
    }

    public void stopTailing() {
        this.working = false;
    }

    private void initRingBuffer(Ring ring) {
        block9: {
            try {
                if (this.reader != null) {
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    this.reader = null;
                }
                if (!this.logfile.exists()) break block9;
                this.reader = new BufferedReader(new FileReader(this.logfile));
                try {
                    String string;
                    while ((string = this.reader.readLine()) != null) {
                        ring.add(string);
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (this.startAtBeginning) {
                    ring.output(null);
                }
                ring.setMaxCount(LINES);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long l = 0L;
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.startsWith(LogViewerSupport.this.logfile.getName());
            }
        };
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        this.working = true;
        int n = 0;
        Ring ring = new Ring(OLD_LINES);
        try {
            long l2 = 0L;
            if (null == this.logfile || !this.logfile.exists()) {
                this.working = false;
            } else {
                l2 = this.logfile.getParentFile().list(filenameFilter).length;
                l = this.logfile.length();
            }
            while (this.working) {
                bl = true;
                try {
                    String string;
                    if (!this.initRingerDone) {
                        this.initRingBuffer(ring);
                        l = this.logfile.length();
                        this.initRingerDone = true;
                    }
                    if (n >= MAX_LINES) {
                        this.io.getOut().reset();
                        n = ring.output(null);
                    }
                    long l3 = this.logfile.length();
                    long l4 = this.logfile.getParentFile().list(filenameFilter).length;
                    if (l3 < l) {
                        bl2 = true;
                    }
                    if (l2 < l4) {
                        bl2 = true;
                        l2 = l4;
                    }
                    if (bl2) {
                        try {
                            String string2 = string = this.reader != null ? this.reader.readLine() : null;
                            if (string != null) {
                                bl3 = false;
                            }
                            while (string != null) {
                                this.printLine(string);
                                ring.add(string);
                                string = this.reader.readLine();
                                ++n;
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                            bl2 = true;
                        }
                        if (!bl3) {
                            this.printLine("----Log File Rotated---");
                            bl3 = true;
                        }
                        try {
                            if (this.reader != null) {
                                this.reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                        if (this.logfile.exists()) {
                            this.reader = new BufferedReader(new FileReader(this.logfile));
                            l = 0L;
                            bl2 = false;
                        } else {
                            this.reader = null;
                        }
                    }
                    try {
                        String string3 = string = this.reader != null ? this.reader.readLine() : null;
                        if (string != null) {
                            bl3 = false;
                        }
                        while (string != null) {
                            this.printLine(string);
                            ring.add(string);
                            string = this.reader.readLine();
                            ++n;
                        }
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        bl = false;
                        bl2 = true;
                    }
                    l = this.logfile.length();
                    l2 = this.logfile.getParentFile().list().length;
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                    this.working = true;
                }
                finally {
                    try {
                        LogViewerSupport logViewerSupport = this;
                        synchronized (logViewerSupport) {
                            if (bl) {
                                this.wait(100L);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            this.working = false;
        }
        finally {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
            }
        }
    }

    private String filterLine(String string) {
        if (!string.startsWith("[#")) {
            if (string.endsWith("|#]")) {
                string = string.substring(0, string.length() - 3);
            }
            return string;
        }
        String[] stringArray = string.split("\\|");
        if (stringArray == null) {
            return string;
        }
        if (stringArray.length <= 6) {
            return "";
        }
        return stringArray[6];
    }

    public InputOutput showLogViewer(boolean bl) throws IOException {
        this.io = UISupport.getServerIO((String)this.url);
        this.working = true;
        if (bl && this.io.isClosed()) {
            this.initRingerDone = false;
            this.io.getOut().reset();
        }
        this.io.select();
        return this.io;
    }

    private class Ring {
        private int maxCount;
        private int count;
        private LinkedList anchor;

        public Ring(int n) {
            this.maxCount = n;
            this.count = 0;
            this.anchor = new LinkedList();
        }

        public String add(String string) {
            if (string == null || string.equals("")) {
                return null;
            }
            while (this.count >= this.maxCount) {
                this.anchor.removeFirst();
                --this.count;
            }
            this.anchor.addLast(string);
            ++this.count;
            return string;
        }

        public void setMaxCount(int n) {
            this.maxCount = n;
        }

        public int output(String string) {
            int n = 0;
            Iterator iterator = this.anchor.iterator();
            if (null != string) {
                LogViewerSupport.this.printLine("<<<<<<<<<<<<<<<<<<<<<<<<<<<< " + string);
            }
            while (iterator.hasNext()) {
                LogViewerSupport.this.printLine((String)iterator.next());
                ++n;
            }
            if (null != string) {
                LogViewerSupport.this.printLine(">>>>>>>>>>>>>>>>>>>>>>>>>>>> " + string);
            }
            return n;
        }

        public void reset() {
            this.anchor = new LinkedList();
        }
    }
}

