/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.wizard.AdditionalLibrariesListPanel;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class ProviderControl {
    private ProviderProperty property;
    private String propertyKey;
    private String description;
    private JLabel label;
    private JComboBox field;
    private JButton button;
    private int chooserMode = 0;
    private JPanel panel;
    private ChangeListener listener;

    public ProviderControl(String key, ProviderProperty property, DiscoveryDescriptor wizardDescriptor, JPanel panel, ChangeListener listener) {
        this.propertyKey = key;
        this.property = property;
        this.panel = panel;
        this.listener = listener;
        this.description = property.getDescription();
        this.label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.label, (String)property.getName());
        switch (property.getKind()) {
            case MakeLogFile: {
                this.field = new JComboBox();
                this.field.setEditable(true);
                this.chooserMode = 0;
                this.initBuildOrRoot(wizardDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.rootFolderButtonActionPerformed(evt, ProviderControl.this.property.getKind() == ProviderProperty.PropertyKind.BinaryFile, ProviderControl.this.getString("LOG_FILE_CHOOSER_TITLE_TXT"));
                    }
                });
                this.addListeners();
                break;
            }
            case BinaryFile: {
                this.field = new JComboBox();
                this.field.setEditable(true);
                this.chooserMode = 0;
                this.initBuildOrRoot(wizardDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.rootFolderButtonActionPerformed(evt, ProviderControl.this.property.getKind() == ProviderProperty.PropertyKind.BinaryFile, ProviderControl.this.getString("BINARY_FILE_CHOOSER_TITLE_TXT"));
                    }
                });
                this.addListeners();
                break;
            }
            case Folder: {
                this.field = new JComboBox();
                this.field.setEditable(true);
                this.chooserMode = 1;
                this.initRoot(wizardDescriptor);
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_BROWSE_BUTTON_TXT"));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.rootFolderButtonActionPerformed(evt, true, ProviderControl.this.getString("ROOT_DIR_CHOOSER_TITLE_TXT"));
                    }
                });
                this.addListeners();
                break;
            }
            case BinaryFiles: {
                this.field = new JComboBox();
                this.field.setEditable(true);
                this.chooserMode = 0;
                this.initArray();
                this.button = new JButton();
                Mnemonics.setLocalizedText((AbstractButton)this.button, (String)this.getString("ROOT_DIR_EDIT_BUTTON_TXT"));
                this.layout(panel);
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ProviderControl.this.additionalLibrariesButtonActionPerformed(evt);
                    }
                });
                this.addListeners();
                break;
            }
        }
    }

    private void initBuildOrRoot(DiscoveryDescriptor wizardDescriptor) {
        Object val = this.property.getValue();
        String output = null;
        if (val instanceof String) {
            output = (String)val;
        }
        if (output != null && output.length() > 0) {
            this.initFields(output);
            return;
        }
        output = wizardDescriptor.getBuildResult();
        if (output != null && output.length() > 0) {
            this.initFields(output);
            return;
        }
        this.initFields(wizardDescriptor.getRootFolder());
    }

    private void initRoot(DiscoveryDescriptor wizardDescriptor) {
        Object val = this.property.getValue();
        String output = null;
        if (val instanceof String) {
            output = (String)val;
        }
        if (output != null && output.length() > 0) {
            this.initFields(output);
            return;
        }
        this.initFields(wizardDescriptor.getRootFolder());
    }

    private void initArray() {
        Object val = this.property.getValue();
        if (val instanceof String[]) {
            StringBuilder buf = new StringBuilder();
            for (String s : (String[])val) {
                if (buf.length() > 0) {
                    buf.append(';');
                }
                buf.append(s);
            }
            this.initFields(buf.toString());
        } else {
            this.initFields("");
        }
    }

    private void initComboBox(String root) {
        ArrayList<String> vector = new ArrayList<String>();
        vector.add(root);
        Preferences prefs = NbPreferences.forModule(ProviderControl.class);
        String old = prefs.get(this.propertyKey, "");
        StringTokenizer st = new StringTokenizer(old, "\u0000");
        int history = 5;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (vector.contains(s)) continue;
            vector.add(s);
            if (--history != 0) continue;
            break;
        }
        DefaultComboBoxModel<Object> rootModel = new DefaultComboBoxModel<Object>(vector.toArray());
        this.field.setModel(rootModel);
    }

    private void addListeners() {
        this.field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProviderControl.this.update();
            }
        });
        ComboBoxEditor editor = this.field.getEditor();
        Component component = editor.getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    ProviderControl.this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    ProviderControl.this.update();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    ProviderControl.this.update();
                }
            });
        }
    }

    private void update() {
        this.listener.stateChanged(null);
    }

    public void store() {
        switch (this.property.getKind()) {
            case MakeLogFile: 
            case BinaryFile: 
            case Folder: {
                this.property.setValue(this.getComboBoxText());
                this.storeHistory();
                break;
            }
            case BinaryFiles: {
                String text = this.getComboBoxText();
                StringTokenizer st = new StringTokenizer(text, ";");
                ArrayList<String> list = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    list.add(st.nextToken());
                }
                this.property.setValue(list.toArray(new String[list.size()]));
                this.storeHistory();
                break;
            }
        }
    }

    private void storeHistory() {
        ArrayList<String> vector = new ArrayList<String>();
        vector.add(this.getComboBoxText());
        for (int i = 0; i < this.field.getModel().getSize(); ++i) {
            String s = this.field.getModel().getElementAt(i).toString();
            if (vector.contains(s)) continue;
            vector.add(s);
        }
        StringBuilder buf = new StringBuilder();
        for (String s : vector) {
            if (buf.length() > 0) {
                buf.append('\u0000');
            }
            buf.append(s);
        }
        Preferences prefs = NbPreferences.forModule(ProviderControl.class);
        prefs.put(this.propertyKey, buf.toString());
    }

    public boolean valid() {
        String path = this.getComboBoxText();
        switch (this.property.getKind()) {
            case Folder: {
                if (path.length() == 0) {
                    return false;
                }
                File file = new File(path);
                if (!file.exists() || !file.isDirectory()) break;
                return true;
            }
            case MakeLogFile: 
            case BinaryFile: {
                if (path.length() == 0) {
                    return false;
                }
                File file = new File(path);
                if (!file.exists() || !file.isFile()) break;
                return true;
            }
            case BinaryFiles: {
                String text = this.getComboBoxText();
                StringTokenizer st = new StringTokenizer(text, ";");
                while (st.hasMoreTokens()) {
                    path = st.nextToken();
                    if (path.length() == 0) {
                        return false;
                    }
                    File file = new File(path);
                    if (file.exists() && file.isFile()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private void layout(JPanel panel) {
        GridBagConstraints gridBagConstraints = null;
        this.label.setLabelFor(this.field);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        panel.add((Component)this.label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        panel.add((Component)this.field, gridBagConstraints);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 35; ++i) {
            buf.append("w");
        }
        this.field.setPrototypeDisplayValue(buf.toString());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        panel.add((Component)this.button, gridBagConstraints);
    }

    private void additionalLibrariesButtonActionPerformed(ActionEvent evt) {
        StringTokenizer tokenizer = new StringTokenizer(this.getComboBoxText(), ";");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        AdditionalLibrariesListPanel libPanel = new AdditionalLibrariesListPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)AdditionalLibrariesListPanel.wrapPanel(libPanel), this.getString("ADDITIONAL_LIBRARIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            List newList = libPanel.getListData();
            StringBuilder includes = new StringBuilder();
            for (int i = 0; i < newList.size(); ++i) {
                if (i > 0) {
                    includes.append(';');
                }
                includes.append((String)newList.get(i));
            }
            this.field.setSelectedItem(includes.toString());
        }
    }

    private void rootFolderButtonActionPerformed(ActionEvent evt, boolean isBinary, String title) {
        FileChooser fileChooser;
        int ret;
        FileFilter[] filters = null;
        if (this.chooserMode == 0) {
            filters = isBinary ? (Utilities.isWindows() ? new FileFilter[]{FileFilterFactory.getPeExecutableFileFilter(), FileFilterFactory.getElfStaticLibraryFileFilter(), FileFilterFactory.getPeDynamicLibraryFileFilter()} : (Utilities.getOperatingSystem() == 4096 ? new FileFilter[]{FileFilterFactory.getMacOSXExecutableFileFilter(), FileFilterFactory.getElfStaticLibraryFileFilter(), FileFilterFactory.getMacOSXDynamicLibraryFileFilter()} : new FileFilter[]{FileFilterFactory.getElfExecutableFileFilter(), FileFilterFactory.getElfStaticLibraryFileFilter(), FileFilterFactory.getElfDynamicLibraryFileFilter()})) : new FileFilter[]{new LogFileFilter()};
        }
        if ((ret = (fileChooser = new FileChooser(title, this.getString("ROOT_DIR_BUTTON_TXT"), this.chooserMode, filters, this.getComboBoxText(), false)).showOpenDialog(this.panel)) == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        this.field.setSelectedItem(path);
    }

    private String getComboBoxText() {
        Component component;
        ComboBoxEditor editor = this.field.getEditor();
        if (editor != null && (component = editor.getEditorComponent()) instanceof JTextField) {
            return ((JTextField)component).getText();
        }
        if (this.field.getSelectedItem() != null) {
            return this.field.getSelectedItem().toString();
        }
        return null;
    }

    private void initFields(String path) {
        if (path == null) {
            this.initComboBox("");
        } else {
            if (Utilities.isWindows()) {
                path = path.replace('/', File.separatorChar);
            }
            this.initComboBox(path);
        }
    }

    private String getString(String key) {
        return NbBundle.getBundle(ProviderControl.class).getString(key);
    }

    private class LogFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return ProviderControl.this.getString("FILECHOOSER_MAK_LOG_FILEFILTER");
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".log");
            }
            return false;
        }
    }
}

