/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class ViewAdminConsoleAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        GlassfishModule commonSupport = (GlassfishModule)activatedNodes[0].getLookup().lookup(GlassfishModule.class);
        if (commonSupport != null) {
            if (commonSupport.getServerState() == GlassfishModule.ServerState.RUNNING) {
                try {
                    Map<String, String> ip = commonSupport.getInstanceProperties();
                    StringBuilder urlBuilder = new StringBuilder(128);
                    String port = !"false".equals(System.getProperty("glassfish.useadminport")) ? ip.get("adminPort") : ip.get("httpportnumber");
                    String host = ip.get("host");
                    urlBuilder.append(Utils.getHttpListenerProtocol(host, port));
                    urlBuilder.append("://");
                    urlBuilder.append(ip.get("host"));
                    urlBuilder.append(":");
                    urlBuilder.append(port);
                    if ("false".equals(System.getProperty("glassfish.useadminport"))) {
                        urlBuilder.append("/admin");
                    }
                    URL url = new URL(urlBuilder.toString());
                    HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
                }
            } else {
                String message = NbBundle.getMessage(ViewAdminConsoleAction.class, (String)"MSG_ServerMustBeRunning");
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, -1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return NbBundle.getMessage(ViewAdminConsoleAction.class, (String)"CTL_ViewAdminConsoleAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

