/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactory;
import org.netbeans.napi.gsfret.source.support.OpenedEditors;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;

public abstract class CaretAwareSourceTaskFactory
extends SourceTaskFactory {
    private static final int DEFAULT_RESCHEDULE_TIMEOUT = 300;
    private static final RequestProcessor WORKER = new RequestProcessor("CaretAwareSourceTaskFactory worker");
    private int timeout;
    private Map<JTextComponent, ComponentListener> component2Listener = new HashMap<JTextComponent, ComponentListener>();
    private static Map<FileObject, Integer> file2LastPosition = new WeakHashMap<FileObject, Integer>();

    public CaretAwareSourceTaskFactory(Phase phase, Source.Priority priority) {
        super(phase, priority);
        OpenedEditors.getDefault().addChangeListener(new ChangeListenerImpl());
        this.timeout = 300;
    }

    public List<FileObject> getFileObjects() {
        ArrayList<FileObject> files = new ArrayList<FileObject>(OpenedEditors.getDefault().getVisibleEditorsFiles());
        return files;
    }

    public static synchronized int getLastPosition(FileObject file) {
        if (file == null) {
            throw new NullPointerException("Cannot pass null file!");
        }
        Integer position = file2LastPosition.get(file);
        if (position == null) {
            return 0;
        }
        return position;
    }

    static synchronized void setLastPosition(FileObject file, int position) {
        file2LastPosition.put(file, position);
    }

    private class ComponentListener
    implements CaretListener {
        private JTextComponent component;
        private final RequestProcessor.Task rescheduleTask;

        public ComponentListener(JTextComponent component) {
            this.component = component;
            this.rescheduleTask = WORKER.create(new Runnable(){

                @Override
                public void run() {
                    FileObject file = OpenedEditors.getFileObject(ComponentListener.this.component);
                    if (file != null) {
                        CaretAwareSourceTaskFactory.setLastPosition(file, ComponentListener.this.component.getCaretPosition());
                        CaretAwareSourceTaskFactory.this.reschedule(file);
                    }
                }
            });
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            FileObject file = OpenedEditors.getFileObject(this.component);
            if (file != null) {
                CaretAwareSourceTaskFactory.setLastPosition(file, this.component.getCaretPosition());
                this.rescheduleTask.schedule(CaretAwareSourceTaskFactory.this.timeout);
            }
        }
    }

    private class ChangeListenerImpl
    implements ChangeListener {
        private ChangeListenerImpl() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ArrayList<JTextComponent> added = new ArrayList<JTextComponent>(OpenedEditors.getDefault().getVisibleEditors());
            ArrayList removed = new ArrayList(CaretAwareSourceTaskFactory.this.component2Listener.keySet());
            added.removeAll(CaretAwareSourceTaskFactory.this.component2Listener.keySet());
            removed.removeAll(OpenedEditors.getDefault().getVisibleEditors());
            for (JTextComponent c : removed) {
                c.removeCaretListener((CaretListener)CaretAwareSourceTaskFactory.this.component2Listener.remove(c));
            }
            for (JTextComponent c : added) {
                ComponentListener l = new ComponentListener(c);
                c.addCaretListener(l);
                CaretAwareSourceTaskFactory.this.component2Listener.put(c, l);
                CaretAwareSourceTaskFactory.setLastPosition(OpenedEditors.getFileObject(c), c.getCaretPosition());
            }
            CaretAwareSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

