/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.parsing;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.util.Comparator;
import org.netbeans.modules.gsf.api.ParserFile;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class FileObjects {
    public static final Comparator<String> SIMPLE_NAME_STRING_COMPARATOR = new SimpleNameStringComparator();
    public static final Comparator<FileObject> SIMPLE_NAME_FILEOBJECT_COMPARATOR = new SimpleNameFileObjectComparator();
    public static final String JAR = "jar";
    public static final String FILE = "file";
    public static final String ZIP = "zip";
    public static final String HTML = "html";
    public static final String SIG = "sig";
    public static final String RS = "rs";
    static final String encodingName = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();

    private FileObjects() {
    }

    public static ParserFile fileFileObject(File file, File root, boolean platform, Object filter) {
        assert (file != null);
        assert (root != null);
        return new FileParserFile(file, root, platform);
    }

    public static String stripExtension(String fileName) {
        int dot = fileName.lastIndexOf(".");
        return dot == -1 ? fileName : fileName.substring(0, dot);
    }

    public static String getName(FileObject fo, boolean noExt) {
        assert (fo != null);
        return noExt ? fo.getName() : fo.getNameExt();
    }

    public static String getBaseName(String fileName) {
        return FileObjects.getBaseName(fileName, File.separatorChar);
    }

    public static String getBaseName(String fileName, char separator) {
        return FileObjects.getFolderAndBaseName(fileName, separator)[1];
    }

    public static String[] getFolderAndBaseName(String fileName, char separator) {
        int i = fileName.lastIndexOf(separator);
        if (i == -1) {
            return new String[]{"", fileName};
        }
        return new String[]{fileName.substring(0, i), fileName.substring(i + 1)};
    }

    public static String getBinaryName(File file, File root) {
        assert (file != null && root != null);
        String fileName = FileObjects.getRelativePath(root, file);
        int index = fileName.lastIndexOf(46);
        if (index > 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName.replace(File.separatorChar, '.');
    }

    public static String getSimpleName(FileObject fo) {
        String name = FileObjects.getName(fo, true);
        int i = name.lastIndexOf(36);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String getSimpleName(String fileName) {
        String name = FileObjects.getBaseName(fileName);
        int i = name.lastIndexOf(36);
        if (i == -1) {
            return name;
        }
        return name.substring(i + 1);
    }

    public static String convertPackage2Folder(String packageName) {
        return packageName.replace('.', '/');
    }

    public static String convertFolder2Package(String packageName) {
        return FileObjects.convertFolder2Package(packageName, '/');
    }

    public static String convertFolder2Package(String packageName, char folderSeparator) {
        return packageName.replace(folderSeparator, '.');
    }

    public static String getRelativePath(String packageName, String relativeName) {
        StringBuilder relativePath = new StringBuilder();
        relativePath.append(packageName.replace('.', '/'));
        relativePath.append(relativeName);
        return relativePath.toString();
    }

    public static String[] getParentRelativePathAndName(String className) {
        if (className.charAt(className.length() - 1) == '.') {
            return null;
        }
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return new String[]{"", className};
        }
        return new String[]{className.substring(0, index).replace('.', '/'), className.substring(index + 1)};
    }

    public static File getRootFile(URL url) {
        File rootFile = JAR.equals(url.getProtocol()) ? new File(URI.create(FileUtil.getArchiveFile((URL)url).toExternalForm())) : new File(URI.create(url.toExternalForm()));
        return rootFile;
    }

    public static void deleteRecursively(File folder) {
        File[] children;
        assert (folder != null);
        if (folder.isDirectory() && (children = folder.listFiles()) != null) {
            for (File file : children) {
                FileObjects.deleteRecursively(file);
            }
        }
        folder.delete();
    }

    public static String getRelativePath(File root, File fo) {
        int foIndex;
        String rootPath = root.getAbsolutePath();
        String foPath = fo.getAbsolutePath();
        assert (foPath.startsWith(rootPath));
        int index = rootPath.length();
        if (rootPath.charAt(index - 1) != File.separatorChar) {
            ++index;
        }
        if ((foIndex = foPath.length()) <= index) {
            return "";
        }
        return foPath.substring(index);
    }

    private static class SimpleNameFileObjectComparator
    implements Comparator<FileObject> {
        private SimpleNameFileObjectComparator() {
        }

        @Override
        public int compare(FileObject o1, FileObject o2) {
            String n1 = FileObjects.getSimpleName(o1);
            String n2 = FileObjects.getSimpleName(o2);
            return n1.compareTo(n2);
        }
    }

    private static class SimpleNameStringComparator
    implements Comparator<String> {
        private SimpleNameStringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return FileObjects.getSimpleName(o1).compareTo(FileObjects.getSimpleName(o2));
        }
    }

    public static class InvalidFileException
    extends IOException {
        public InvalidFileException() {
        }

        public InvalidFileException(FileObject fo) {
            super(NbBundle.getMessage(FileObjects.class, (String)"FMT_InvalidFile", (Object)FileUtil.getFileDisplayName((FileObject)fo)));
        }
    }

    private static class FileParserFile
    implements ParserFile {
        private File file;
        private File root;
        private FileObject fileObject;
        private String relative;
        private boolean platform;

        private FileParserFile(File file, File root, boolean platform) {
            this.file = file;
            this.root = root;
            this.platform = platform;
        }

        public FileObject getFileObject() {
            if (this.fileObject == null) {
                this.fileObject = FileUtil.toFileObject((File)this.file);
            }
            return this.fileObject;
        }

        public String getRelativePath() {
            if (this.relative == null) {
                this.relative = FileObjects.getRelativePath(this.root, this.file);
            }
            return this.relative;
        }

        public String getNameExt() {
            return this.file.getName();
        }

        public String getExtension() {
            String name = this.file.getName();
            int index = name.lastIndexOf(46);
            if (index != -1) {
                return name.substring(index + 1);
            }
            return "";
        }

        public String toString() {
            return "FileParserFile(" + this.getNameExt() + ")";
        }

        public boolean isPlatform() {
            return this.platform;
        }

        public File getFile() {
            return this.file;
        }
    }
}

