/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelOptionsVisual;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelProjectLocationExtSrc;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.NbBundle;

public class PanelConfigureProjectVisual
extends JPanel {
    private PanelConfigureProject panel;
    private SettingsPanel projectLocationPanel;
    private PanelOptionsVisual optionsPanel;
    private int type;
    private JSeparator jSeparator1;
    private JPanel locationContainer;
    private JPanel optionsContainer;

    public PanelConfigureProjectVisual(PanelConfigureProject panel, int type) {
        this.panel = panel;
        this.initComponents();
        this.type = type;
        this.setName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NameAndLoc"));
        if (type == 0) {
            this.projectLocationPanel = new PanelProjectLocationVisual(panel, type);
            this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NewRoRApp"));
            this.jSeparator1.setVisible(true);
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_NewRoRApp"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"ACSD_NewRoRApp"));
        } else {
            this.projectLocationPanel = new PanelProjectLocationExtSrc(panel);
            this.jSeparator1.setVisible(true);
            this.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_RoRExtSourcesProjectLocation"));
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"TXT_RoRExtSourcesProjectLocation"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"ACSD_RoRExtSourcesProjectLocation"));
        }
        this.locationContainer.add((Component)this.projectLocationPanel, "Center");
        this.optionsPanel = new PanelOptionsVisual(panel);
        this.projectLocationPanel.addPropertyChangeListener(this.optionsPanel);
        this.optionsContainer.add((Component)this.optionsPanel, "Center");
    }

    RubyPlatform getPlatform() {
        return this.optionsPanel.getPlatform();
    }

    boolean needWarSupport() {
        return this.optionsPanel.needWarSupport();
    }

    Object getServer() {
        return this.optionsPanel.getServer();
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        if (!this.optionsPanel.valid(wizardDescriptor)) {
            return false;
        }
        if (!this.checkWarbler(wizardDescriptor)) {
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        return this.projectLocationPanel.valid(wizardDescriptor) && this.optionsPanel.valid(wizardDescriptor);
    }

    private boolean checkWarbler(WizardDescriptor descriptor) {
        if (!(this.projectLocationPanel instanceof PanelProjectLocationExtSrc)) {
            return true;
        }
        if (!this.needWarSupport()) {
            return true;
        }
        RubyPlatform platform = this.getPlatform();
        GemManager gemManager = platform.getGemManager();
        if (gemManager != null && gemManager.isGemInstalled("warbler")) {
            return true;
        }
        descriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelConfigureProjectVisual.class, (String)"MSG_InstallWarbler"));
        return false;
    }

    void read(WizardDescriptor d) {
        Integer lastType = (Integer)d.getProperty("rails-wizard-type");
        if (lastType == null || lastType != this.type) {
            d.putProperty("name", null);
            d.putProperty("projdir", null);
            d.putProperty("platform", null);
        }
        this.projectLocationPanel.read(d);
        this.optionsPanel.read(d);
    }

    void store(WizardDescriptor d) {
        d.putProperty("rails-wizard-type", (Object)new Integer(this.type));
        this.projectLocationPanel.store(d);
        this.optionsPanel.store(d);
    }

    void validate(WizardDescriptor d) throws WizardValidationException {
        this.projectLocationPanel.validate(d);
    }

    private void initComponents() {
        this.locationContainer = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.optionsContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.locationContainer.setLayout(new BorderLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.locationContainer, gridBagConstraints);
        this.locationContainer.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSN_locationContainer"));
        this.locationContainer.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSD_locationContainer"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.optionsContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.optionsContainer, gridBagConstraints);
        this.optionsContainer.getAccessibleContext().setAccessibleName(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSN_optionsContainer"));
        this.optionsContainer.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(PanelConfigureProjectVisual.class).getString("ACSD_optionsContainer"));
    }
}

