/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.server;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.platform.gems.Gem;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.RailsProjectUtil;
import org.netbeans.modules.ruby.railsprojects.server.GlassFishGem;
import org.netbeans.modules.ruby.railsprojects.server.RailsApplication;
import org.netbeans.modules.ruby.railsprojects.server.RailsUrlDisplayer;
import org.netbeans.modules.ruby.railsprojects.server.RubyServer;
import org.netbeans.modules.ruby.railsprojects.server.ServerRegistry;
import org.netbeans.modules.ruby.railsprojects.server.ServerResolver;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class RailsServerManager {
    private static final Logger LOGGER = Logger.getLogger(RailsServerManager.class.getName());
    private static final Set<Integer> IN_USE_PORTS = new HashSet<Integer>();
    private static final int SERVER_STARTUP_TIMEOUT = 120000;
    private ServerStatus status = ServerStatus.NOT_STARTED;
    private RubyServer server;
    private RubyInstance instance;
    private boolean portConflict;
    private int originalPort;
    private int port = -1;
    private final RailsProject project;
    private RailsProjectUtil.RailsVersion version;
    private Future<Integer> execution;
    private File dir;
    private String projectName;
    private boolean debug;
    private boolean clientDebug;
    private boolean switchToDebugMode;
    private Semaphore debugSemaphore;
    private static boolean useHttpValidation = Boolean.parseBoolean(System.getProperty("rails.server.http.validation"));

    public RailsServerManager(RailsProject project) {
        this.project = project;
        this.dir = FileUtil.toFile((FileObject)project.getProjectDirectory());
    }

    public synchronized void setDebug(boolean debug) {
        if (this.status == ServerStatus.RUNNING && !this.debug && debug) {
            this.switchToDebugMode = true;
        }
        this.debug = debug;
    }

    public void setClientDebug(boolean clientDebug) {
        this.clientDebug = clientDebug;
    }

    private synchronized RailsProjectUtil.RailsVersion getRailsVersion() {
        if (this.version == null) {
            this.version = RailsProjectUtil.getRailsVersion((Project)this.project);
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureRunning() {
        RubyInstance explicitlySpecified;
        RailsServerManager railsServerManager = this;
        synchronized (railsServerManager) {
            if (this.projectName == null) {
                this.projectName = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
            }
            if (this.status == ServerStatus.STARTING) {
                return false;
            }
            if (this.status == ServerStatus.RUNNING) {
                if (this.switchToDebugMode) {
                    if (!RailsServerManager.isPluginServer(this.instance)) {
                        assert (this.debugSemaphore == null) : "startSemaphor supposed to be null";
                        this.debugSemaphore = new Semaphore(0);
                    }
                    this.switchToDebugMode = false;
                } else if (RailsServerManager.isPortInUse(this.port)) {
                    if (!this.debug && RailsServerManager.isPluginServer(this.instance)) {
                        if (this.port == this.instance.getRailsPort()) {
                            this.status = ServerStatus.STARTING;
                            this.glassfishEnsureRunning(null);
                            return false;
                        }
                    } else {
                        return true;
                    }
                }
            }
        }
        if (this.debugSemaphore != null) {
            try {
                if (this.execution != null) {
                    this.execution.cancel(true);
                }
                this.debugSemaphore.acquire();
                this.debugSemaphore = null;
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        RailsServerManager ex = this;
        synchronized (ex) {
            this.status = ServerStatus.STARTING;
        }
        this.projectName = ((ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
        String classPath = this.project.evaluator().getProperty("javac.classpath");
        String jvmArgs = this.project.evaluator().getProperty("jvm.args");
        String serverId = this.project.evaluator().getProperty("rails.servertype");
        RubyPlatform platform = RubyPlatform.platformFor((Project)this.project);
        RubyInstance candidateInstance = ServerRegistry.getDefault().getServer(serverId, platform);
        if (candidateInstance == null) {
            List<RubyInstance> availableServers = ServerRegistry.getDefault().getServers();
            for (RubyInstance each : availableServers) {
                if (!each.isPlatformSupported(platform)) continue;
                candidateInstance = each;
                break;
            }
            assert (candidateInstance != null) : "No servers found for " + platform;
        }
        this.instance = candidateInstance;
        if (RailsServerManager.isPluginServer(this.instance)) {
            if (!this.debug) {
                this.glassfishEnsureRunning(platform);
                return false;
            }
            if (serverId.contains("]deployer:gfv3ee6:")) {
                String newInstanceID = "GLASSFISH";
                this.instance = ServerRegistry.getDefault().getServer("GLASSFISH", platform);
                String gemName = "glassfish";
                Gem gem = new Gem(gemName, null, null);
                Gem[] gems = new Gem[]{gem};
                GemManager gemManager = platform.getGemManager();
                if (!gemManager.isGemInstalled(gemName)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RailsServerManager.class, (String)"MSG_DOWNLOAD_GEM_FOR_DEBUG", (Object)gemName)));
                    final RubyPlatform myplatform = platform;
                    platform.getGemManager().install(gems, null, false, false, null, true, true, new Runnable(){

                        @Override
                        public void run() {
                            myplatform.recomputeRoots();
                            RailsServerManager.this.instance = ServerRegistry.getDefault().getServer("GLASSFISH", myplatform);
                        }
                    });
                } else {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RailsServerManager.class, (String)"MSG_USE_GEM_FOR_DEBUG", (Object)gemName)));
                }
            } else {
                this.ensurePortAvailable();
                String displayName = NbBundle.getMessage(RailsServerManager.class, (String)"LBL_ServerTab", (Object)this.instance.getDisplayName(), (Object)this.projectName, (Object)Integer.toString(this.port));
                RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, this.dir, "unknown");
                desc.cmd(this.getJavaExecutable());
                desc.useInterpreter(false);
                desc.initialArgs(this.instance.getServerCommand(platform, classPath, this.dir, this.port, this.debug));
                desc.postBuild(this.getFinishAction());
                desc.jvmArguments(jvmArgs);
                desc.addStandardRecognizers();
                desc.frontWindow(false);
                desc.debug(this.debug);
                desc.fastDebugRequired(this.debug);
                desc.fileLocator((LineConvertors.FileLocator)new DirectoryFileLocator(FileUtil.toFileObject((File)this.dir)));
                desc.showSuspended(true);
                this.runServer(desc, displayName, new GrizzlyServerLineConvertor(this.instance));
                return false;
            }
        }
        if ((explicitlySpecified = ServerResolver.getExplicitlySpecifiedServer(this.project)) instanceof RubyServer) {
            this.server = (RubyServer)explicitlySpecified;
            this.instance = explicitlySpecified;
        } else {
            this.server = (RubyServer)this.instance;
        }
        this.ensurePortAvailable();
        String displayName = RailsServerManager.getServerTabName(this.server, this.projectName, this.port);
        String serverPath = this.server.getServerPath(this.getRailsVersion());
        RubyExecutionDescriptor desc = new RubyExecutionDescriptor(platform, displayName, this.dir, serverPath);
        String gemPath = this.server.getLocation();
        if (gemPath != null) {
            desc.initialArgs("-I \"" + gemPath + "/" + "bin\" " + "-I \"" + gemPath + "/" + "lib\"");
        }
        desc.scriptPrefix(this.server.getScriptPrefix());
        desc.additionalArgs(this.buildStartupArgs());
        desc.postBuild(this.getFinishAction());
        desc.jvmArguments(jvmArgs);
        desc.classPath(classPath);
        desc.addStandardRecognizers();
        desc.frontWindow(false);
        desc.debug(this.debug);
        desc.fastDebugRequired(this.debug);
        desc.fileLocator((LineConvertors.FileLocator)new DirectoryFileLocator(FileUtil.toFileObject((File)this.dir)));
        desc.showSuspended(true);
        RubyCoverageProvider coverageProvider = RubyCoverageProvider.get((Project)this.project);
        if (coverageProvider != null && coverageProvider.isEnabled()) {
            desc = coverageProvider.wrapWithCoverage(desc, false, null);
        }
        this.runServer(desc, displayName, new RailsServerLineConverter(this.server));
        return false;
    }

    private void runServer(RubyExecutionDescriptor desc, String displayName, LineConvertor ... convertors) {
        IN_USE_PORTS.add(this.port);
        String charsetName = this.project.evaluator().getProperty("source.encoding");
        for (LineConvertor each : convertors) {
            desc.addOutConvertor(each);
        }
        for (LineConvertor each : convertors) {
            desc.addErrConvertor(each);
        }
        RubyProcessCreator rpc = new RubyProcessCreator(desc, charsetName);
        ExecutionService executionService = ExecutionService.newService((Callable)rpc, (ExecutionDescriptor)desc.toExecutionDescriptor(), (String)displayName);
        this.execution = executionService.run();
    }

    private String[] buildStartupArgs() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.server.getStartupParams(this.getRailsVersion()));
        String railsEnv = this.project.evaluator().getProperty("rails.env");
        if (railsEnv != null && !"".equals(railsEnv.trim())) {
            result.add("-e");
            result.add(railsEnv);
        }
        if (this.server instanceof GlassFishGem) {
            GlassFishGem gfGem = (GlassFishGem)this.server;
            if (gfGem.compareVersion("0.9.5") >= 0) {
                result.add("--log");
            }
            if (gfGem.compareVersion("0.9.0") >= 0) {
                result.add("--port");
                result.add(Integer.toString(this.port));
            }
            result.add(this.dir.getAbsolutePath());
        } else {
            result.add("--port");
            result.add(Integer.toString(this.port));
        }
        String extraArgs = this.project.evaluator().getProperty("rails.serverargs");
        if (extraArgs != null) {
            for (String arg : Utilities.parseParameters((String)extraArgs)) {
                result.add(arg);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    private void ensurePortAvailable() {
        this.portConflict = false;
        String portString = this.project.evaluator().getProperty("rails.port");
        LOGGER.fine("Port number in project properties:" + portString);
        this.port = 0;
        if (portString != null) {
            this.port = Integer.parseInt(portString);
        }
        if (this.port == 0) {
            this.port = 3000;
        }
        this.originalPort = this.port;
        while (RailsServerManager.isPortInUse(this.port)) {
            ++this.port;
        }
    }

    private Runnable getFinishAction() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                    if (RailsServerManager.this.server != null) {
                        RailsServerManager.this.server.removeApplication(RailsServerManager.this.port);
                    }
                    IN_USE_PORTS.remove(RailsServerManager.this.port);
                    if (RailsServerManager.this.portConflict) {
                        RailsServerManager.this.notifyPortConflict();
                    }
                    if (RailsServerManager.this.debugSemaphore != null) {
                        RailsServerManager.this.debugSemaphore.release();
                    } else {
                        RailsServerManager.this.debug = false;
                    }
                }
            }
        };
    }

    private File getJavaExecutable() {
        String javaPath = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + (Utilities.isWindows() ? "java.exe" : "java");
        File javaExe = new File(javaPath);
        if (!javaExe.exists()) {
            LOGGER.log(Level.SEVERE, "Unable to locate java executable: " + javaPath);
        }
        return javaExe;
    }

    private static boolean isPluginServer(RubyInstance instance) {
        return instance != null && !(instance instanceof RubyServer);
    }

    private static String getServerTabName(RubyServer server, String projectName, int port) {
        return NbBundle.getMessage(RailsServerManager.class, (String)"LBL_ServerTab", (Object)server.getDisplayName(), (Object)projectName, (Object)String.valueOf(port));
    }

    private void notifyPortConflict() {
        String message = NbBundle.getMessage(RailsServerManager.class, (String)"Conflict", (Object)Integer.toString(this.originalPort));
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private String getContextRoot() {
        if (!this.debug && this.instance != null) {
            return this.instance.getContextRoot(this.projectName);
        }
        return "";
    }

    public void showUrl(final String relativeUrl) {
        if (this.ensureRunning()) {
            RailsUrlDisplayer.showURL(this.getContextRoot(), relativeUrl, this.port, this.clientDebug, this.project);
        } else {
            String displayName = NbBundle.getMessage(RailsServerManager.class, (String)"ServerStartup");
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)displayName, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    return true;
                }
            }, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            });
            handle.start();
            handle.switchToIndeterminate();
            final boolean runClientDebug = this.clientDebug;
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        int i;
                        int delay = 20;
                        for (i = 0; i <= 120000; i += delay) {
                            try {
                                Thread.sleep(delay);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            RailsServerManager railsServerManager = RailsServerManager.this;
                            synchronized (railsServerManager) {
                                block14: {
                                    if (RailsServerManager.this.status != ServerStatus.RUNNING) break block14;
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Server " + (RailsServerManager.this.server != null ? RailsServerManager.this.server : RailsServerManager.this.instance) + " started in " + (i + 500) / 1000 + " seconds.");
                                    }
                                    RailsUrlDisplayer.showURL(RailsServerManager.this.getContextRoot(), relativeUrl, RailsServerManager.this.port, runClientDebug, RailsServerManager.this.project);
                                    return;
                                }
                                if (RailsServerManager.this.status == ServerStatus.NOT_STARTED) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.fine("Server startup failed, server type is: " + (RailsServerManager.this.server != null ? RailsServerManager.this.server : RailsServerManager.this.instance));
                                    }
                                    break;
                                }
                                continue;
                            }
                        }
                        LOGGER.fine("Could not start " + (RailsServerManager.this.server != null ? RailsServerManager.this.server : RailsServerManager.this.instance) + " in " + (i + 500) / 1000 + " seconds, current server status is " + (Object)((Object)RailsServerManager.this.status));
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(RailsServerManager.class, (String)"NoServerFound", (Object)("http://localhost:" + RailsServerManager.this.port + "/" + relativeUrl)));
                    }
                    finally {
                        handle.finish();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkIsPortInUseUsingServerSocket(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, "Port " + port + " is in use.", ex);
            boolean bl = true;
            return bl;
        }
        finally {
            if (serverSocket != null && !serverSocket.isClosed()) {
                try {
                    serverSocket.close();
                }
                catch (IOException ex) {
                    LOGGER.log(Level.FINE, "Exception while closing ServerSocked in port " + port, ex);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean isPortInUse(int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void glassfishEnsureRunning(RubyPlatform platform) {
        final Future<RubyInstance.OperationState> result = platform != null ? this.instance.runApplication(platform, this.projectName, this.dir) : this.instance.deploy(this.projectName, this.dir);
        final RubyInstance serverInstance = this.instance;
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block12: {
                    try {
                        RubyInstance.OperationState state = (RubyInstance.OperationState)((Object)result.get(120L, TimeUnit.SECONDS));
                        if (state == RubyInstance.OperationState.COMPLETED) {
                            RailsServerManager railsServerManager = RailsServerManager.this;
                            synchronized (railsServerManager) {
                                RailsServerManager.this.port = serverInstance.getRailsPort();
                                RailsServerManager.this.status = ServerStatus.RUNNING;
                                break block12;
                            }
                        }
                        RailsServerManager railsServerManager = RailsServerManager.this;
                        synchronized (railsServerManager) {
                            RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, ex.getMessage(), ex);
                        RailsServerManager railsServerManager = RailsServerManager.this;
                        synchronized (railsServerManager) {
                            RailsServerManager.this.status = ServerStatus.NOT_STARTED;
                        }
                    }
                }
            }
        });
    }

    static boolean isAddressInUseMsg(String outputLine) {
        return outputLine.matches(".*in.*: Address.+in use.+(Errno::EADDRINUSE).*");
    }

    private class GrizzlyServerLineConvertor
    implements LineConvertor {
        private RubyInstance server;

        GrizzlyServerLineConvertor(RubyInstance server) {
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List<ConvertedLine> convert(String line) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Processing output line: " + line);
            }
            if (this.isStartupMsg(line)) {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    LOGGER.fine("Identified " + this.server + " as running");
                    RailsServerManager.this.status = ServerStatus.RUNNING;
                }
            } else if (this.isAddressInUseMsg(line)) {
                LOGGER.fine("Detected port conflict: " + line);
                RailsServerManager.this.portConflict = true;
            }
            return null;
        }

        private boolean isStartupMsg(String line) {
            return line.contains("Grizzly configuration for port");
        }

        private boolean isAddressInUseMsg(String line) {
            return line.contains("BindException");
        }
    }

    private class RailsServerLineConverter
    implements LineConvertor {
        private final RubyServer server;

        RailsServerLineConverter(RubyServer server) {
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized List<ConvertedLine> convert(String line) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Processing output line: " + line);
            }
            if (this.server.isStartupMsg(line)) {
                RailsServerManager railsServerManager = RailsServerManager.this;
                synchronized (railsServerManager) {
                    LOGGER.fine("Identified " + this.server + " as running");
                    RailsServerManager.this.status = ServerStatus.RUNNING;
                    String projectName = ((ProjectInformation)RailsServerManager.this.project.getLookup().lookup(ProjectInformation.class)).getDisplayName();
                    this.server.addApplication(new RailsApplication(projectName, RailsServerManager.this.port, RailsServerManager.this.execution));
                }
            } else if (RailsServerManager.isAddressInUseMsg(line)) {
                LOGGER.fine("Detected port conflict: " + line);
                RailsServerManager.this.portConflict = true;
            }
            return null;
        }
    }

    static enum ServerStatus {
        NOT_STARTED,
        STARTING,
        RUNNING;

    }
}

