/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.openide.util.Exceptions;

final class GemFilter {
    private static final Logger LOGGER = Logger.getLogger(GemFilter.class.getName());
    private static final Pattern GEM_EXCLUDE_FILTER;
    private static final Pattern GEM_INCLUDE_FILTER;
    private final PropertyEvaluator evaluator;
    private final Pattern includeFilter;
    private final Pattern excludeFilter;

    GemFilter(PropertyEvaluator evaluator) {
        this.evaluator = evaluator;
        String include = evaluator.getProperty("ruby.includegems");
        String exclude = evaluator.getProperty("ruby.excludegems");
        this.includeFilter = GemFilter.getPattern(include, GEM_INCLUDE_FILTER);
        this.excludeFilter = GemFilter.getPattern(exclude, GEM_EXCLUDE_FILTER);
    }

    private static Pattern getPattern(String regex, Pattern defaultValue) {
        if (regex == null) {
            return defaultValue;
        }
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException pse) {
            Exceptions.printStackTrace((Throwable)pse);
            return defaultValue;
        }
    }

    boolean include(String gem) {
        if (this.includeFilter == null) {
            return true;
        }
        return this.includeFilter.matcher(gem).find();
    }

    boolean exclude(String gem) {
        if (this.excludeFilter == null) {
            return true;
        }
        return this.excludeFilter.matcher(gem).find();
    }

    static {
        String userExcludes = System.getProperty("rails.prj.excludegems");
        GEM_EXCLUDE_FILTER = userExcludes == null || "none".equals(userExcludes) ? null : GemFilter.getPattern(userExcludes, null);
        String userIncludes = System.getProperty("rails.prj.includegems");
        GEM_INCLUDE_FILTER = userIncludes == null || "all".equals(userIncludes) ? null : GemFilter.getPattern(userIncludes, null);
    }
}

