/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.SourceRoots;
import org.netbeans.modules.ruby.railsprojects.classpath.BootClassPathImplementation;
import org.netbeans.modules.ruby.railsprojects.classpath.GroupClassPathImplementation;
import org.netbeans.modules.ruby.railsprojects.classpath.JavascriptsClassPathImplementation;
import org.netbeans.modules.ruby.railsprojects.classpath.SourcePathImplementation;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
implements ClassPathProvider,
PropertyChangeListener {
    private static final String JAVAC_CLASSPATH = "javac.classpath";
    private static final String JAVAC_TEST_CLASSPATH = "javac.test.classpath";
    private static final String RUN_CLASSPATH = "run.classpath";
    private static final String RUN_TEST_CLASSPATH = "run.test.classpath";
    private final RakeProjectHelper helper;
    private final File projectDirectory;
    private final PropertyEvaluator evaluator;
    private final SourceRoots sourceRoots;
    private final SourceRoots testSourceRoots;
    private final Map<ClassPathCache, ClassPath> cache = new EnumMap<ClassPathCache, ClassPath>(ClassPathCache.class);
    private final Map<String, FileObject> dirCache = new HashMap<String, FileObject>();
    private final RailsProject project;

    public ClassPathProviderImpl(RailsProject project, RakeProjectHelper helper, PropertyEvaluator evaluator, SourceRoots sourceRoots, SourceRoots testSourceRoots) {
        this.project = project;
        this.helper = helper;
        this.projectDirectory = FileUtil.toFile((FileObject)helper.getProjectDirectory());
        assert (this.projectDirectory != null);
        this.evaluator = evaluator;
        this.sourceRoots = sourceRoots;
        this.testSourceRoots = testSourceRoots;
        evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)evaluator));
    }

    private synchronized FileObject getDir(String propname) {
        String prop;
        FileObject fo = this.dirCache.get(propname);
        if (!(fo != null && fo.isValid() || (prop = this.evaluator.getProperty(propname)) == null)) {
            fo = this.helper.resolveFileObject(prop);
            this.dirCache.put(propname, fo);
        }
        return fo;
    }

    private FileObject[] getPrimarySrcPath() {
        return this.sourceRoots.getRoots();
    }

    private ClassPath getJavascriptsWebClassPath() {
        ClassPath cp = this.cache.get((Object)ClassPathCache.JAVASCRIPT);
        if (cp == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new JavascriptsClassPathImplementation(this.projectDirectory));
            this.cache.put(ClassPathCache.JAVASCRIPT, cp);
            return cp;
        }
        return cp;
    }

    private FileObject[] getTestSrcDir() {
        return this.testSourceRoots.getRoots();
    }

    private FileType getType(FileObject file) {
        for (FileObject root : this.testSourceRoots.getRoots()) {
            if (!root.equals(file) && !FileUtil.isParentOf((FileObject)root, (FileObject)file)) continue;
            return FileType.TEST;
        }
        return FileType.SOURCE;
    }

    private synchronized ClassPath getSourcepath(FileObject file) {
        FileType type = this.getType(file);
        return this.getSourcepath(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassPath getSourcepath(FileType type) {
        ClassPath cp = null;
        Map<ClassPathCache, ClassPath> map = this.cache;
        synchronized (map) {
            cp = this.cache.get((Object)type.getCacheType());
            if (cp == null) {
                switch (type) {
                    case SOURCE: {
                        cp = ClassPathFactory.createClassPath((ClassPathImplementation)new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator));
                        break;
                    }
                    case TEST: {
                        cp = ClassPathFactory.createClassPath((ClassPathImplementation)new GroupClassPathImplementation(new SourcePathImplementation[]{new SourcePathImplementation(this.testSourceRoots), new SourcePathImplementation(this.sourceRoots, this.helper, this.evaluator)}));
                    }
                }
                this.cache.put(type.getCacheType(), cp);
            }
        }
        return cp;
    }

    private synchronized ClassPath getBootClassPath(FileType type) {
        ClassPath cp = this.cache.get((Object)type.getBootCacheType());
        if (cp == null) {
            cp = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImplementation(this.project, this.projectDirectory, this.evaluator, type == FileType.TEST));
            this.cache.put(type.getBootCacheType(), cp);
        }
        return cp;
    }

    private synchronized ClassPath getBootClassPath(FileObject file) {
        FileType type = this.getType(file);
        return this.getBootClassPath(type);
    }

    public ClassPath findClassPath(FileObject file, String type) {
        if (type.equals("ruby/classpath/source")) {
            return this.getSourcepath(file);
        }
        if (type.equals("ruby/classpath/boot")) {
            return this.getBootClassPath(file);
        }
        if (type.equals("ruby/classpath/compile")) {
            return this.getBootClassPath(file);
        }
        if (type.equals("js/library")) {
            return this.getJavascriptsWebClassPath();
        }
        return null;
    }

    public ClassPath[] getProjectClassPaths(String type) {
        ClassPath[] result = new ClassPath[2];
        if ("ruby/classpath/boot".equals(type)) {
            result[0] = this.getBootClassPath(FileType.SOURCE);
            result[1] = this.getBootClassPath(FileType.TEST);
        } else if ("ruby/classpath/source".equals(type)) {
            result[0] = this.getSourcepath(FileType.SOURCE);
            result[1] = this.getSourcepath(FileType.TEST);
        } else {
            return null;
        }
        return result;
    }

    public ClassPath getProjectSourcesClassPath(String type) {
        if ("ruby/classpath/boot".equals(type)) {
            return this.getBootClassPath(FileType.SOURCE);
        }
        if ("ruby/classpath/source".equals(type)) {
            return this.getSourcepath(FileType.SOURCE);
        }
        return null;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        this.dirCache.remove(evt.getPropertyName());
    }

    public String getPropertyName(SourceGroup sg, String type) {
        int i;
        FileObject root = sg.getRootFolder();
        FileObject[] path = this.getPrimarySrcPath();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("ruby/classpath/compile".equals(type)) {
                return JAVAC_CLASSPATH;
            }
            if ("ruby/classpath/execute".equals(type)) {
                return RUN_CLASSPATH;
            }
            return null;
        }
        path = this.getTestSrcDir();
        for (i = 0; i < path.length; ++i) {
            if (!root.equals(path[i])) continue;
            if ("ruby/classpath/compile".equals(type)) {
                return JAVAC_TEST_CLASSPATH;
            }
            if ("ruby/classpath/execute".equals(type)) {
                return RUN_TEST_CLASSPATH;
            }
            return null;
        }
        return null;
    }

    static enum FileType {
        SOURCE,
        TEST;


        public ClassPathCache getCacheType() {
            return this == TEST ? ClassPathCache.TEST : ClassPathCache.SOURCE;
        }

        public ClassPathCache getBootCacheType() {
            return this == TEST ? ClassPathCache.BOOT_TEST : ClassPathCache.BOOT;
        }
    }

    private static enum ClassPathCache {
        BOOT,
        BOOT_TEST,
        SOURCE,
        TEST,
        JAVASCRIPT;

    }
}

