/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.visual.widget.Scene;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ExportAction
extends AbstractAction
implements Presenter.Popup {
    private static final String EXTENSION = "png";
    private Scene scene;
    private JComponent parent;
    private JMenuItem menuItem;

    public ExportAction(Scene scene, JComponent parent) {
        this.scene = scene;
        this.parent = parent;
        this.putValue("Name", this.getString("Export"));
        this.menuItem = new JMenuItem(this);
        Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
    }

    public JMenuItem getPopupPresenter() {
        return this.menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.print();
    }

    private void print() {
        BufferedImage bi = new BufferedImage(this.scene.getBounds().width, this.scene.getBounds().height, 6);
        Graphics2D graphics = bi.createGraphics();
        this.scene.paint(graphics);
        graphics.dispose();
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(this.getString("ExportGraph"));
        chooser.setDialogType(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(0);
        chooser.setFileFilter(new MyFileFilter());
        if (chooser.showSaveDialog(this.parent) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (!file.getName().toLowerCase().endsWith(".png")) {
            file = new File(file.getParentFile(), file.getName() + "." + EXTENSION);
        }
        if (file.exists()) {
            String message = this.getString("FileExistsMessage");
            DialogDescriptor descriptor = new DialogDescriptor((Object)MessageFormat.format(message, file.getAbsolutePath()), this.getString("FileExists"), true, 0, DialogDescriptor.NO_OPTION, null);
            DialogDisplayer.getDefault().createDialog(descriptor).setVisible(true);
            if (descriptor.getValue() != DialogDescriptor.YES_OPTION) {
                return;
            }
        }
        try {
            ImageIO.write((RenderedImage)bi, EXTENSION, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getString(String key) {
        return NbBundle.getMessage(this.getClass(), (String)key);
    }

    private static class MyFileFilter
    extends FileFilter {
        private MyFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".png");
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(ExportAction.class, (String)"PNG");
        }
    }
}

