/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.diff.AbstractDiffSetup;
import org.netbeans.modules.versioning.diff.DiffLookup;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.diff.EditorSaveCookie;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffFileTable;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffNode;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.netbeans.modules.versioning.util.DelegatingUndoRedo;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class MultiDiffPanel
extends JPanel
implements ActionListener,
VersioningListener,
DiffSetupSource,
PropertyChangeListener,
PreferenceChangeListener {
    private Setup[] setups;
    private EditorCookie[] editorCookies;
    private final DiffLookup lookup = new DiffLookup();
    private final DelegatingUndoRedo delegatingUndoRedo = new DelegatingUndoRedo();
    private final Context context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentIndex = -1;
    private int currentModelIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private RequestProcessor.Task refreshTask;
    private ExecutorGroup group;
    private volatile boolean executed;
    private JComponent diffView;
    private DiffFileTable fileTable;
    private boolean dividerSet;
    private final PlaceholderPanel diffViewPanel;
    private JComponent infoPanelLoadingFromRepo;
    private boolean fileTableSetSelectedIndexContext;
    private JToggleButton allToggle;
    private JButton commitButton;
    private JToolBar controlsToolBar;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JToggleButton localToggle;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JToggleButton remoteToggle;
    private JSplitPane splitPane;
    private JButton updateButton;

    public MultiDiffPanel(Context context, int initialType, String contextName, ExecutorGroup group) {
        this.context = context;
        this.contextName = contextName;
        this.group = group;
        this.currentType = initialType;
        this.diffViewPanel = null;
        this.initComponents();
        this.initFileTable();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.refreshTask = Utils.createTask((Runnable)new RefreshViewTask());
        if (CvsModuleConfig.getDefault().getPreferences().getBoolean("autoDiffRefresh", true)) {
            this.onRefreshButton();
        } else {
            this.refreshTask.schedule(0);
        }
        this.refreshComponents();
    }

    public MultiDiffPanel(File file, String rev1, String rev2) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.initToolbarButtons();
        this.initNextPrevActions();
        this.diffViewPanel = new PlaceholderPanel();
        this.diffViewPanel.setComponent((Component)this.getInfoPanelLoading());
        this.replaceVerticalSplitPane((JComponent)this.diffViewPanel);
        AbstractDiffSetup[] localSetups = new Setup[]{new Setup(file, rev1, rev2)};
        this.setSetups((Setup[])localSetups, DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])localSetups));
        this.setDiffIndex(0, 0, false);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = CvsVersioningSystem.getInstance().getRequestProcessor().post((Runnable)this.dpt);
    }

    private void replaceVerticalSplitPane(JComponent replacement) {
        this.removeAll();
        this.splitPane = null;
        this.setLayout(new BorderLayout());
        this.controlsToolBar.setPreferredSize(new Dimension(Short.MAX_VALUE, 25));
        this.add((Component)this.controlsToolBar, "North");
        this.add((Component)replacement, "Center");
    }

    private void setSetups(Setup[] setups, EditorCookie[] cookies) {
        this.setups = setups;
        this.editorCookies = cookies;
    }

    public void tableRowSelected(int viewIndex) {
        if (this.fileTableSetSelectedIndexContext) {
            return;
        }
        this.setDiffIndex(viewIndex, 0, true);
    }

    UndoRedo getUndoRedo() {
        return this.delegatingUndoRedo;
    }

    private void cancelBackgroundTasks() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    boolean canClose() {
        if (this.setups == null) {
            return true;
        }
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        DiffUtils.cleanThoseWithEditorPaneOpen((EditorCookie[])editorCookiesCopy);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        return saveCookies.length == 0 || SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies);
    }

    private static SaveCookie[] getSaveCookies(Setup[] setups, EditorCookie[] editorCookies) {
        assert (setups.length == editorCookies.length);
        int length = setups.length;
        Object[] proResult = new SaveCookie[length];
        int count = 0;
        for (int i = 0; i < length; ++i) {
            FileObject fileObj;
            File baseFile;
            EditorCookie editorCookie = editorCookies[i];
            if (editorCookie == null || (baseFile = setups[i].getBaseFile()) == null || (fileObj = FileUtil.toFileObject((File)baseFile)) == null) continue;
            proResult[count++] = new EditorSaveCookie(editorCookie, fileObj.getNameExt());
        }
        return (SaveCookie[])CollectionUtils.shortenArray((Object[])proResult, (int)count);
    }

    void componentClosed() {
        this.setSetups(null, null);
        this.prevAction.setEnabled(false);
        this.nextAction.setEnabled(false);
        this.cancelBackgroundTasks();
    }

    public synchronized void setGroup(ExecutorGroup group) {
        this.group = group;
        if (this.executed && group != null) {
            group.executed();
        }
    }

    void requestActive() {
        if (this.fileTable != null) {
            this.fileTable.getTable().requestFocusInWindow();
        } else if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void initFileTable() {
        this.fileTable = new DiffFileTable(this);
        this.splitPane.setTopComponent(this.fileTable.getComponent());
        this.splitPane.setBottomComponent(this.getInfoPanelLoading());
    }

    private void initToolbarButtons() {
        if (this.context != null) {
            this.commitButton.addActionListener(this);
            this.localToggle.addActionListener(this);
            this.remoteToggle.addActionListener(this);
            this.allToggle.addActionListener(this);
            this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip", (Object)this.contextName));
            this.updateButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_UpdateDiff_Tooltip", (Object)this.contextName));
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.localToggle);
            grp.add(this.remoteToggle);
            grp.add(this.allToggle);
            if (this.currentType == 0) {
                this.localToggle.setSelected(true);
            } else if (this.currentType == 1) {
                this.remoteToggle.setSelected(true);
            } else if (this.currentType == 2) {
                this.allToggle.setSelected(true);
            }
            this.commitButton.setEnabled(false);
        } else {
            this.localToggle.setVisible(false);
            this.remoteToggle.setVisible(false);
            this.allToggle.setVisible(false);
            this.commitButton.setVisible(false);
            this.refreshButton.setVisible(false);
            this.updateButton.setVisible(false);
        }
    }

    private void initNextPrevActions() {
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiDiffPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private JComponent getInfoPanelLoading() {
        if (this.infoPanelLoadingFromRepo == null) {
            this.infoPanelLoadingFromRepo = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        return this.infoPanelLoadingFromRepo;
    }

    private void refreshComponents() {
        int currentDifferenceIndex;
        DiffController view = this.setups != null && this.currentModelIndex != -1 ? this.setups[this.currentModelIndex].getView() : null;
        int n = currentDifferenceIndex = view != null ? view.getDifferenceIndex() : -1;
        if (view != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || currentDifferenceIndex < view.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || currentDifferenceIndex > 0);
        this.dividerSet = false;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
            CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        }
        JComponent parent = (JComponent)this.getParent();
        parent.getActionMap().put("jumpNext", this.nextAction);
        parent.getActionMap().put("jumpPrev", this.prevAction);
    }

    private void updateSplitLocation() {
        Dimension dim;
        if (this.dividerSet) {
            return;
        }
        JComponent parent = (JComponent)this.getParent();
        Dimension dimension = dim = parent == null ? new Dimension() : parent.getSize();
        if (dim.width <= 0 || dim.height <= 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiDiffPanel.this.updateSplitLocation();
                }
            });
            return;
        }
        this.dividerSet = true;
        JTable jt = this.fileTable.getTable();
        int optimalLocation = jt.getPreferredSize().height + jt.getTableHeader().getPreferredSize().height;
        if (optimalLocation > dim.height / 3) {
            optimalLocation = dim.height / 3;
        }
        if (optimalLocation <= jt.getTableHeader().getPreferredSize().height) {
            optimalLocation = jt.getTableHeader().getPreferredSize().height * 3;
        }
        this.splitPane.setDividerLocation(optimalLocation);
    }

    @Override
    public void removeNotify() {
        CvsVersioningSystem.getInstance().getStatusCache().removeVersioningListener(this);
        if (this.refreshTask != null) {
            CvsModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        }
        super.removeNotify();
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(event)) {
                return;
            }
            if (CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) != null) {
                this.refreshTask.schedule(1000);
            } else {
                this.refreshTask.schedule(200);
            }
        } else if (event.getId() == CvsVersioningSystem.EVENT_PARAM_CHANGED && event.getParams()[0].equals(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) && CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) == null) {
            this.refreshTask.schedule(0);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    private boolean affectsView(VersioningEvent event) {
        File file = (File)event.getParams()[0];
        FileInformation oldInfo = (FileInformation)event.getParams()[1];
        FileInformation newInfo = (FileInformation)event.getParams()[2];
        if (oldInfo == null) {
            if ((newInfo.getStatus() & this.displayStatuses) == 0) {
                return false;
            }
        } else {
            if ((oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
                return false;
            }
            if (oldInfo.getStatus() == newInfo.getStatus()) {
                return false;
            }
        }
        return this.context.contains(file);
    }

    private void setDiffIndex(int idx, int location, boolean restartPrepareTask) {
        assert (EventQueue.isDispatchThread());
        this.currentIndex = idx;
        DiffController view = null;
        if (this.currentIndex != -1) {
            EditorCookie editorCookie;
            TopComponent tc;
            if (restartPrepareTask && this.dpt != null) {
                this.dpt.cancel();
                this.dpt.setTableIndex(this.currentIndex);
                this.prepareTask.schedule(100);
            }
            this.currentModelIndex = this.showingFileTable() ? this.fileTable.getModelIndex(this.currentIndex) : 0;
            view = this.setups[this.currentModelIndex].getView();
            FileObject fileObj = null;
            EditorCookie.Observable observableEditorCookie = null;
            File baseFile = this.setups[this.currentModelIndex].getBaseFile();
            if (baseFile != null) {
                fileObj = FileUtil.toFileObject((File)baseFile);
            }
            if ((tc = (TopComponent)this.getClientProperty(TopComponent.class)) != null) {
                DiffNode node = this.setups[this.currentModelIndex].getNode();
                tc.setActivatedNodes(new Node[]{node == null ? Node.EMPTY : node});
            }
            if ((editorCookie = this.editorCookies[this.currentModelIndex]) instanceof EditorCookie.Observable) {
                observableEditorCookie = (EditorCookie.Observable)editorCookie;
            }
            this.diffView = null;
            if (view != null) {
                if (this.showingFileTable()) {
                    this.fileTableSetSelectedIndexContext = true;
                    this.fileTable.setSelectedIndex(this.currentIndex);
                    this.fileTableSetSelectedIndexContext = false;
                }
                this.diffView = view.getJComponent();
                this.diffView.getActionMap().put("jumpNext", this.nextAction);
                this.diffView.getActionMap().put("jumpPrev", this.prevAction);
                this.displayDiffView();
                if (location == -1) {
                    location = view.getDifferenceCount() - 1;
                }
                if (location >= 0 && location < view.getDifferenceCount()) {
                    view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, location);
                }
            } else {
                this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoContent"));
                this.displayDiffView();
            }
            this.lookup.setData(new Object[]{fileObj, observableEditorCookie, this.diffView.getActionMap()});
        } else {
            this.currentModelIndex = -1;
            this.lookup.setData(new Object[0]);
            this.diffView = new NoContentPanel(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoFileSelected"));
            this.lookup.setData(new Object[]{this.diffView.getActionMap()});
            this.displayDiffView();
        }
        this.delegatingUndoRedo.setDiffView(this.diffView);
        this.refreshComponents();
    }

    private boolean showingFileTable() {
        return this.fileTable != null;
    }

    private void displayDiffView() {
        if (this.splitPane != null) {
            int gg = this.splitPane.getDividerLocation();
            this.splitPane.setBottomComponent(this.diffView);
            this.splitPane.setDividerLocation(gg);
        } else {
            this.diffViewPanel.setComponent((Component)this.diffView);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.commitButton) {
            this.onCommitButton();
        } else if (source == this.localToggle || source == this.remoteToggle || source == this.allToggle) {
            this.onDiffTypeChanged();
        }
    }

    private void onRefreshButton() {
        LifecycleManager.getDefault().saveAll();
        this.executeUpdateCommand(true);
    }

    private void onUpdateButton() {
        LifecycleManager.getDefault().saveAll();
        this.executeUpdateCommand(false);
    }

    private void onCommitButton() {
        assert (EventQueue.isDispatchThread());
        EditorCookie[] editorCookiesCopy = (EditorCookie[])CollectionUtils.copyArray((Object[])this.editorCookies);
        DiffUtils.cleanThoseUnmodified((EditorCookie[])editorCookiesCopy);
        SaveCookie[] saveCookies = MultiDiffPanel.getSaveCookies(this.setups, editorCookiesCopy);
        if (saveCookies.length == 0 || SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
            CommitAction.invokeCommit(this.contextName, this.context, null);
        }
    }

    private void executeUpdateCommand(boolean doNoChanges) {
        if (this.context == null || this.context.getRootFiles().length == 0) {
            return;
        }
        UpdateCommand cmd = new UpdateCommand();
        String msg = doNoChanges ? NbBundle.getMessage(MultiDiffPanel.class, (String)"BK0001") : NbBundle.getMessage(MultiDiffPanel.class, (String)"BK0002");
        cmd.setDisplayName(msg);
        GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
        if (this.context.getExclusions().size() > 0) {
            options.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
        }
        cmd.setFiles(this.context.getRootFiles());
        cmd.setBuildDirectories(true);
        cmd.setPruneDirectories(true);
        options.setDoNoChanges(doNoChanges);
        final ExecutorGroup group = new ExecutorGroup(msg);
        group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options, this.contextName));
        group.addBarrier(new Runnable(){

            @Override
            public void run() {
                if (!group.isFailed()) {
                    MultiDiffPanel.this.refreshTask.schedule(0);
                }
            }
        });
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                group.execute();
            }
        });
    }

    private void onNextButton() {
        DiffController view;
        if (this.showingFileTable()) {
            this.currentIndex = this.fileTable.getSelectedIndex();
            this.currentModelIndex = this.fileTable.getSelectedModelIndex();
        }
        if ((view = this.setups[this.currentModelIndex].getView()) != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (++currentDifferenceIndex >= view.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0, true);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffController view = this.setups[this.currentModelIndex].getView();
        if (view != null) {
            int currentDifferenceIndex = view.getDifferenceIndex();
            if (--currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1, true);
                }
            } else {
                view.setLocation(DiffController.DiffPane.Modified, DiffController.LocationType.DifferenceIndex, currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1, true);
        }
        this.refreshComponents();
    }

    @Override
    public Collection<Setup> getSetups() {
        if (this.setups == null) {
            return Collections.emptySet();
        }
        return Arrays.asList(this.setups);
    }

    @Override
    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                this.displayStatuses = 6612;
                break;
            }
            case 1: {
                this.displayStatuses = 1696;
                break;
            }
            case 2: {
                this.displayStatuses = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] files = DiffExecutor.getModifiedFiles(this.context, this.displayStatuses);
        AbstractDiffSetup[] newSetups = new Setup[files.length];
        for (int i = 0; i < newSetups.length; ++i) {
            File file = files[i];
            newSetups[i] = new Setup(file, this.currentType);
            newSetups[i].setNode(new DiffNode((Setup)newSetups[i], new CvsFileNode(file)));
        }
        Arrays.sort(newSetups, new SetupsComparator());
        EditorCookie[] cookies = DiffUtils.setupsToEditorCookies((AbstractDiffSetup[])newSetups);
        Runnable runnable = new Runnable((Setup[])newSetups, cookies){
            final /* synthetic */ Setup[] val$newSetups;
            final /* synthetic */ EditorCookie[] val$cookies;
            {
                this.val$newSetups = setupArray;
                this.val$cookies = editorCookieArray;
            }

            @Override
            public void run() {
                MultiDiffPanel.this.setSetups(this.val$newSetups, this.val$cookies);
                MultiDiffPanel.this.fileTable.setTableModel(MultiDiffPanel.this.setups, MultiDiffPanel.this.editorCookies);
                if (MultiDiffPanel.this.setups.length == 0) {
                    String noContentLabel;
                    switch (MultiDiffPanel.this.currentType) {
                        case 0: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                            break;
                        }
                        case 1: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                            break;
                        }
                        case 2: {
                            noContentLabel = NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unknown DIFF type:" + MultiDiffPanel.this.currentType);
                        }
                    }
                    MultiDiffPanel.this.setSetups(null, null);
                    MultiDiffPanel.this.fileTable.getComponent().setEnabled(false);
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(null);
                    Dimension dim = MultiDiffPanel.this.fileTable.getComponent().getPreferredSize();
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                    MultiDiffPanel.this.diffView = null;
                    MultiDiffPanel.this.diffView = (JComponent)new NoContentPanel(noContentLabel);
                    MultiDiffPanel.this.displayDiffView();
                    MultiDiffPanel.this.nextAction.setEnabled(false);
                    MultiDiffPanel.this.prevAction.setEnabled(false);
                    MultiDiffPanel.this.commitButton.setEnabled(false);
                    MultiDiffPanel.this.revalidate();
                    MultiDiffPanel.this.repaint();
                    MultiDiffPanel.this.executed();
                } else {
                    MultiDiffPanel.this.fileTable.getComponent().setEnabled(true);
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(null);
                    Dimension dim = MultiDiffPanel.this.fileTable.getComponent().getPreferredSize();
                    MultiDiffPanel.this.fileTable.getComponent().setPreferredSize(new Dimension(dim.width + 1, dim.height));
                    MultiDiffPanel.this.setDiffIndex(0, 0, false);
                    MultiDiffPanel.this.commitButton.setEnabled(true);
                    MultiDiffPanel.this.dpt = new DiffPrepareTask(MultiDiffPanel.this.setups);
                    MultiDiffPanel.this.prepareTask = CvsVersioningSystem.getInstance().getRequestProcessor().post((Runnable)MultiDiffPanel.this.dpt);
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                // empty catch block
            }
        }
    }

    private void onDiffTypeChanged() {
        if (this.localToggle.isSelected()) {
            if (this.currentType == 0) {
                return;
            }
            this.currentType = 0;
        } else if (this.remoteToggle.isSelected()) {
            if (this.currentType == 1) {
                return;
            }
            this.currentType = 1;
        } else if (this.allToggle.isSelected()) {
            if (this.currentType == 2) {
                return;
            }
            this.currentType = 2;
        }
        CvsModuleConfig.getDefault().setLastUsedModificationContext(this.currentType);
        this.refreshTask.schedule(0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("(void) differencesChanged".equals(evt.getPropertyName())) {
            this.refreshComponents();
        }
    }

    private synchronized void executed() {
        if (this.group != null) {
            this.group.executed();
        } else {
            this.executed = true;
        }
    }

    private void initComponents() {
        this.controlsToolBar = new JToolBar();
        this.allToggle = new JToggleButton();
        this.jPanel3 = new JPanel();
        this.localToggle = new JToggleButton();
        this.jPanel4 = new JPanel();
        this.remoteToggle = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel2 = new JPanel();
        this.refreshButton = new JButton();
        this.updateButton = new JButton();
        this.jPanel5 = new JPanel();
        this.commitButton = new JButton();
        this.splitPane = new JSplitPane();
        this.controlsToolBar.setFloatable(false);
        this.controlsToolBar.setRollover(true);
        this.allToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/remote_vs_local.png")));
        this.allToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_All_Tooltip"));
        this.allToggle.setFocusable(false);
        this.allToggle.setHorizontalTextPosition(0);
        this.allToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.allToggle);
        this.jPanel3.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel3);
        this.localToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/local_vs_local.png")));
        this.localToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Local_Tooltip"));
        this.localToggle.setFocusable(false);
        this.localToggle.setHorizontalTextPosition(0);
        this.localToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.localToggle);
        this.jPanel4.setMaximumSize(new Dimension(12, Short.MAX_VALUE));
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(0, 12, Short.MAX_VALUE));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel4);
        this.remoteToggle.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/remote_vs_remote.png")));
        this.remoteToggle.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Remote_Tooltip"));
        this.remoteToggle.setFocusable(false);
        this.remoteToggle.setHorizontalTextPosition(0);
        this.remoteToggle.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.remoteToggle);
        this.jPanel1.setMaximumSize(new Dimension(80, Short.MAX_VALUE));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 80, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel1);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.prevButton);
        this.jPanel2.setMaximumSize(new Dimension(30, Short.MAX_VALUE));
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 30, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel2);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"refreshButton.toolTipText"));
        this.refreshButton.setFocusable(false);
        this.refreshButton.setHorizontalTextPosition(0);
        this.refreshButton.setVerticalTextPosition(3);
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDiffPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.controlsToolBar.add(this.refreshButton);
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/update.png")));
        this.updateButton.setText(NbBundle.getMessage(MultiDiffPanel.class, (String)"jButton1.text"));
        this.updateButton.setFocusable(false);
        this.updateButton.setHorizontalTextPosition(0);
        this.updateButton.setVerticalTextPosition(3);
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiDiffPanel.this.updateButtonActionPerformed(evt);
            }
        });
        this.controlsToolBar.add(this.updateButton);
        this.jPanel5.setMaximumSize(new Dimension(20, Short.MAX_VALUE));
        GroupLayout jPanel5Layout = new GroupLayout((Container)this.jPanel5);
        this.jPanel5.setLayout((LayoutManager)jPanel5Layout);
        jPanel5Layout.setHorizontalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 20, Short.MAX_VALUE));
        jPanel5Layout.setVerticalGroup((GroupLayout.Group)jPanel5Layout.createParallelGroup(1).add(0, 23, Short.MAX_VALUE));
        this.controlsToolBar.add(this.jPanel5);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/commit.png")));
        this.commitButton.setToolTipText(NbBundle.getMessage(MultiDiffPanel.class, (String)"MSG_CommitDiff_Tooltip"));
        this.commitButton.setFocusable(false);
        this.commitButton.setHorizontalTextPosition(0);
        this.commitButton.setVerticalTextPosition(3);
        this.controlsToolBar.add(this.commitButton);
        this.splitPane.setOrientation(0);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.controlsToolBar, -1, 716, Short.MAX_VALUE).add((Component)this.splitPane, -1, 716, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.controlsToolBar, -2, 25, -2).addPreferredGap(0).add((Component)this.splitPane, -1, 331, Short.MAX_VALUE)));
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.onUpdateButton();
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.onRefreshButton();
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            MultiDiffPanel.this.refreshSetups();
        }
    }

    private static class SetupsComparator
    extends Utils.ByImportanceComparator {
        private FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();

        @Override
        public int compare(Object o1, Object o2) {
            File file1 = ((Setup)((Object)o1)).getBaseFile();
            File file2 = ((Setup)((Object)o2)).getBaseFile();
            int cmp = super.compare(this.cache.getStatus(file1), this.cache.getStatus(file2));
            if (cmp == 0) {
                return file1.getName().compareToIgnoreCase(file2.getName());
            }
            return cmp;
        }
    }

    private class DiffPrepareTask
    implements Runnable,
    Cancellable {
        private final Setup[] prepareSetups;
        private int tableIndex;
        private boolean canceled;

        public DiffPrepareTask(Setup[] prepareSetups) {
            this.prepareSetups = prepareSetups;
            this.tableIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                int[] indexes;
                this.canceled = false;
                for (int i : indexes = this.prepareIndexesToRefresh()) {
                    if (this.prepareSetups == MultiDiffPanel.this.setups && !Thread.interrupted()) break block9;
                }
            }
            catch (Throwable throwable) {
                MultiDiffPanel.this.executed();
                throw throwable;
            }
            {
                DiffController view;
                int fi;
                block11: {
                    StreamSource ss2;
                    StreamSource ss1;
                    block10: {
                        int modelIndex;
                        int i;
                        block9: {
                            MultiDiffPanel.this.executed();
                            return;
                        }
                        int n = modelIndex = MultiDiffPanel.this.fileTable == null ? i : MultiDiffPanel.this.fileTable.getModelIndex(i);
                        if (this.prepareSetups[modelIndex].getView() != null) continue;
                        this.prepareSetups[modelIndex].initSources(MultiDiffPanel.this.group);
                        fi = modelIndex;
                        ss1 = this.prepareSetups[fi].getFirstSource();
                        ss2 = this.prepareSetups[fi].getSecondSource();
                        if (!Thread.interrupted() && !this.canceled) break block10;
                        MultiDiffPanel.this.executed();
                        return;
                    }
                    view = DiffController.createEnhanced((StreamSource)ss1, (StreamSource)ss2);
                    view.addPropertyChangeListener((PropertyChangeListener)MultiDiffPanel.this);
                    if (!Thread.interrupted() && !this.canceled) break block11;
                    MultiDiffPanel.this.executed();
                    return;
                }
                try {
                    this.prepareSetups[fi].setView(view);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (DiffPrepareTask.this.prepareSetups != MultiDiffPanel.this.setups) {
                                return;
                            }
                            if (MultiDiffPanel.this.currentModelIndex == fi) {
                                MultiDiffPanel.this.setDiffIndex(MultiDiffPanel.this.currentIndex, 0, false);
                            }
                            if (MultiDiffPanel.this.splitPane != null) {
                                MultiDiffPanel.this.updateSplitLocation();
                            }
                        }
                    });
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
                continue;
            }
            MultiDiffPanel.this.executed();
        }

        private int[] prepareIndexesToRefresh() {
            int index = this.tableIndex;
            int min = Math.max(0, index - 2);
            int max = Math.min(this.prepareSetups.length - 1, index + 2);
            int[] indexes = new int[max - min + 1];
            int i = index;
            int k = 0;
            for (int j = index + 1; i >= min || j <= max; --i, ++j) {
                if (i >= min) {
                    indexes[k++] = i;
                }
                if (j > max) continue;
                indexes[k++] = j;
            }
            return indexes;
        }

        private void setTableIndex(int index) {
            this.tableIndex = index;
        }

        public boolean cancel() {
            this.canceled = true;
            return true;
        }
    }
}

