/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.filters;

import java.io.File;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.filters.SourceFileFilter;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class HeaderSourceFileFilter
extends SourceFileFilter {
    private static HeaderSourceFileFilter instance = null;
    private String[] suffixList = null;

    public static HeaderSourceFileFilter getInstance() {
        if (instance == null) {
            instance = new HeaderSourceFileFilter();
        }
        return instance;
    }

    @Override
    public boolean accept(File f) {
        if (f != null) {
            if (f.isDirectory()) {
                return true;
            }
            if (FileUtil.getExtension((String)f.getPath()).length() == 0) {
                return "text/x-h".equals(MIMESupport.getFileMIMEType(f));
            }
            return super.accept(f);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(SourceFileFilter.class, (String)"FILECHOOSER_HEADER_SOURCES_FILEFILTER", (Object)this.getSuffixesAsString());
    }

    @Override
    public String[] getSuffixes() {
        if (this.suffixList == null) {
            this.suffixList = MIMEExtensions.get("text/x-h").getValues().toArray(new String[0]);
        }
        return this.suffixList;
    }
}

