/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import java.io.File;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class MIMESupport {
    private static final String[] SOURCE_MIME_TYPES = new String[]{"text/x-c++", "text/x-c", "text/x-h", "text/x-fortran", "text/x-asm"};

    private MIMESupport() {
    }

    public static String getFileMIMEType(FileObject fo) {
        Parameters.notNull((CharSequence)"file object", (Object)fo);
        String mime = FileUtil.getMIMEType((FileObject)fo, (String[])SOURCE_MIME_TYPES);
        if (mime == null) {
            mime = FileUtil.getMIMEType((FileObject)fo);
        }
        return mime;
    }

    public static String getFileMIMEType(File file) {
        FileObject fo = FileUtil.toFileObject((File)CndFileUtils.normalizeFile(file));
        String mime = fo != null ? MIMESupport.getFileMIMEType(fo) : MIMESupport.getKnownMIMETypeByExtension(file.getPath());
        return mime != null ? mime : "content/unknown";
    }

    public static String getKnownMIMETypeByExtension(String path) {
        String ext = FileUtil.getExtension((String)path);
        for (String mimeType : SOURCE_MIME_TYPES) {
            if (!MIMEExtensions.isRegistered(mimeType, ext)) continue;
            return mimeType;
        }
        return null;
    }
}

