/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.ast.AliasNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.ClassVarDeclNode;
import org.jrubyparser.ast.ClassVarNode;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstNode;
import org.jrubyparser.ast.DAsgnNode;
import org.jrubyparser.ast.DVarNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.GlobalAsgnNode;
import org.jrubyparser.ast.GlobalVarNode;
import org.jrubyparser.ast.HashNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.InstAsgnNode;
import org.jrubyparser.ast.InstVarNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.LocalVarNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.StrNode;
import org.jrubyparser.ast.SuperNode;
import org.jrubyparser.ast.SymbolNode;
import org.jrubyparser.ast.VCallNode;
import org.jrubyparser.ast.ZSuperNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.ActiveRecordAssociationFinder;
import org.netbeans.modules.ruby.Arity;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.HelpersFinder;
import org.netbeans.modules.ruby.RubyClassDeclarationFinder;
import org.netbeans.modules.ruby.RubyConstantDeclarationFinder;
import org.netbeans.modules.ruby.RubyDeclarationFinderHelper;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyCommentTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class RubyDeclarationFinder
extends RubyDeclarationFinderHelper
implements DeclarationFinder {
    private static int methodSelector = 0;
    private boolean ignoreAlias;
    private RubyIndex rubyIndex;
    private static final String PARTIAL = "partial";
    private static final String CONTROLLER = "controller";
    private static final String ACTION = "action";
    private static final String TEMPLATE = "template";
    private static final String[] RAILS_TARGET_RAW_NAMES = new String[]{"partial", "controller", "action", "template"};
    private static final List<String> RAILS_TARGETS = RubyDeclarationFinder.initRailsTargets();

    private static List<String> initRailsTargets() {
        ArrayList<String> result = new ArrayList<String>(RAILS_TARGET_RAW_NAMES.length * 4);
        for (String target : RAILS_TARGET_RAW_NAMES) {
            result.add(":" + target + " => ");
            result.add(":" + target + "=> ");
            result.add(":" + target + " =>");
            result.add(":" + target + "=>");
        }
        return result;
    }

    private RubyIndex getIndex(ParserResult result) {
        if (this.rubyIndex == null) {
            this.rubyIndex = RubyIndex.get((Parser.Result)result);
        }
        return this.rubyIndex;
    }

    public OffsetRange getReferenceSpan(Document document, int lexOffset) {
        RailsTarget target;
        TokenHierarchy th = TokenHierarchy.get((Document)document);
        BaseDocument doc = (BaseDocument)document;
        FileObject fo = RubyUtils.getFileObject(document);
        if ((RubyUtils.isRhtmlDocument((Document)doc) || fo != null && RubyUtils.isRailsProject(fo)) && (target = this.findRailsTarget(doc, (TokenHierarchy<Document>)th, lexOffset)) != null) {
            return target.range;
        }
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)th, lexOffset);
        if (ts == null) {
            return OffsetRange.NONE;
        }
        ts.move(lexOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return OffsetRange.NONE;
        }
        boolean isBetween = lexOffset == ts.offset();
        OffsetRange range = this.getReferenceSpan(ts, (TokenHierarchy<Document>)th, lexOffset);
        if (range == OffsetRange.NONE && isBetween && ts.movePrevious()) {
            range = this.getReferenceSpan(ts, (TokenHierarchy<Document>)th, lexOffset);
        }
        return range;
    }

    private OffsetRange getReferenceSpan(TokenSequence<?> ts, TokenHierarchy<Document> th, int lexOffset) {
        Token token = ts.token();
        TokenId id = token.id();
        if (id == RubyTokenId.IDENTIFIER && token.length() == 1 && id == RubyTokenId.IDENTIFIER && ((Object)token.text()).toString().equals(",")) {
            return OffsetRange.NONE;
        }
        if (id == RubyTokenId.IDENTIFIER || id == RubyTokenId.CLASS_VAR || id == RubyTokenId.GLOBAL_VAR || id == RubyTokenId.CONSTANT || id == RubyTokenId.TYPE_SYMBOL || id == RubyTokenId.INSTANCE_VAR || id == RubyTokenId.SUPER) {
            return new OffsetRange(ts.offset(), ts.offset() + token.length());
        }
        TokenSequence embedded = ts.embedded();
        if (embedded != null) {
            ts = embedded;
            embedded.move(lexOffset);
            if (embedded.moveNext()) {
                Token embeddedToken = embedded.token();
                if (embeddedToken.id() == RubyCommentTokenId.COMMENT_LINK) {
                    return new OffsetRange(embedded.offset(), embedded.offset() + embeddedToken.length());
                }
                OffsetRange range = this.getReferenceSpan(embedded, th, lexOffset);
                if (range != OffsetRange.NONE) {
                    return range;
                }
            }
        }
        if (id == RubyTokenId.QUOTED_STRING_LITERAL || id == RubyTokenId.STRING_LITERAL) {
            String className;
            String require;
            int requireStart = LexUtilities.getRequireStringOffset(lexOffset, th);
            if (requireStart != -1 && (require = LexUtilities.getStringAt(lexOffset, th)) != null) {
                return new OffsetRange(requireStart, requireStart + require.length());
            }
            int classNameStart = LexUtilities.getClassNameStringOffset(lexOffset, th);
            if (classNameStart != -1 && (className = LexUtilities.getStringAt(lexOffset, th)) != null) {
                return new OffsetRange(classNameStart, classNameStart + className.length());
            }
        }
        return OffsetRange.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult parserResult, int lexOffset) {
        try {
            int requireStart;
            DeclarationFinder.DeclarationLocation loc;
            BaseDocument document = RubyUtils.getDocument((Parser.Result)parserResult, true);
            if (document == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            TokenHierarchy th = TokenHierarchy.get((Document)document);
            BaseDocument doc = document;
            int astOffset = AstUtilities.getAstOffset((Parser.Result)parserResult, lexOffset);
            if (astOffset == -1) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            boolean view = RubyUtils.isRhtmlFile(RubyUtils.getFileObject((Parser.Result)parserResult));
            if ((view || RubyUtils.isRailsProject(RubyUtils.getFileObject((Parser.Result)parserResult))) && (loc = this.findRailsFile(parserResult, doc, (TokenHierarchy<Document>)th, lexOffset, astOffset, view)) != DeclarationFinder.DeclarationLocation.NONE) {
                return loc;
            }
            OffsetRange range = this.getReferenceSpan((Document)doc, lexOffset);
            if (range == OffsetRange.NONE) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            boolean leftSide = range.getEnd() <= lexOffset;
            Node root = AstUtilities.getRoot((Parser.Result)parserResult);
            RubyIndex index = this.getIndex(parserResult);
            if (root == null) {
                DeclarationFinder.DeclarationLocation l;
                String text = doc.getText(range.getStart(), range.getLength());
                if (index == null) return DeclarationFinder.DeclarationLocation.NONE;
                if (text.length() == 0) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                if (Character.isUpperCase(text.charAt(0))) {
                    Set<IndexedClass> classes = index.getClasses(text, QuerySupport.Kind.EXACT, true, false, false);
                    if (classes.size() == 0) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    RubyClassDeclarationFinder cdf = new RubyClassDeclarationFinder(null, null, null, index, null);
                    DeclarationFinder.DeclarationLocation l2 = cdf.getElementDeclaration(classes, null);
                    if (l2 == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return l2;
                }
                Set<IndexedMethod> methods = index.getMethods(text, (String)null, QuerySupport.Kind.EXACT);
                if (methods.size() == 0) {
                    methods = index.getMethods(text, QuerySupport.Kind.EXACT);
                }
                if ((l = this.getMethodDeclaration(parserResult, text, methods, null, null, index, astOffset, lexOffset)) == null) return DeclarationFinder.DeclarationLocation.NONE;
                return l;
            }
            int tokenOffset = lexOffset;
            if (leftSide && tokenOffset > 0) {
                --tokenOffset;
            }
            if ((requireStart = LexUtilities.getRequireStringOffset(tokenOffset, (TokenHierarchy<Document>)th)) != -1) {
                String require = LexUtilities.getStringAt(tokenOffset, (TokenHierarchy<Document>)th);
                if (require == null) return DeclarationFinder.DeclarationLocation.NONE;
                FileObject fo = index.getRequiredFile(require);
                if (fo == null) return DeclarationFinder.DeclarationLocation.NONE;
                return new DeclarationFinder.DeclarationLocation(fo, 0);
            }
            AstPath path = new AstPath(root, astOffset);
            Node closest = path.leaf();
            if (closest == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            DeclarationFinder.DeclarationLocation rdoc = this.findRDocMethod(parserResult, (Document)doc, astOffset, lexOffset, root, path, closest, index);
            if (rdoc != DeclarationFinder.DeclarationLocation.NONE) {
                return RubyDeclarationFinder.fix(rdoc, parserResult);
            }
            if (closest instanceof LocalVarNode || closest instanceof LocalAsgnNode) {
                String name = ((INameNode)closest).getName();
                Node method = AstUtilities.findLocalScope(closest, path);
                return RubyDeclarationFinder.fix(this.findLocal(parserResult, method, name), parserResult);
            }
            if (closest instanceof DVarNode) {
                String name = ((DVarNode)closest).getName();
                Node block = AstUtilities.findDynamicScope(closest, path);
                return RubyDeclarationFinder.fix(this.findDynamic(parserResult, block, name), parserResult);
            }
            if (closest instanceof DAsgnNode) {
                String name = ((INameNode)closest).getName();
                Node block = AstUtilities.findDynamicScope(closest, path);
                return RubyDeclarationFinder.fix(this.findDynamic(parserResult, block, name), parserResult);
            }
            if (closest instanceof InstVarNode) {
                String name = ((INameNode)closest).getName();
                return this.findInstanceFromIndex(parserResult, name, path, index, false);
            }
            if (closest instanceof ClassVarNode) {
                String name = ((INameNode)closest).getName();
                return this.findInstanceFromIndex(parserResult, name, path, index, false);
            }
            if (closest instanceof GlobalVarNode) {
                String name = ((GlobalVarNode)closest).getName();
                return RubyDeclarationFinder.fix(this.findGlobal(parserResult, root, name), parserResult);
            }
            if (closest instanceof FCallNode || closest instanceof VCallNode || closest instanceof CallNode) {
                Node method;
                String name = ((INameNode)closest).getName();
                Call call = Call.getCallType(doc, (TokenHierarchy<Document>)th, lexOffset);
                RubyType type = call.getType();
                String lhs = call.getLhs();
                if (!type.isKnown() && lhs != null && closest != null && call.isSimpleIdentifier() && (method = AstUtilities.findLocalScope(closest, path)) != null) {
                    ContextKnowledge knowledge = new ContextKnowledge(index, root, method, astOffset, lexOffset, parserResult);
                    RubyTypeInferencer inferencer = RubyTypeInferencer.create(knowledge);
                    type = inferencer.inferType(lhs);
                }
                if (!type.isKnown()) {
                    Arity arity;
                    DeclarationFinder.DeclarationLocation loc2;
                    if (name.equals("new")) {
                        name = "initialize";
                    }
                    if ((loc2 = RubyDeclarationFinder.fix(this.findMethod(parserResult, root, name, arity = Arity.getCallArity(closest)), parserResult)) != DeclarationFinder.DeclarationLocation.NONE) {
                        return loc2;
                    }
                }
                String fqn = AstUtilities.getFqnName(path);
                if (call != Call.LOCAL) return this.findMethod(name, fqn, type, call, parserResult, astOffset, lexOffset, path, closest, index);
                if (fqn == null) return this.findMethod(name, fqn, type, call, parserResult, astOffset, lexOffset, path, closest, index);
                if (fqn.length() != 0) return this.findMethod(name, fqn, type, call, parserResult, astOffset, lexOffset, path, closest, index);
                fqn = "Object";
                return this.findMethod(name, fqn, type, call, parserResult, astOffset, lexOffset, path, closest, index);
            }
            if (closest instanceof ConstNode || closest instanceof Colon2Node) {
                RubyClassDeclarationFinder classDF = new RubyClassDeclarationFinder(parserResult, root, path, index, closest);
                DeclarationFinder.DeclarationLocation decl = classDF.findClassDeclaration();
                if (decl != DeclarationFinder.DeclarationLocation.NONE) {
                    return decl;
                }
                RubyConstantDeclarationFinder constantDF = new RubyConstantDeclarationFinder(parserResult, root, path, index, closest);
                return constantDF.findConstantDeclaration();
            }
            if (closest instanceof SymbolNode) {
                RubyClassDeclarationFinder cdf;
                Node clz;
                Arity arity;
                String name = ((SymbolNode)closest).getName();
                DeclarationFinder.DeclarationLocation location = this.findMethod(parserResult, root, name, arity = Arity.UNKNOWN);
                if (location == DeclarationFinder.DeclarationLocation.NONE) {
                    location = new ActiveRecordAssociationFinder(index, (SymbolNode)closest, root, path).findAssociationLocation();
                }
                if (location == DeclarationFinder.DeclarationLocation.NONE) {
                    location = new HelpersFinder(index, (SymbolNode)closest, root, path).findHelperLocation();
                }
                if (location == DeclarationFinder.DeclarationLocation.NONE) {
                    location = this.findInstance(parserResult, root, name, index);
                }
                if (location == DeclarationFinder.DeclarationLocation.NONE) {
                    location = this.findClassVar(parserResult, root, name);
                }
                if (location == DeclarationFinder.DeclarationLocation.NONE) {
                    location = this.findGlobal(parserResult, root, name);
                }
                if (location == DeclarationFinder.DeclarationLocation.NONE && (clz = (cdf = new RubyClassDeclarationFinder()).findClass(root, ((INameNode)closest).getName(), this.ignoreAlias)) != null) {
                    location = RubyDeclarationFinder.getLocation(parserResult, clz);
                }
                if (location == DeclarationFinder.DeclarationLocation.NONE) {
                    location = this.findInstanceMethodsFromIndex(parserResult, name, path, index);
                }
                if (location != DeclarationFinder.DeclarationLocation.NONE) return RubyDeclarationFinder.fix(location, parserResult);
                location = this.findInstanceFromIndex(parserResult, name, path, index, true);
                return RubyDeclarationFinder.fix(location, parserResult);
            }
            if (closest instanceof AliasNode) {
                AliasNode an = (AliasNode)closest;
                String newName = AstUtilities.getNameOrValue(an.getNewName());
                if (newName == null) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                int newLength = newName.length();
                int aliasPos = an.getPosition().getStartOffset();
                if (astOffset <= aliasPos + 6) return DeclarationFinder.DeclarationLocation.NONE;
                if (astOffset <= aliasPos + 6 + newLength) return new DeclarationFinder.DeclarationLocation(RubyUtils.getFileObject((Parser.Result)parserResult), aliasPos + 4);
                String name = AstUtilities.getNameOrValue(an.getOldName());
                if (name == null) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                this.ignoreAlias = true;
                try {
                    DeclarationFinder.DeclarationLocation declarationLocation;
                    RubyClassDeclarationFinder cdf;
                    Node clz;
                    DeclarationFinder.DeclarationLocation location = this.findLocal(parserResult, AstUtilities.findLocalScope(closest, path), name);
                    if (location == DeclarationFinder.DeclarationLocation.NONE) {
                        location = this.findDynamic(parserResult, AstUtilities.findDynamicScope(closest, path), name);
                    }
                    if (location == DeclarationFinder.DeclarationLocation.NONE) {
                        location = this.findMethod(parserResult, root, name, Arity.UNKNOWN);
                    }
                    if (location == DeclarationFinder.DeclarationLocation.NONE) {
                        location = this.findInstance(parserResult, root, name, index);
                    }
                    if (location == DeclarationFinder.DeclarationLocation.NONE) {
                        location = this.findClassVar(parserResult, root, name);
                    }
                    if (location == DeclarationFinder.DeclarationLocation.NONE) {
                        location = this.findGlobal(parserResult, root, name);
                    }
                    if (location == DeclarationFinder.DeclarationLocation.NONE && (clz = (cdf = new RubyClassDeclarationFinder()).findClass(root, name, this.ignoreAlias)) != null) {
                        location = RubyDeclarationFinder.getLocation(parserResult, clz);
                    }
                    if (location == DeclarationFinder.DeclarationLocation.NONE) {
                        declarationLocation = location;
                        return declarationLocation;
                    }
                    declarationLocation = RubyDeclarationFinder.fix(location, parserResult);
                    return declarationLocation;
                }
                finally {
                    this.ignoreAlias = false;
                }
            }
            if (closest instanceof ArgumentNode) {
                String name = ((ArgumentNode)closest).getName();
                Node parent = path.leafParent();
                if (parent == null) return DeclarationFinder.DeclarationLocation.NONE;
                if (parent instanceof MethodDefNode) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                Node method = AstUtilities.findLocalScope(closest, path);
                return RubyDeclarationFinder.fix(this.findLocal(parserResult, method, name), parserResult);
            }
            if (closest instanceof StrNode) {
                int classNameStart = LexUtilities.getClassNameStringOffset(astOffset, (TokenHierarchy<Document>)th);
                if (classNameStart == -1) return DeclarationFinder.DeclarationLocation.NONE;
                String className = LexUtilities.getStringAt(tokenOffset, (TokenHierarchy<Document>)th);
                if (className == null) return DeclarationFinder.DeclarationLocation.NONE;
                return RubyDeclarationFinder.getLocation(index.getClasses(className, QuerySupport.Kind.EXACT, true, false, false));
            }
            if (!(closest instanceof SuperNode)) {
                if (!(closest instanceof ZSuperNode)) return DeclarationFinder.DeclarationLocation.NONE;
            }
            Node scope = AstUtilities.findLocalScope(closest, path);
            String fqn = AstUtilities.getFqnName(path);
            switch (scope.getNodeType()) {
                case SCLASSNODE: 
                case MODULENODE: 
                case CLASSNODE: {
                    IndexedClass superClass = index.getSuperclass(fqn);
                    if (superClass == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return RubyDeclarationFinder.getLocation(Collections.singleton(superClass));
                }
                case DEFNNODE: 
                case DEFSNODE: {
                    MethodDefNode methodDef = AstUtilities.findMethod(path);
                    IndexedMethod superMethod = index.getSuperMethod(fqn, methodDef.getName(), true);
                    if (superMethod == null) return DeclarationFinder.DeclarationLocation.NONE;
                    return RubyDeclarationFinder.getLocation(Collections.singleton(superMethod));
                }
            }
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public static DeclarationFinder.DeclarationLocation getTestDeclaration(FileObject fileInProject, String testString, boolean classLocation) {
        return RubyDeclarationFinder.getTestDeclaration(fileInProject, testString, classLocation, true);
    }

    public static DeclarationFinder.DeclarationLocation getTestDeclaration(FileObject fileInProject, String testString, boolean classLocation, boolean requireDeclaredClass) {
        int methodIndex = testString.indexOf(47);
        if (methodIndex == -1) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        RubyIndex index = RubyIndex.get(QuerySupport.findRoots((FileObject)fileInProject, Collections.singleton("ruby/classpath/source"), Collections.singleton("ruby/classpath/boot"), Collections.emptySet()));
        if (index == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String className = testString.substring(0, methodIndex);
        String methodName = testString.substring(methodIndex + 1);
        Set<IndexedMethod> methods = index.getMethods(methodName, className, QuerySupport.Kind.EXACT);
        DeclarationFinder.DeclarationLocation methodLocation = RubyDeclarationFinder.getLocation(methods);
        if (!classLocation) {
            if (DeclarationFinder.DeclarationLocation.NONE == methodLocation && !requireDeclaredClass) {
                methodLocation = RubyDeclarationFinder.getLocation(index.getMethods(methodName, QuerySupport.Kind.EXACT));
            }
            return methodLocation;
        }
        Set<IndexedClass> classes = index.getClasses(className, QuerySupport.Kind.EXACT, false, false, true, null);
        DeclarationFinder.DeclarationLocation classDeclarationLocation = RubyDeclarationFinder.getLocation(classes);
        if (DeclarationFinder.DeclarationLocation.NONE == methodLocation && classLocation) {
            return classDeclarationLocation;
        }
        if (methodLocation.getFileObject().equals(classDeclarationLocation.getFileObject())) {
            return classDeclarationLocation;
        }
        for (DeclarationFinder.AlternativeLocation alt : classDeclarationLocation.getAlternativeLocations()) {
            if (!methodLocation.getFileObject().equals(alt.getLocation().getFileObject())) continue;
            return alt.getLocation();
        }
        return classDeclarationLocation;
    }

    static DeclarationFinder.DeclarationLocation getLocation(Set<? extends IndexedElement> elements) {
        DeclarationFinder.DeclarationLocation loc = DeclarationFinder.DeclarationLocation.NONE;
        for (IndexedElement indexedElement : elements) {
            FileObject fo = indexedElement.getFileObject();
            if (fo == null) continue;
            if (loc == DeclarationFinder.DeclarationLocation.NONE) {
                int offset = -1;
                Node node = AstUtilities.getForeignNode(indexedElement);
                if (node != null) {
                    offset = AstUtilities.getRange(node).getStart();
                }
                loc = new DeclarationFinder.DeclarationLocation(fo, offset, (ElementHandle)indexedElement);
                loc.addAlternative((DeclarationFinder.AlternativeLocation)new RubyDeclarationFinderHelper.RubyAltLocation(indexedElement, false));
                continue;
            }
            RubyDeclarationFinderHelper.RubyAltLocation alternate = new RubyDeclarationFinderHelper.RubyAltLocation(indexedElement, false);
            loc.addAlternative((DeclarationFinder.AlternativeLocation)alternate);
        }
        return loc;
    }

    private DeclarationFinder.DeclarationLocation findRailsFile(ParserResult info, BaseDocument doc, TokenHierarchy<Document> th, int lexOffset, int astOffset, boolean fromView) {
        RailsTarget target = this.findRailsTarget(doc, th, lexOffset);
        if (target != null) {
            String type = target.type;
            if (type.indexOf(PARTIAL) != -1 || type.indexOf(TEMPLATE) != -1) {
                DeclarationFinder.DeclarationLocation partialLocation;
                String name;
                FileObject dir;
                boolean template = type.indexOf(TEMPLATE) != -1;
                int slashIndex = target.name.lastIndexOf(47);
                if (slashIndex != -1) {
                    FileObject app = RubyUtils.getAppDir(RubyUtils.getFileObject((Parser.Result)info));
                    if (app == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    String relativePath = target.name.substring(0, slashIndex);
                    dir = app.getFileObject("views/" + relativePath);
                    if (dir == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    name = target.name.substring(slashIndex + 1);
                } else {
                    dir = RubyUtils.getFileObject((Parser.Result)info).getParent();
                    name = target.name;
                }
                if (!template) {
                    name = "_" + name;
                }
                if ((partialLocation = this.findPartial(name, dir)) != DeclarationFinder.DeclarationLocation.NONE) {
                    return partialLocation;
                }
            } else if (type.indexOf(CONTROLLER) != -1 || type.indexOf(ACTION) != -1) {
                FileObject controllerFile;
                FileObject app;
                FileObject file = RubyUtils.getFileObject((Parser.Result)info);
                file = file.getParent();
                String action = null;
                String fileName = file.getName();
                boolean isController = type.indexOf(CONTROLLER) != -1;
                String path = "";
                if (isController) {
                    path = target.name;
                } else if (!fileName.startsWith("_")) {
                    path = fileName;
                    action = RubyUtils.getFileObject((Parser.Result)info).getName();
                }
                int delta = target.range.getStart() - lexOffset;
                String[] controllerAction = this.findControllerAction(info, lexOffset + delta, astOffset + delta);
                if (controllerAction[0] != null) {
                    path = controllerAction[0];
                }
                if (controllerAction[1] != null) {
                    action = controllerAction[1];
                }
                if (!fromView) {
                    String controllerName = null;
                    controllerName = controllerAction[0] != null ? controllerAction[0] : (isController ? target.name : RubyUtils.getFileObject((Parser.Result)info).getName());
                    return this.findActionLocation(RubyDeclarationFinder.asControllerClass(controllerName), action, info);
                }
                for (app = file.getParent(); app != null; app = app.getParent()) {
                    if (app.getName().equals("views") && (app.getParent() == null || app.getParent().getName().equals("app"))) {
                        app = app.getParent();
                        break;
                    }
                    path = app.getNameExt() + "/" + path;
                }
                if (app != null && (controllerFile = app.getFileObject("controllers/" + path + "_controller.rb")) != null) {
                    int offset = 0;
                    if (action != null && (offset = AstUtilities.findOffset(controllerFile, action)) < 0) {
                        offset = 0;
                    }
                    return new DeclarationFinder.DeclarationLocation(controllerFile, offset);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static String asControllerClass(String controllerName) {
        String suffix = controllerName.endsWith("_controller") ? "" : "_controller";
        return RubyUtils.underlinedNameToCamel(controllerName + suffix);
    }

    private DeclarationFinder.DeclarationLocation findActionLocation(String controllerName, String actionName, ParserResult result) {
        RubyIndex index = this.getIndex(result);
        Set<IndexedMethod> methods = index.getMethods(actionName, controllerName, QuerySupport.Kind.EXACT);
        return RubyDeclarationFinder.getLocation(methods);
    }

    private DeclarationFinder.DeclarationLocation findPartial(String name, FileObject dir) {
        FileObject partial = dir.getFileObject(name);
        if (partial != null) {
            return new DeclarationFinder.DeclarationLocation(partial, 0);
        }
        for (String string : RubyUtils.RUBY_VIEW_EXTS) {
            partial = dir.getFileObject(name + string);
            if (partial == null) continue;
            return new DeclarationFinder.DeclarationLocation(partial, 0);
        }
        for (String string : dir.getChildren()) {
            if (!string.isValid() || string.isFolder() || !string.getName().equals(name)) continue;
            return new DeclarationFinder.DeclarationLocation((FileObject)string, 0);
        }
        for (String string : dir.getChildren()) {
            String fileName;
            int firstDot;
            if (!string.isValid() || string.isFolder() || (firstDot = (fileName = string.getName()).indexOf(46)) == -1 || !name.equals(fileName.substring(0, firstDot))) continue;
            return new DeclarationFinder.DeclarationLocation((FileObject)string, 0);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private String[] findControllerAction(ParserResult info, int lexOffset, int astOffset) {
        String[] result = new String[2];
        Node root = AstUtilities.getRoot((Parser.Result)info);
        if (root == null) {
            return result;
        }
        AstPath path = new AstPath(root, astOffset);
        ListIterator<Node> it = path.leafToRoot();
        Node prev = null;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n instanceof HashNode && prev instanceof ListNode) {
                List hashItems = prev.childNodes();
                Iterator hi = hashItems.iterator();
                while (hi.hasNext()) {
                    Node t;
                    String from = null;
                    String to = null;
                    Node f = (Node)hi.next();
                    if (f instanceof SymbolNode) {
                        from = ((SymbolNode)f).getName();
                    }
                    if (hi.hasNext() && (t = (Node)hi.next()) instanceof StrNode) {
                        to = ((StrNode)t).getValue().toString();
                    }
                    if (CONTROLLER.equals(from)) {
                        result[0] = to;
                        continue;
                    }
                    if (!ACTION.equals(from)) continue;
                    result[1] = to;
                }
                break;
            }
            prev = n;
        }
        return result;
    }

    private boolean fastCheckIsRailsTarget(String s) {
        for (String targetName : RAILS_TARGET_RAW_NAMES) {
            if (s.indexOf(targetName) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RailsTarget findRailsTarget(BaseDocument doc, TokenHierarchy<Document> th, int lexOffset) {
        block15: {
            try {
                doc.readLock();
                int begin = Utilities.getRowStart((BaseDocument)doc, (int)lexOffset);
                if (begin == -1) break block15;
                int end = Utilities.getRowEnd((BaseDocument)doc, (int)lexOffset);
                String s = doc.getText(begin, end - begin);
                if (!this.fastCheckIsRailsTarget(s)) {
                    RailsTarget railsTarget = null;
                    return railsTarget;
                }
                for (String target : RAILS_TARGETS) {
                    Token token;
                    int index = s.indexOf(target);
                    if (index == -1) continue;
                    int nameOffset = begin + index + target.length();
                    TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(th, nameOffset);
                    if (ts == null) {
                        RailsTarget railsTarget = null;
                        return railsTarget;
                    }
                    ts.move(nameOffset);
                    StringBuilder sb = new StringBuilder();
                    boolean started = false;
                    while (ts.moveNext() && ts.offset() < end) {
                        started = true;
                        token = ts.token();
                        TokenId id = token.id();
                        if (id == RubyTokenId.STRING_LITERAL || id == RubyTokenId.QUOTED_STRING_LITERAL) {
                            sb.append(((Object)token.text()).toString());
                        }
                        if ("string".equals(id.primaryCategory())) continue;
                        break;
                    }
                    if (!started) {
                        token = null;
                        return token;
                    }
                    int rangeEnd = ts.offset();
                    String name = sb.toString();
                    if (lexOffset > rangeEnd || lexOffset < begin + index) continue;
                    OffsetRange range = new OffsetRange(begin + index, rangeEnd);
                    RailsTarget railsTarget = new RailsTarget(target, name, range);
                    return railsTarget;
                }
            }
            catch (BadLocationException ble) {
                Exceptions.printStackTrace((Throwable)ble);
            }
            finally {
                doc.readUnlock();
            }
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findMethod(String name, String possibleFqn, RubyType type, Call call, ParserResult info, int caretOffset, int lexOffset, AstPath path, Node closest, RubyIndex index) {
        Set<IndexedMethod> methods = this.getApplicableMethods(name, possibleFqn, type, call, index);
        int astOffset = caretOffset;
        DeclarationFinder.DeclarationLocation l = this.getMethodDeclaration(info, name, methods, path, closest, index, astOffset, lexOffset);
        return l;
    }

    private Set<IndexedMethod> getApplicableMethods(String name, String possibleFqn, RubyType type, Call call, RubyIndex index) {
        int f;
        Set<IndexedMethod> methods = new HashSet<IndexedMethod>();
        String fqn = possibleFqn;
        if (!type.isKnown() && possibleFqn != null && call.getLhs() == null && call != Call.UNKNOWN) {
            fqn = possibleFqn;
            while (methods.size() == 0 && fqn.length() > 0) {
                methods = index.getInheritedMethods(fqn, name, QuerySupport.Kind.EXACT);
                f = fqn.lastIndexOf("::");
                if (f == -1) break;
                fqn = fqn.substring(0, f);
            }
        }
        if (type.isKnown() && methods.size() == 0) {
            for (fqn = possibleFqn; methods.size() == 0 && fqn != null && fqn.length() > 0; fqn = fqn.substring(0, f)) {
                for (String realType : type.getRealTypes()) {
                    methods.addAll(index.getInheritedMethods(fqn + "::" + realType, name, QuerySupport.Kind.EXACT));
                }
                f = fqn.lastIndexOf("::");
                if (f == -1) break;
            }
            if (methods.size() == 0) {
                for (String realType : type.getRealTypes()) {
                    methods.addAll(index.getInheritedMethods(realType, name, QuerySupport.Kind.EXACT));
                }
                if (methods.size() == 0) {
                    for (String realType : type.getRealTypes()) {
                        assert (realType != null) : "Should not be null";
                        if (realType.indexOf("::") != -1) continue;
                        Set<IndexedClass> classes = index.getClasses(realType, QuerySupport.Kind.EXACT, false, false, false);
                        HashSet<String> fqns = new HashSet<String>();
                        for (IndexedClass cls : classes) {
                            String f2 = cls.getFqn();
                            if (f2 == null) continue;
                            fqns.add(f2);
                        }
                        for (String f3 : fqns) {
                            if (f3.equals(realType)) continue;
                            methods.addAll(index.getInheritedMethods(f3, name, QuerySupport.Kind.EXACT));
                        }
                    }
                }
            }
            if (methods.size() == 0) {
                methods.addAll(index.getMethods(name, QuerySupport.Kind.EXACT));
            }
        }
        if (methods.size() == 0) {
            if (!type.isKnown()) {
                methods.addAll(index.getMethods(name, QuerySupport.Kind.EXACT));
            } else {
                methods.addAll(index.getMethods(name, type.getRealTypes(), QuerySupport.Kind.EXACT));
            }
            if (methods.size() == 0 && type.isKnown()) {
                methods = index.getMethods(name, QuerySupport.Kind.EXACT);
            }
        }
        return methods;
    }

    private DeclarationFinder.DeclarationLocation getMethodDeclaration(ParserResult info, String name, Set<IndexedMethod> methods, AstPath path, Node closest, RubyIndex index, int astOffset, int lexOffset) {
        BaseDocument doc = RubyUtils.getDocument((Parser.Result)info);
        if (doc == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        IndexedMethod candidate = this.findBestMethodMatch(name, methods, doc, astOffset, lexOffset, path, closest, index);
        if (candidate != null) {
            FileObject fileObject = candidate.getFileObject();
            if (fileObject == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            Node node = AstUtilities.getForeignNode(candidate);
            int nodeOffset = 0;
            if (node != null) {
                nodeOffset = node.getPosition().getStartOffset();
                if (node.getNodeType() == NodeType.ALIASNODE) {
                    nodeOffset += 6;
                }
            }
            DeclarationFinder.DeclarationLocation loc = new DeclarationFinder.DeclarationLocation(fileObject, nodeOffset, (ElementHandle)candidate);
            if (!CHOOSE_ONE_DECLARATION && methods.size() > 1) {
                int not_nodoced = 0;
                for (IndexedMethod mtd : methods) {
                    if (mtd.isNoDoc()) continue;
                    ++not_nodoced;
                }
                if (not_nodoced >= 2) {
                    for (IndexedMethod mtd : methods) {
                        loc.addAlternative((DeclarationFinder.AlternativeLocation)new RubyDeclarationFinderHelper.RubyAltLocation(mtd, mtd == candidate));
                    }
                }
            }
            return loc;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public IndexedMethod findMethodDeclaration(Parser.Result parserResult, Node callNode, AstPath path, Set<IndexedMethod>[] alternativesHolder) {
        int astOffset = AstUtilities.getCallRange(callNode).getStart();
        try {
            Node method;
            BaseDocument doc = RubyUtils.getDocument(parserResult);
            if (doc == null) {
                return null;
            }
            int lexOffset = LexUtilities.getLexerOffset(parserResult, astOffset);
            if (lexOffset == -1) {
                return null;
            }
            OffsetRange range = this.getReferenceSpan((Document)doc, lexOffset);
            if (range == OffsetRange.NONE) {
                return null;
            }
            boolean leftSide = range.getEnd() <= astOffset;
            Node root = AstUtilities.getRoot(parserResult);
            RubyIndex index = RubyIndex.get(parserResult);
            if (root == null) {
                String text = doc.getText(range.getStart(), range.getLength());
                if (index == null || text.length() == 0) {
                    return null;
                }
                if (Character.isUpperCase(text.charAt(0))) {
                    return null;
                }
                Set<IndexedMethod> methods = index.getMethods(text, QuerySupport.Kind.EXACT);
                BaseDocument bdoc = doc;
                IndexedMethod candidate = this.findBestMethodMatch(text, methods, bdoc, astOffset, lexOffset, null, null, index);
                return candidate;
            }
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            int tokenOffset = astOffset;
            if (leftSide && tokenOffset > 0) {
                --tokenOffset;
            }
            String name = ((INameNode)callNode).getName();
            String fqn = AstUtilities.getFqnName(path);
            if (fqn == null || fqn.length() == 0) {
                fqn = "Object";
            }
            Call call = Call.getCallType(doc, (TokenHierarchy<Document>)th, lexOffset);
            boolean skipPrivate = true;
            boolean done = call.isMethodExpected();
            boolean skipInstanceMethods = call.isStatic();
            RubyType type = call.getType();
            String lhs = call.getLhs();
            QuerySupport.Kind kind = QuerySupport.Kind.EXACT;
            Node node = callNode;
            if (!type.isKnown() && lhs != null && node != null && call.isSimpleIdentifier() && (method = AstUtilities.findLocalScope(node, path)) != null) {
                ContextKnowledge knowledge = new ContextKnowledge(index, root, method, astOffset, lexOffset, AstUtilities.getParseResult(parserResult));
                RubyTypeInferencer inferencer = RubyTypeInferencer.create(knowledge);
                type = inferencer.inferType(lhs);
            }
            if (type.isKnown()) {
                if ("self".equals(lhs)) {
                    type = RubyType.create(fqn);
                    skipPrivate = false;
                } else if ("super".equals(lhs)) {
                    skipPrivate = false;
                    IndexedClass sc = index.getSuperclass(fqn);
                    if (sc != null) {
                        type = RubyType.create(sc.getFqn());
                    } else {
                        ClassNode cls = AstUtilities.findClass(path);
                        if (cls != null) {
                            type = RubyType.create(AstUtilities.getSuperclass(cls));
                        }
                    }
                    if (!type.isKnown()) {
                        type = RubyType.OBJECT;
                    }
                }
            }
            if (call == Call.LOCAL && fqn != null && fqn.length() == 0) {
                fqn = "Object";
            }
            Set<IndexedMethod> methods = this.getApplicableMethods(name, fqn, type, call, index);
            if (name.equals("new")) {
                Set<IndexedMethod> initializeMethods = this.getApplicableMethods("initialize", fqn, type, call, index);
                methods.addAll(initializeMethods);
            }
            IndexedMethod candidate = this.findBestMethodMatch(name, methods, doc, astOffset, lexOffset, path, callNode, index);
            if (alternativesHolder != null) {
                alternativesHolder[0] = methods;
            }
            return candidate;
        }
        catch (BadLocationException ble) {
            return null;
        }
    }

    private DeclarationFinder.DeclarationLocation findRDocMethod(ParserResult info, Document doc, int astOffset, int lexOffset, Node root, AstPath path, Node closest, RubyIndex index) {
        block9: {
            TokenHierarchy th = TokenHierarchy.get((Document)doc);
            TokenSequence ts = LexUtilities.getRubyTokenSequence((BaseDocument)doc, lexOffset);
            if (ts == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            ts.move(lexOffset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            Token token = ts.token();
            TokenSequence embedded = ts.embedded();
            if (embedded != null) {
                ts = embedded;
                embedded.move(lexOffset);
                if (!embedded.moveNext() && !embedded.movePrevious()) {
                    return DeclarationFinder.DeclarationLocation.NONE;
                }
                token = embedded.token();
            }
            if (token != null && token.id() == RubyCommentTokenId.COMMENT_LINK) {
                String method = ((Object)token.text()).toString();
                if (method.startsWith("#")) {
                    DeclarationFinder.DeclarationLocation loc = this.findMethod(info, root, method = method.substring(1), Arity.UNKNOWN);
                    if (loc == DeclarationFinder.DeclarationLocation.NONE) {
                        loc = this.findInstance(info, root, "@" + method, index);
                    }
                    return loc;
                }
                try {
                    URL url = new URL(method);
                    return new DeclarationFinder.DeclarationLocation(url);
                }
                catch (MalformedURLException mue) {
                    int methodIndex = method.indexOf("#");
                    if (methodIndex == -1 || methodIndex >= method.length() - 1) break block9;
                    String clz = method.substring(0, methodIndex);
                    method = method.substring(methodIndex + 1);
                    return this.findMethod(method, null, RubyType.create(clz), Call.UNKNOWN, info, astOffset, lexOffset, path, closest, index);
                }
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    DeclarationFinder.DeclarationLocation findLinkedMethod(ParserResult info, String method) {
        Node root = AstUtilities.getRoot((Parser.Result)info);
        AstPath path = new AstPath();
        path.descend(root);
        Node closest = root;
        int astOffset = 0;
        int lexOffset = 0;
        RubyIndex index = this.getIndex(info);
        if (root == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (method.startsWith("#")) {
            DeclarationFinder.DeclarationLocation loc = this.findMethod(info, root, method = method.substring(1), Arity.UNKNOWN);
            if (loc == DeclarationFinder.DeclarationLocation.NONE) {
                loc = this.findInstance(info, root, "@" + method, index);
            }
            return loc;
        }
        try {
            URL url = new URL(method);
            return new DeclarationFinder.DeclarationLocation(url);
        }
        catch (MalformedURLException mue) {
            int methodIndex = method.indexOf("#");
            if (methodIndex != -1 && methodIndex < method.length() - 1) {
                String clz = method.substring(0, methodIndex);
                method = method.substring(methodIndex + 1);
                return this.findMethod(method, null, RubyType.create(clz), Call.UNKNOWN, info, astOffset, lexOffset, path, closest, index);
            }
            return DeclarationFinder.DeclarationLocation.NONE;
        }
    }

    IndexedMethod findBestMethodMatch(String name, Set<IndexedMethod> methodSet, BaseDocument doc, int astOffset, int lexOffset, AstPath path, Node call, RubyIndex index) {
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>(methodSet);
        while (!methods.isEmpty()) {
            IndexedMethod method = this.findBestMethodMatchHelper(name, methods, doc, astOffset, lexOffset, path, call, index);
            Node node = AstUtilities.getForeignNode(method);
            if (node != null) {
                return method;
            }
            if (!methods.contains(method)) {
                methods.remove(methods.iterator().next());
                continue;
            }
            methods.remove(method);
        }
        if (methodSet.size() > 0) {
            return methodSet.iterator().next();
        }
        return null;
    }

    private IndexedMethod findBestMethodMatchHelper(String name, Set<IndexedMethod> methods, BaseDocument doc, int astOffset, int lexOffset, AstPath path, Node callNode, RubyIndex index) {
        Set<IndexedMethod> candidates = new HashSet<IndexedMethod>();
        if (callNode instanceof CallNode) {
            Node node = ((CallNode)callNode).getReceiverNode();
            String fqn = null;
            if (node instanceof Colon2Node) {
                fqn = AstUtilities.getFqn((Colon2Node)node);
            } else if (node instanceof ConstNode) {
                fqn = ((ConstNode)node).getName();
            }
            if (fqn != null) {
                while (fqn != null && fqn.length() > 0) {
                    for (IndexedMethod method : methods) {
                        if (!fqn.equals(method.getClz())) continue;
                        candidates.add(method);
                    }
                    IndexedClass superClass = index.getSuperclass(fqn);
                    if (superClass == null) break;
                    fqn = superClass.getSignature();
                }
            }
        }
        if (candidates.size() == 1) {
            return (IndexedMethod)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            methods = candidates;
        }
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        Call call = Call.getCallType(doc, (TokenHierarchy<Document>)th, lexOffset);
        boolean skipPrivate = true;
        if (path != null && callNode != null && call != Call.LOCAL && call != Call.NONE) {
            boolean skipInstanceMethods = call.isStatic();
            candidates = new HashSet();
            RubyType type = call.getType();
            if (type.isKnown()) {
                String lhs = call.getLhs();
                String fqn = AstUtilities.getFqnName(path);
                if ("self".equals(lhs)) {
                    type = RubyType.create(fqn);
                    skipPrivate = false;
                } else if ("super".equals(lhs)) {
                    skipPrivate = false;
                    IndexedClass sc = index.getSuperclass(fqn);
                    if (sc != null) {
                        type = RubyType.create(sc.getFqn());
                    } else {
                        ClassNode cls = AstUtilities.findClass(path);
                        if (cls != null) {
                            type = RubyType.create(AstUtilities.getSuperclass(cls));
                        }
                    }
                }
                if (type.isKnown()) {
                    while (candidates.size() == 0) {
                        candidates = index.getInheritedMethods(fqn + "::" + type, name, QuerySupport.Kind.EXACT);
                        int f = fqn.lastIndexOf("::");
                        if (f == -1) break;
                        fqn = fqn.substring(0, f);
                    }
                    if (candidates.size() == 0) {
                        candidates = index.getInheritedMethods(type, name, QuerySupport.Kind.EXACT);
                    }
                }
            }
            if (skipPrivate || skipInstanceMethods) {
                HashSet<IndexedMethod> m = new HashSet<IndexedMethod>();
                for (IndexedMethod method : candidates) {
                    if (skipPrivate && method.isPrivate() && !"new".equals(method.getName()) || skipInstanceMethods && !method.isStatic()) continue;
                    m.add(method);
                }
                candidates = m;
            }
            if (type != null) {
                HashSet<IndexedMethod> cs = new HashSet<IndexedMethod>();
                for (IndexedMethod m : candidates) {
                    if (m.getIn() == null || !type.isSingleton() || !m.getIn().endsWith(type.first())) continue;
                    cs.add(m);
                }
                if (cs.size() < candidates.size()) {
                    candidates = cs;
                }
            }
        }
        if (candidates.size() == 1) {
            return (IndexedMethod)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            methods = candidates;
        }
        candidates = new HashSet();
        for (IndexedMethod method : methods) {
            String attributes = method.getEncodedAttributes();
            if (attributes == null || attributes.length() <= 3) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return (IndexedMethod)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            methods = candidates;
        }
        Set<String> requires = null;
        if (path != null) {
            candidates = new HashSet();
            requires = AstUtilities.getRequires(path.root());
            for (IndexedMethod method : methods) {
                String require = method.getRequire();
                if (!requires.contains(require)) continue;
                candidates.add(method);
            }
            if (candidates.size() == 1) {
                return (IndexedMethod)candidates.iterator().next();
            }
            if (!candidates.isEmpty()) {
                methods = candidates;
            }
        }
        candidates = new HashSet();
        for (IndexedMethod method : methods) {
            String url = method.getFileUrl();
            if (!RubyUtils.isRubyStubsURL(url)) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return (IndexedMethod)candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            methods = candidates;
        }
        candidates = new HashSet();
        int longestDocLength = 0;
        for (IndexedMethod method : methods) {
            int length = method.getDocumentationLength();
            if (length > longestDocLength) {
                candidates.clear();
                candidates.add(method);
                longestDocLength = length;
                continue;
            }
            if (length <= 0 || length != longestDocLength) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return candidates.iterator().next();
        }
        if (!candidates.isEmpty()) {
            methods = candidates;
        }
        if (index != null && requires != null) {
            candidates = new HashSet();
            Set<String> allRequires = index.getRequiresTransitively(requires);
            for (IndexedMethod method : methods) {
                String require = method.getRequire();
                if (!allRequires.contains(require)) continue;
                candidates.add(method);
            }
            if (candidates.size() == 1) {
                return candidates.iterator().next();
            }
            if (!candidates.isEmpty()) {
                methods = candidates;
            }
        }
        if (methods.size() > 0) {
            return methods.iterator().next();
        }
        return null;
    }

    private DeclarationFinder.DeclarationLocation findLocal(ParserResult info, Node node, String name) {
        if (node instanceof LocalAsgnNode) {
            if (((INameNode)node).getName().equals(name)) {
                return RubyDeclarationFinder.getLocation(info, node);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            String newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName());
            if (name.equals(newName)) {
                return RubyDeclarationFinder.getLocation(info, node);
            }
        } else if (node instanceof ArgsNode) {
            ArgumentNode bn;
            ArgsNode an = (ArgsNode)node;
            if (an.getRequiredCount() > 0) {
                List args = an.childNodes();
                for (Node arg : args) {
                    if (!(arg instanceof ListNode)) continue;
                    List args2 = arg.childNodes();
                    for (Node arg2 : args2) {
                        if (!(arg2 instanceof ArgumentNode ? ((ArgumentNode)arg2).getName().equals(name) : arg2 instanceof LocalAsgnNode && ((LocalAsgnNode)arg2).getName().equals(name))) continue;
                        return RubyDeclarationFinder.getLocation(info, arg2);
                    }
                }
            }
            if (an.getRest() != null && (bn = an.getRest()).getName().equals(name)) {
                return RubyDeclarationFinder.getLocation(info, (Node)bn);
            }
            if (an.getBlock() != null && (bn = an.getBlock()).getName().equals(name)) {
                return RubyDeclarationFinder.getLocation(info, (Node)bn);
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findLocal(info, child, name)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findDynamic(ParserResult info, Node node, String name) {
        String newName;
        if (node instanceof DAsgnNode ? ((INameNode)node).getName().equals(name) : !this.ignoreAlias && node instanceof AliasNode && name.equals(newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName()))) {
            return RubyDeclarationFinder.getLocation(info, node);
        }
        List list = node.childNodes();
        for (Node child : list) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findDynamic(info, child, name)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstance(ParserResult info, Node node, String name, RubyIndex index) {
        if (node instanceof InstAsgnNode) {
            if (((INameNode)node).getName().equals(name)) {
                return RubyDeclarationFinder.getLocation(info, node);
            }
        } else if (!this.ignoreAlias && node instanceof AliasNode) {
            String newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName());
            if (name.equals(newName)) {
                return RubyDeclarationFinder.getLocation(info, node);
            }
        } else if (AstUtilities.isAttr(node)) {
            SymbolNode[] symbols = AstUtilities.getAttrSymbols(node);
            for (int i = 0; i < symbols.length; ++i) {
                if (!name.equals(symbols[i].getName())) continue;
                Node root = AstUtilities.getRoot((Parser.Result)info);
                DeclarationFinder.DeclarationLocation location = this.findInstanceFromIndex(info, name, new AstPath(root, node), index, true);
                if (location != DeclarationFinder.DeclarationLocation.NONE) {
                    return location;
                }
                return RubyDeclarationFinder.getLocation(info, (Node)symbols[i]);
            }
        }
        List list = node.childNodes();
        for (Node child : list) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findInstance(info, child, name, index)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findClassVar(ParserResult info, Node node, String name) {
        String newName;
        if (node instanceof ClassVarDeclNode ? ((INameNode)node).getName().equals(name) : !this.ignoreAlias && node instanceof AliasNode && name.equals(newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName()))) {
            return RubyDeclarationFinder.getLocation(info, node);
        }
        List list = node.childNodes();
        for (Node child : list) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findClassVar(info, child, name)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstanceFromIndex(ParserResult info, String name, AstPath path, RubyIndex index, boolean inherited) {
        String fqn = AstUtilities.getFqnName(path);
        Set<IndexedField> f = index.getInheritedFields(fqn, name, QuerySupport.Kind.EXACT, inherited);
        for (IndexedField field : f) {
            Node node = AstUtilities.getForeignNode(field);
            if (node == null) continue;
            return new DeclarationFinder.DeclarationLocation(field.getFileObject(), node.getPosition().getStartOffset(), (ElementHandle)field);
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findInstanceMethodsFromIndex(ParserResult info, String name, AstPath path, RubyIndex index) {
        String fqn = AstUtilities.getFqnName(path);
        Set<IndexedMethod> methods = index.getInheritedMethods(fqn, name, QuerySupport.Kind.EXACT);
        return RubyDeclarationFinder.getLocation(methods);
    }

    private DeclarationFinder.DeclarationLocation findGlobal(ParserResult info, Node node, String name) {
        String newName;
        if (node instanceof GlobalAsgnNode ? ((INameNode)node).getName().equals(name) : !this.ignoreAlias && node instanceof AliasNode && name.equals(newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName()))) {
            return RubyDeclarationFinder.getLocation(info, node);
        }
        List list = node.childNodes();
        for (Node child : list) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findGlobal(info, child, name)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private DeclarationFinder.DeclarationLocation findMethod(ParserResult info, Node node, String name, Arity arity) {
        String newName;
        if (node instanceof MethodDefNode ? ((MethodDefNode)node).getName().equals(name) && Arity.matches(arity, Arity.getDefArity(node)) : !this.ignoreAlias && node instanceof AliasNode && name.equals(newName = AstUtilities.getNameOrValue(((AliasNode)node).getNewName()))) {
            return RubyDeclarationFinder.getLocation(info, node);
        }
        List list = node.childNodes();
        for (Node child : list) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findMethod(info, child, name, arity)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    private static class RailsTarget {
        String name;
        OffsetRange range;
        String type;

        RailsTarget(String type, String name, OffsetRange range) {
            this.type = type;
            this.range = range;
            this.name = name;
        }

        public String toString() {
            return "RailsTarget(" + this.type + ", " + this.name + ", " + this.range + ")";
        }
    }
}

