/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Set;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.ConstDeclNode;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyBaseDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.elements.IndexedConstant;

final class RubyConstantDeclarationFinder
extends RubyBaseDeclarationFinder<IndexedConstant> {
    private final Node constantNode;

    RubyConstantDeclarationFinder(ParserResult parserResult, Node root, AstPath path, RubyIndex index, Node constantNode) {
        super(parserResult, root, path, index);
        this.constantNode = constantNode;
    }

    DeclarationFinder.DeclarationLocation findConstantDeclaration() {
        Set<? extends IndexedConstant> constants;
        if (this.constantNode instanceof Colon2Node) {
            String constantFqn = AstUtilities.getFqn((Colon2Node)this.constantNode);
            constants = this.index.getConstants(constantFqn);
        } else {
            String className = AstUtilities.getFqnName(this.path);
            constants = this.index.getConstants(className, this.getConstantName());
        }
        DeclarationFinder.DeclarationLocation decl = this.getElementDeclaration(constants, this.constantNode);
        if (decl != DeclarationFinder.DeclarationLocation.NONE) {
            return decl;
        }
        return RubyConstantDeclarationFinder.fix(this.findLocal(this.root), this.info);
    }

    @Override
    IndexedConstant findBestMatchHelper(Set<? extends IndexedConstant> constants) {
        return constants.isEmpty() ? null : constants.iterator().next();
    }

    private String getConstantName() {
        return ((INameNode)this.constantNode).getName();
    }

    private DeclarationFinder.DeclarationLocation findLocal(Node node) {
        if (node instanceof ConstDeclNode && ((ConstDeclNode)node).getName().equals(this.getConstantName())) {
            return RubyConstantDeclarationFinder.getLocation(this.info, node);
        }
        for (Node child : node.childNodes()) {
            DeclarationFinder.DeclarationLocation location;
            if (child.isInvisible() || (location = this.findLocal(child)) == DeclarationFinder.DeclarationLocation.NONE) continue;
            return location;
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }
}

