/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.List;
import org.jrubyparser.ast.ArgsCatNode;
import org.jrubyparser.ast.ArgsNode;
import org.jrubyparser.ast.ArgumentNode;
import org.jrubyparser.ast.ArrayNode;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.DefnNode;
import org.jrubyparser.ast.DefsNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.ListNode;
import org.jrubyparser.ast.LocalAsgnNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.SplatNode;
import org.jrubyparser.ast.VCallNode;
import org.netbeans.modules.ruby.AstUtilities;

public final class Arity {
    public static final Arity UNKNOWN = new Arity(-1, -1);
    private int min;
    private int max;

    private Arity(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int getMinArgs() {
        return this.min;
    }

    public int getMaxArgs() {
        return this.max;
    }

    public static Arity getCallArity(Node call) {
        assert (call instanceof CallNode || call instanceof VCallNode || call instanceof FCallNode);
        Arity arity = new Arity(0, 0);
        arity.initializeFromCall(call);
        if (arity.min == -1) {
            return UNKNOWN;
        }
        return arity;
    }

    public static boolean callHasArguments(Node call) {
        assert (call instanceof CallNode || call instanceof VCallNode || call instanceof FCallNode);
        return Arity.getCallArity((Node)call).min > 0;
    }

    private void initializeFromCall(Node node) {
        if (node instanceof FCallNode) {
            Node argsNode = ((FCallNode)node).getArgsNode();
            if (argsNode == null) {
                return;
            }
            this.initializeFromCall(argsNode);
        } else if (node instanceof LocalAsgnNode) {
            if (this.max < Integer.MAX_VALUE) {
                ++this.max;
            }
        } else if (node instanceof ArgsCatNode) {
            ArgsCatNode args = (ArgsCatNode)node;
            this.initializeFromCall(args.getFirstNode());
            this.max = Integer.MAX_VALUE;
        } else if (node instanceof ArgsNode) {
            ArgsNode args = (ArgsNode)node;
            if (args != null) {
                int value = args.getMaxArgumentsCount();
                if (value < 0) {
                    value = -(1 + value);
                }
                this.min = this.max = value;
            }
        } else if (node instanceof SplatNode) {
            this.max = Integer.MAX_VALUE;
        } else if (node instanceof CallNode) {
            Node argsNode = ((CallNode)node).getArgsNode();
            if (argsNode == null) {
                return;
            }
            this.initializeFromCall(argsNode);
        } else if (node instanceof VCallNode) {
            List children = node.childNodes();
            for (Node child : children) {
                if (child.isInvisible()) continue;
                this.initializeFromCall(child);
            }
        } else if (node instanceof ListNode) {
            List children = node.childNodes();
            for (Node child : children) {
                if (child.isInvisible()) continue;
                if (AstUtilities.isCall(child)) {
                    ++this.min;
                    this.max = Integer.MAX_VALUE;
                    continue;
                }
                if (child instanceof ArrayNode) {
                    ++this.min;
                    if (this.max >= Integer.MAX_VALUE) continue;
                    ++this.max;
                    continue;
                }
                this.initializeFromCall(child);
            }
        } else {
            ++this.min;
            if (this.max < Integer.MAX_VALUE) {
                ++this.max;
            }
        }
    }

    public static Arity getDefArity(Node method) {
        assert (method instanceof DefsNode || method instanceof DefnNode);
        Arity arity = new Arity(0, 0);
        List nodes = method.childNodes();
        for (Node c : nodes) {
            if (!(c instanceof ArgsNode)) continue;
            arity.initializeFromDef(c);
            break;
        }
        if (arity.min == -1) {
            return UNKNOWN;
        }
        return arity;
    }

    private void initializeFromDef(Node node) {
        if (node instanceof ArgsNode) {
            ArgsNode argsNode = (ArgsNode)node;
            if (argsNode.getPre() != null) {
                this.initializeFromDef((Node)argsNode.getPre());
            }
            if (argsNode.getOptional() != null) {
                this.initializeFromDef((Node)argsNode.getOptional());
            }
            if (argsNode.getBlock() != null && this.max < Integer.MAX_VALUE) {
                ++this.max;
            }
            if (argsNode.getRest() != null) {
                this.max = Integer.MAX_VALUE;
            }
        } else if (node instanceof ArgumentNode) {
            ++this.min;
            ++this.max;
        } else if (node instanceof LocalAsgnNode) {
            ++this.max;
        } else if (node instanceof ListNode) {
            List children = node.childNodes();
            for (Node child : children) {
                if (child.isInvisible()) continue;
                this.initializeFromDef(child);
            }
        }
    }

    public static boolean matches(Arity call, Arity method) {
        if (call == UNKNOWN || method == UNKNOWN) {
            return true;
        }
        if (call.max < method.min) {
            return false;
        }
        if (call.max == Integer.MAX_VALUE) {
            return true;
        }
        return call.max <= method.max;
    }

    public String toString() {
        return "Arity(" + this.min + ":" + (this.max == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(this.max)) + ")";
    }

    public static Arity createTestArity(int min, int max) {
        return new Arity(min, max);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Arity other = (Arity)obj;
        if (this.min != other.min) {
            return false;
        }
        return this.max == other.max;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.min;
        hash = 31 * hash + this.max;
        return hash;
    }
}

