/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.html.parser.AstNode;
import org.netbeans.editor.ext.html.parser.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.AstNodeVisitor;
import org.netbeans.editor.ext.html.parser.AstPath;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.gsf.HtmlElementHandle;
import org.netbeans.modules.parsing.api.Snapshot;

public class HtmlStructureScanner
implements StructureScanner {
    private static final Logger LOGGER = Logger.getLogger(HtmlStructureScanner.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public List<? extends StructureItem> scan(ParserResult info) {
        HtmlParserResult presult = (HtmlParserResult)info;
        AstNode root = presult.root();
        if (LOG) {
            LOGGER.log(Level.FINE, "HTML parser tree output:");
            LOGGER.log(Level.FINE, root.toString());
        }
        ArrayList<? extends StructureItem> elements = new ArrayList<StructureItem>(1);
        elements.addAll(new HtmlStructureItem(new HtmlElementHandle(root, info.getSnapshot().getSource().getFileObject()), info.getSnapshot()).getNestedItems());
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<OffsetRange>> folds(final ParserResult info) {
        final BaseDocument doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
        if (doc == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        final ArrayList tags = new ArrayList();
        final ArrayList comments = new ArrayList();
        AstNodeVisitor foldsSearch = new AstNodeVisitor(){

            public void visit(AstNode node) {
                if (node.type() == AstNode.NodeType.OPEN_TAG || node.type() == AstNode.NodeType.COMMENT) {
                    try {
                        int[] logicalRange = node.getLogicalRange();
                        int from = logicalRange[0];
                        int to = logicalRange[1];
                        int so = HtmlStructureScanner.documentPosition(from, info.getSnapshot());
                        int eo = HtmlStructureScanner.documentPosition(to, info.getSnapshot());
                        if (so == -1 || eo == -1) {
                            return;
                        }
                        if (eo > doc.getLength() && so > (eo = doc.getLength())) {
                            so = eo;
                        }
                        if (Utilities.getLineOffset((BaseDocument)doc, (int)so) < Utilities.getLineOffset((BaseDocument)doc, (int)eo)) {
                            if (node.type() == AstNode.NodeType.OPEN_TAG) {
                                tags.add(new OffsetRange(so, eo));
                            } else {
                                comments.add(new OffsetRange(so, eo));
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
            }
        };
        doc.readLock();
        try {
            Collection<AstNode> roots = ((HtmlParserResult)info).roots().values();
            for (AstNode root : roots) {
                AstNodeUtils.visitChildren((AstNode)root, (AstNodeVisitor)foldsSearch);
            }
        }
        finally {
            doc.readUnlock();
        }
        folds.put("tags", tags);
        folds.put("comments", comments);
        return folds;
    }

    public static int documentPosition(int astOffset, Snapshot snapshot) {
        return snapshot.getOriginalOffset(astOffset);
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }

    private static final class HtmlStructureItem
    implements StructureItem {
        private Snapshot snapshot;
        private HtmlElementHandle handle;
        private int myIndexInParent = -1;
        private List<StructureItem> items = null;

        private HtmlStructureItem(HtmlElementHandle handle, Snapshot snapshot) {
            this.handle = handle;
            this.snapshot = snapshot;
        }

        public String getName() {
            return this.handle.getName();
        }

        public String getSortText() {
            return Integer.toHexString(10000 + (int)this.getPosition());
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.appendHtml(this.getName());
            AstNode node = this.handle.node();
            String idAttr = this.getAttributeValue(node, "id");
            String classAttr = this.getAttributeValue(node, "class");
            if (idAttr != null) {
                formatter.appendHtml("&nbsp;<font color=808080>id=" + idAttr + "</font>");
            }
            if (classAttr != null) {
                formatter.appendHtml("&nbsp;<font color=808080>class=" + classAttr + "</font>");
            }
            return formatter.getText();
        }

        private String getAttributeValue(AstNode node, String key) {
            String value = this._getAttributeValue(node, key.toUpperCase(Locale.ENGLISH));
            if (value == null) {
                return this._getAttributeValue(node, key.toLowerCase(Locale.ENGLISH));
            }
            return value;
        }

        private String _getAttributeValue(AstNode node, String key) {
            AstNode.Attribute attr = node.getAttribute(key);
            if (attr == null) {
                return null;
            }
            return attr.unquotedValue();
        }

        public ElementHandle getElementHandle() {
            return this.handle;
        }

        synchronized int indexInParent() {
            if (this.myIndexInParent == -1) {
                AstNode papa = this.handle.node().parent();
                this.myIndexInParent = papa == null ? -2 : AstPath.indexInSimilarNodes((AstNode)papa, (AstNode)this.handle.node());
            }
            return this.myIndexInParent;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HtmlStructureItem)) {
                return false;
            }
            HtmlStructureItem item = (HtmlStructureItem)o;
            AstNode he = ((HtmlStructureItem)o).handle.node();
            AstNode me = this.handle.node();
            if (he.type() == me.type() && he.name().equals(me.name())) {
                return this.indexInParent() == item.indexInParent();
            }
            return false;
        }

        public int hashCode() {
            return this.handle.node().name().hashCode() + this.indexInParent();
        }

        public ElementKind getKind() {
            return ElementKind.TAG;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.getNestedItems().isEmpty();
        }

        public synchronized List<? extends StructureItem> getNestedItems() {
            if (this.items == null) {
                this.items = new ArrayList<StructureItem>(this.handle.node().children().size());
                for (AstNode child : this.handle.node().children()) {
                    if (child.type() != AstNode.NodeType.OPEN_TAG) continue;
                    HtmlElementHandle childHandle = new HtmlElementHandle(child, this.handle.getFileObject());
                    this.items.add(new HtmlStructureItem(childHandle, this.snapshot));
                }
            }
            return this.items;
        }

        public long getPosition() {
            return HtmlStructureScanner.documentPosition(this.handle.from(), this.snapshot);
        }

        public long getEndPosition() {
            return HtmlStructureScanner.documentPosition(this.handle.to(), this.snapshot);
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }
}

