/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.DisplayablesCategoryCD;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorMessageAwareness;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.propertyeditors.SVGImageEditorElement;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PropertyEditorSVGImage
extends PropertyEditorUserCode
implements PropertyEditorElement,
PropertyEditorResourceElementListener {
    private JRadioButton radioButton;
    private SVGImageEditorElement element;
    private String resourcePath = "";

    private PropertyEditorSVGImage() {
        super(NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"LBL_SVGIMAGE_UCLABEL"));
    }

    public static PropertyEditorSVGImage createInstance() {
        return new PropertyEditorSVGImage();
    }

    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.element != null) {
            this.element.clean(designComponent);
            this.element = null;
        }
        this.radioButton = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"LBL_SVGIMAGE_STR"));
        this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"ACSN_SVGIMAGE_STR"));
        this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorSVGImage.class, (String)"ACSD_SVGIMAGE_STR"));
        this.element = new SVGImageEditorElement();
        this.element.addPropertyEditorResourceElementListener(this);
        this.element.setPropertyEditorMessageAwareness((PropertyEditorMessageAwareness)this);
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.resourcePath);
        }
    }

    public void updateState(PropertyValue propertyValue) {
        if (propertyValue == null) {
            this.element.setDesignComponentWrapper(null);
        } else if (this.component != null && this.component.get() != null) {
            this.element.setDesignComponentWrapper(new PropertyEditorResourceElement.DesignComponentWrapper((DesignComponent)this.component.get()));
        }
        this.element.setAllEnabled(true);
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return MidpTypes.getString((PropertyValue)propertyValue);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public JComponent getCustomEditorComponent() {
        return this.element;
    }

    public Component getCustomEditor() {
        if (this.element == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return true;
    }

    public void elementChanged(PropertyEditorResourceElementEvent propertyEditorResourceElementEvent) {
        PropertyValue propertyValue = propertyEditorResourceElementEvent.getPropertyValue();
        this.resourcePath = MidpTypes.getString((PropertyValue)propertyValue);
        if (this.resourcePath == null) {
            this.resourcePath = "";
        }
        this.radioButton.setSelected(true);
    }

    private void saveValue(final String string) {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignComponent designComponent = (DesignComponent)this.component.get();
        final PropertyValue[] propertyValueArray = new PropertyValue[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                propertyValueArray[0] = designComponent.readProperty("resourcePath");
            }
        });
        designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent designComponent3 = MidpDocumentSupport.getCategoryComponent((DesignDocument)designComponent.getDocument(), (TypeID)DisplayablesCategoryCD.TYPEID);
                HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
                for (DesignComponent designComponent2 : designComponent3.getComponents()) {
                    if (!designComponent.getDocument().getDescriptorRegistry().isInHierarchy(SVGFormCD.TYPEID, designComponent2.getType()) || designComponent2.readProperty("svgImage").getComponent() != designComponent) continue;
                    hashSet.add(designComponent2);
                }
                if (!hashSet.isEmpty() && propertyValueArray[0].getKind() == PropertyValue.Kind.VALUE) {
                    if (propertyValueArray[0].getPrimitiveValue().equals(string)) {
                        return;
                    }
                    for (DesignComponent designComponent2 : hashSet) {
                        SVGFormSupport.removeAllSVGFormComponents(designComponent2);
                        FileObject fileObject = SVGFormSupport.getSVGFile(designComponent.getDocument(), string);
                        if (fileObject == null) continue;
                        SVGFormSupport.parseSVGImageItems(fileObject, designComponent2);
                    }
                    PropertyEditorSVGImage.super.setValue(MidpTypes.createStringValue((String)string));
                } else {
                    PropertyEditorSVGImage.super.setValue(MidpTypes.createStringValue((String)string));
                }
            }
        });
    }
}

