/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.client;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestUtil {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];

    RequestUtil() {
    }

    public static MediaType getMediaType(ClientRequest request) {
        Object header = request.getMetadata().getFirst((Object)"Content-Type");
        if (header == null) {
            return null;
        }
        if (header instanceof MediaType) {
            return (MediaType)header;
        }
        return MediaType.valueOf((String)header.toString());
    }

    public static MultivaluedMap<String, String> getQueryParameters(ClientRequest request) {
        URI uri = request.getURI();
        if (uri == null) {
            return null;
        }
        return UriComponent.decodeQuery((URI)uri, (boolean)true);
    }

    public static MultivaluedMap<String, String> getEntityParameters(ClientRequest request, Providers providers) {
        Object entity = request.getEntity();
        String method = request.getMethod();
        MediaType mediaType = RequestUtil.getMediaType(request);
        if (entity == null || method == null || !method.equalsIgnoreCase("POST") || mediaType == null || !mediaType.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)) {
            return new MultivaluedMapImpl();
        }
        if (entity instanceof MultivaluedMap) {
            return (MultivaluedMap)entity;
        }
        Type entityType = entity.getClass();
        if (entity instanceof GenericEntity) {
            GenericEntity generic = (GenericEntity)entity;
            entityType = generic.getType();
            entity = generic.getEntity();
        }
        Class<?> entityClass = entity.getClass();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageBodyWriter writer = providers.getMessageBodyWriter(entityClass, entityType, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        try {
            writer.writeTo(entity, entityClass, entityType, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE, null, (OutputStream)out);
        }
        catch (WebApplicationException wae) {
            throw new IllegalStateException(wae);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        MessageBodyReader reader = providers.getMessageBodyReader(MultivaluedMap.class, MultivaluedMap.class, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        try {
            return (MultivaluedMap)reader.readFrom(MultivaluedMap.class, MultivaluedMap.class, EMPTY_ANNOTATIONS, MediaType.APPLICATION_FORM_URLENCODED_TYPE, null, (InputStream)in);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

