/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.SwingWorker;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.JCheckTree;
import org.netbeans.lib.profiler.ui.components.tree.CheckTreeNode;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.netbeans.modules.profiler.selector.ui.BuilderUsageCalculator;
import org.netbeans.modules.profiler.selector.ui.CancellableController;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.utilities.trees.NodeFilter;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class RootSelectorTree
extends JCheckTree {
    private static NodeFilter<SelectorNode> DEFAULT_FILTER_INNER = new NodeFilter<SelectorNode>(){

        public boolean match(SelectorNode node) {
            return true;
        }

        public boolean maymatch(SelectorNode node) {
            return true;
        }
    };
    public static NodeFilter<SelectorNode> DEFAULT_FILTER = DEFAULT_FILTER_INNER;
    private static final String EMPTY_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_EmptyString");
    private static final String LOADING_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_LoadingString");
    private static final String ROOT_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_RootString");
    private static final String NO_PROJECT_STRING = NbBundle.getMessage(RootSelectorTree.class, (String)"RootSelectorTree_NoProjectString");
    private static final TreeModel DEFAULTMODEL = new DefaultTreeModel(new DefaultMutableTreeNode(EMPTY_STRING));
    public static final String SELECTION_TREE_VIEW_LIST_PROPERTY = "SELECTION_TREE_VIEW_LIST";
    private final Set<ClientUtils.SourceCodeSelection> currentSelectionSet = new HashSet<ClientUtils.SourceCodeSelection>();
    private ProgressDisplayer progress = ProgressDisplayer.DEFAULT;
    private NodeFilter<SelectorNode> nodeFilter = DEFAULT_FILTER_INNER;
    private Lookup context = Lookup.EMPTY;
    private SelectionTreeBuilder.Type builderType = null;

    public RootSelectorTree(BuilderUsageCalculator usageCalculator) {
        this(ProgressDisplayer.DEFAULT, DEFAULT_FILTER_INNER);
    }

    public RootSelectorTree(ProgressDisplayer pd) {
        this(pd, DEFAULT_FILTER_INNER);
    }

    public RootSelectorTree(NodeFilter<SelectorNode> filter) {
        this(ProgressDisplayer.DEFAULT, filter);
    }

    public RootSelectorTree(ProgressDisplayer pd, NodeFilter<SelectorNode> filter) {
        this.progress = pd;
        this.nodeFilter = filter;
        this.init();
    }

    public void setContext(Lookup context) {
        this.context = context;
        this.firePropertyChange(SELECTION_TREE_VIEW_LIST_PROPERTY, null, null);
    }

    public void setSelection(final ClientUtils.SourceCodeSelection[] selection) {
        new SwingWorker(false){

            protected void doInBackground() {
                RootSelectorTree.this.applySelection(selection);
            }

            protected void done() {
                RootSelectorTree.this.treeDidChange();
            }
        }.execute();
    }

    public ClientUtils.SourceCodeSelection[] getSelection() {
        return this.currentSelectionSet.toArray(new ClientUtils.SourceCodeSelection[this.currentSelectionSet.size()]);
    }

    public List<SelectionTreeBuilder.Type> getBuilderTypes() {
        class TypeEntry {
            SelectionTreeBuilder.Type type;
            int frequency;

            public TypeEntry(SelectionTreeBuilder.Type type) {
                this.type = type;
                this.frequency = 0;
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                TypeEntry other = (TypeEntry)obj;
                return this.type == other.type || this.type != null && this.type.equals((Object)other.type);
            }

            public int hashCode() {
                int hash = 5;
                hash = 53 * hash + (this.type != null ? this.type.hashCode() : 0);
                return hash;
            }
        }
        ArrayList<TypeEntry> entries = new ArrayList<TypeEntry>();
        for (SelectionTreeBuilderFactory factory : Lookup.getDefault().lookupAll(SelectionTreeBuilderFactory.class)) {
            Collection builders = factory.createBuildersFor(this.context);
            for (SelectionTreeBuilder builder : builders) {
                if (builder.estimatedNodeCount() == -1) continue;
                SelectionTreeBuilder.Type type = builder.getType();
                TypeEntry te = new TypeEntry(type);
                if (entries.contains(te)) {
                    int index = entries.indexOf(te);
                    te = (TypeEntry)entries.get(index);
                    te.frequency = te.frequency + (builder.isPreferred() ? 2 : 1);
                    continue;
                }
                entries.add(te);
            }
        }
        Collections.sort(entries, new Comparator<TypeEntry>(){

            @Override
            public int compare(TypeEntry o1, TypeEntry o2) {
                if (o1.frequency > o2.frequency) {
                    return 1;
                }
                if (o1.frequency < o2.frequency) {
                    return -1;
                }
                return 0;
            }
        });
        ArrayList<SelectionTreeBuilder.Type> types = new ArrayList<SelectionTreeBuilder.Type>(entries.size());
        for (TypeEntry entry : entries) {
            types.add(entry.type);
        }
        return types;
    }

    public void setBuilderType(SelectionTreeBuilder.Type type) {
        this.builderType = type;
        this.refreshTree();
    }

    public void reset() {
        this.setModel(DEFAULTMODEL);
        this.currentSelectionSet.clear();
        this.context = Lookup.EMPTY;
    }

    public static boolean canBeShown() {
        return Lookup.getDefault().lookup(SelectionTreeBuilderFactory.class) != null;
    }

    private void init() {
        UIUtils.makeTreeAutoExpandable((JTree)((Object)this), (boolean)true);
        this.addCheckTreeListener(new JCheckTree.CheckTreeListener(){

            public void checkTreeChanged(Collection<CheckTreeNode> nodes) {
            }

            public void checkNodeToggled(TreePath treePath, boolean before) {
                if (!before) {
                    SelectorNode selectedNode = (SelectorNode)treePath.getLastPathComponent();
                    Collection signatures = selectedNode.getRootMethods(true);
                    if (selectedNode.isFullyChecked()) {
                        ArrayList<ClientUtils.SourceCodeSelection> toRemove = new ArrayList<ClientUtils.SourceCodeSelection>();
                        for (ClientUtils.SourceCodeSelection signature : signatures) {
                            for (ClientUtils.SourceCodeSelection rootMethod : RootSelectorTree.this.currentSelectionSet) {
                                if (!signature.contains(rootMethod)) continue;
                                toRemove.add(rootMethod);
                            }
                        }
                        RootSelectorTree.this.removeSelection(toRemove.toArray(new ClientUtils.SourceCodeSelection[toRemove.size()]));
                        RootSelectorTree.this.applySelection(signatures.toArray(new ClientUtils.SourceCodeSelection[signatures.size()]));
                    } else {
                        ContainerNode parent = selectedNode.getParent();
                        ArrayList toAdd = new ArrayList();
                        if (parent != null) {
                            Enumeration siblings = parent.children();
                            while (siblings.hasMoreElements()) {
                                SelectorNode siblingNode = (SelectorNode)siblings.nextElement();
                                if (siblingNode == selectedNode || !siblingNode.isFullyChecked()) continue;
                                toAdd.addAll(siblingNode.getRootMethods(true));
                            }
                            toAdd.removeAll(signatures);
                        }
                        ArrayList<ClientUtils.SourceCodeSelection> toRemove = new ArrayList<ClientUtils.SourceCodeSelection>();
                        for (ClientUtils.SourceCodeSelection signature : signatures) {
                            for (ClientUtils.SourceCodeSelection rootMethod : RootSelectorTree.this.currentSelectionSet) {
                                if (!rootMethod.contains(signature) && !signature.contains(rootMethod)) continue;
                                toRemove.add(rootMethod);
                            }
                        }
                        toRemove.addAll(signatures);
                        TreeNode root = (TreeNode)RootSelectorTree.this.getModel().getRoot();
                        ArrayList selection = new ArrayList();
                        int firstLevelCnt = root.getChildCount();
                        for (int i = 0; i < firstLevelCnt; ++i) {
                            RootSelectorTree.calculateInflatedSelection((SelectorNode)parent, (SelectorNode)root.getChildAt(i), selection, toRemove);
                        }
                        RootSelectorTree.addRequiredPackages(selection, toAdd);
                        RootSelectorTree.this.removeSelection(toRemove.toArray(new ClientUtils.SourceCodeSelection[toRemove.size()]));
                        RootSelectorTree.this.applySelection(toAdd.toArray(new ClientUtils.SourceCodeSelection[toAdd.size()]));
                    }
                }
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){
            private volatile boolean openingSubtree = false;

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(final TreeExpansionEvent event) throws ExpandVetoException {
                TreeNode node = (TreeNode)event.getPath().getLastPathComponent();
                if (!(node instanceof DefaultMutableTreeNode)) {
                    return;
                }
                final DefaultMutableTreeNode myNode = (DefaultMutableTreeNode)node;
                if (myNode.getChildCount() == -1) {
                    if (this.openingSubtree) {
                        throw new ExpandVetoException(event);
                    }
                    this.openingSubtree = true;
                    new SwingWorker(){

                        protected void doInBackground() {
                            RootSelectorTree.checkNodeChildren(myNode, false);
                        }

                        protected void nonResponding() {
                            RootSelectorTree.this.progress.showProgress(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"NodeLoadingMessage"));
                        }

                        protected void done() {
                            RootSelectorTree.this.progress.close();
                            RootSelectorTree.this.expandPath(event.getPath());
                            RootSelectorTree.this.doLayout();
                            openingSubtree = false;
                        }
                    }.execute();
                    throw new ExpandVetoException(event);
                }
                RootSelectorTree.checkNodeChildren(myNode, false);
            }
        });
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setModel(DEFAULTMODEL);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode myNode, boolean recurse) {
        RootSelectorTree.checkNodeChildren(myNode, recurse, null);
    }

    private static void checkNodeChildren(DefaultMutableTreeNode myNode, boolean recurse, CancellableController controller) {
        if (controller != null && controller.isCancelled()) {
            return;
        }
        Enumeration<TreeNode> children = myNode.children();
        if (myNode instanceof CheckTreeNode && ((CheckTreeNode)myNode).isFullyChecked()) {
            while (children.hasMoreElements()) {
                TreeNode child = children.nextElement();
                if (!(child instanceof CheckTreeNode)) continue;
                ((CheckTreeNode)child).setChecked(true);
                if (!recurse) continue;
                RootSelectorTree.checkNodeChildren((DefaultMutableTreeNode)((CheckTreeNode)child), recurse, controller);
            }
        }
    }

    private void applySelection(ClientUtils.SourceCodeSelection[] selections) {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> childrenEnum = root.children();
        while (childrenEnum.hasMoreElements()) {
            TreeNode child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection selection : selections) {
                this.applySelection((SelectorNode)child, selection);
            }
        }
        this.currentSelectionSet.addAll(Arrays.asList(selections));
    }

    private void applySelection(SelectorNode node, ClientUtils.SourceCodeSelection selection) {
        ClientUtils.SourceCodeSelection signature = node.getSignature();
        if (signature != null) {
            if (signature.equals((Object)selection) || selection.contains(signature)) {
                node.setChecked(true);
                return;
            }
            if (!signature.contains(selection)) {
                return;
            }
        }
        Enumeration childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            Object child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            this.applySelection((SelectorNode)child, selection);
        }
    }

    private void removeSelection(ClientUtils.SourceCodeSelection[] selections) {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> childrenEnum = root.children();
        while (childrenEnum.hasMoreElements()) {
            TreeNode child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection selection : selections) {
                this.removeSelection((SelectorNode)child, selection);
            }
        }
        this.currentSelectionSet.removeAll(Arrays.asList(selections));
    }

    private void removeSelection(SelectorNode node, ClientUtils.SourceCodeSelection selection) {
        ClientUtils.SourceCodeSelection signature = node.getSignature();
        if (signature != null) {
            if (signature.equals((Object)selection)) {
                node.setChecked(false);
                return;
            }
            if (!signature.contains(selection)) {
                return;
            }
        }
        Enumeration childrenEnum = node.children();
        while (childrenEnum.hasMoreElements()) {
            Object child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            this.removeSelection((SelectorNode)child, selection);
        }
    }

    private static void calculateInflatedSelection(SelectorNode node, SelectorNode root, Collection<ClientUtils.SourceCodeSelection> selection, Collection<ClientUtils.SourceCodeSelection> toRemove) {
        if (node == null || root == null || selection == null || toRemove == null) {
            return;
        }
        if (root.isFullyChecked() || root.isPartiallyChecked()) {
            if (root.getSignature() != null && root.isFullyChecked() && !toRemove.contains(root.getSignature())) {
                selection.add(root.getSignature());
            }
            if (root.getSignature() == null || node.getSignature() == null || root.getSignature().contains(node.getSignature())) {
                int childrenCount = root.getChildCount();
                for (int i = 0; i < childrenCount; ++i) {
                    SelectorNode childNode = (SelectorNode)root.getChildAt(i);
                    RootSelectorTree.calculateInflatedSelection(node, childNode, selection, toRemove);
                }
            }
        }
    }

    private static void addRequiredPackages(Collection<ClientUtils.SourceCodeSelection> selection, Collection<ClientUtils.SourceCodeSelection> toAdd) {
        for (ClientUtils.SourceCodeSelection signature : selection) {
            boolean appendSignature = true;
            for (ClientUtils.SourceCodeSelection addSignature : toAdd) {
                appendSignature = appendSignature && !signature.contains(addSignature);
            }
            if (!appendSignature) continue;
            toAdd.add(signature);
        }
    }

    private void refreshTree() {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(LOADING_STRING)));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setModel(new DefaultTreeModel(this.getTreeRoot()));
        this.applyCurrentSelection();
        this.treeDidChange();
    }

    private DefaultMutableTreeNode getTreeRoot() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(ROOT_STRING);
        if (this.builderType != null) {
            for (SelectionTreeBuilderFactory factory : Lookup.getDefault().lookupAll(SelectionTreeBuilderFactory.class)) {
                Collection builders = factory.createBuildersFor(this.context);
                for (SelectionTreeBuilder builder : builders) {
                    if (!builder.getType().equals((Object)this.builderType)) continue;
                    for (SelectorNode node : builder.buildSelectionTree()) {
                        rootNode.add((MutableTreeNode)node);
                    }
                }
            }
        }
        return rootNode;
    }

    private void applyCurrentSelection() {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> childrenEnum = root.children();
        while (childrenEnum.hasMoreElements()) {
            TreeNode child = childrenEnum.nextElement();
            if (!(child instanceof SelectorNode)) continue;
            for (ClientUtils.SourceCodeSelection selection : this.currentSelectionSet) {
                this.applySelection((SelectorNode)child, selection);
            }
        }
    }
}

