/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.methodcontroller;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.dd.api.ejb.CmpField;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelationshipRole;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MethodParams;
import org.netbeans.modules.j2ee.dd.api.ejb.Query;
import org.netbeans.modules.j2ee.dd.api.ejb.QueryMethod;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.AbstractMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityGenerateFromImplVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EntityGenerateFromIntfVisitor;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.MethodType;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class EntityMethodController
extends AbstractMethodController {
    private static final int IDX_ABSTRACT_SCHEMA_NAME = 0;
    private static final int IDX_PERSISTENCE_TYPE = 1;
    private static final int IDX_LOCAL_HOME = 2;
    private static final int IDX_HOME = 3;
    private final MetadataModel<EjbJarMetadata> metadataModel;
    private final String ejbClass;
    private final Set<Modifier> modifiersPublicAbstract = new HashSet<Modifier>(2);
    private final String abstractSchemaName;
    private final String persistenceType;
    private final String localHome;
    private final String home;

    public EntityMethodController(final String string, MetadataModel<EjbJarMetadata> metadataModel) {
        super(string, metadataModel);
        this.metadataModel = metadataModel;
        this.modifiersPublicAbstract.add(Modifier.PUBLIC);
        this.modifiersPublicAbstract.add(Modifier.ABSTRACT);
        final String[] stringArray = new String[4];
        this.ejbClass = string;
        try {
            metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

                public FileObject run(EjbJarMetadata ejbJarMetadata) {
                    Entity entity = (Entity)ejbJarMetadata.findByEjbClass(string);
                    if (entity != null) {
                        stringArray[0] = entity.getAbstractSchemaName();
                        stringArray[1] = entity.getPersistenceType();
                        stringArray[2] = entity.getLocalHome();
                        stringArray[3] = entity.getHome();
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.abstractSchemaName = stringArray[0];
        this.persistenceType = stringArray[1];
        this.localHome = stringArray[2];
        this.home = stringArray[3];
    }

    public List getMethods(CmpField cmpField) {
        return this.getMethods(cmpField.getFieldName());
    }

    public List getMethods(CmrField cmrField) {
        return this.getMethods(cmrField.getCmrFieldName());
    }

    public void deleteQueryMapping(MethodModel methodModel, FileObject fileObject) throws IOException {
    }

    public void deleteField(CmpField cmpField, FileObject fileObject) throws IOException {
    }

    private void removeMethodsFromBean(List<MethodModel> list) throws IOException {
        for (MethodModel methodModel : list) {
            EjbMethodController.ClassMethodPair classMethodPair;
            if (this.hasLocal() && (classMethodPair = this.getInterface(methodModel, true)) != null) {
                this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
            }
            if (this.hasRemote() && (classMethodPair = this.getInterface(methodModel, false)) != null) {
                this.removeMethodFromClass(classMethodPair.getClassName(), classMethodPair.getMethodModel());
            }
            this.removeMethodFromClass(this.getBeanClass(), methodModel);
        }
    }

    public void deleteField(CmrField cmrField, FileObject fileObject) throws IOException {
    }

    public static String getMethodName(String string, boolean bl) {
        String string2 = bl ? "get" : "set";
        return EntityMethodController.prependAndUpper(string, string2);
    }

    @Override
    public boolean hasJavaImplementation(MethodModel methodModel) {
        return this.hasJavaImplementation(this.getMethodTypeFromInterface(methodModel));
    }

    @Override
    public boolean hasJavaImplementation(MethodType methodType) {
        return !this.isCMP() || !this.isFinder(methodType.getKind()) && !this.isSelect(methodType.getKind());
    }

    @Override
    public MethodType getMethodTypeFromImpl(MethodModel methodModel) {
        MethodType methodType = null;
        if (methodModel.getName().startsWith("ejbCreate") || methodModel.getName().startsWith("ejbPostCreate")) {
            methodType = new MethodType.CreateMethodType(methodModel);
        } else if (!methodModel.getName().startsWith("ejb")) {
            methodType = new MethodType.BusinessMethodType(methodModel);
        } else if (methodModel.getName().startsWith("ejbSelect")) {
            methodType = new MethodType.SelectMethodType(methodModel);
        } else if (methodModel.getName().startsWith("ejbHome")) {
            methodType = new MethodType.HomeMethodType(methodModel);
        }
        return methodType;
    }

    @Override
    public MethodType getMethodTypeFromInterface(MethodModel methodModel) {
        MethodType methodType = this.findInClass(this.localHome, methodModel) || this.findInClass(this.home, methodModel) ? (methodModel.getName().startsWith("create") ? new MethodType.CreateMethodType(methodModel) : (methodModel.getName().startsWith("find") ? new MethodType.FinderMethodType(methodModel) : new MethodType.HomeMethodType(methodModel))) : new MethodType.BusinessMethodType(methodModel);
        return methodType;
    }

    @Override
    public AbstractMethodController.GenerateFromImpl createGenerateFromImpl() {
        return new EntityGenerateFromImplVisitor();
    }

    @Override
    public AbstractMethodController.GenerateFromIntf createGenerateFromIntf() {
        try {
            return new EntityGenerateFromIntfVisitor(this.ejbClass, this.metadataModel);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return null;
        }
    }

    public void addSelectMethod(MethodModel methodModel, String string, FileObject fileObject) throws IOException {
        this.addMethodToClass(this.getBeanClass(), methodModel);
        this.addEjbQl(methodModel, string, fileObject);
    }

    @Override
    public void addEjbQl(MethodModel methodModel, String string, FileObject fileObject) throws IOException {
        Entity entity;
        if (this.isBMP()) {
            super.addEjbQl(methodModel, string, fileObject);
        }
        if ((entity = (Entity)this.metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Entity>(){

            public Entity run(EjbJarMetadata ejbJarMetadata) {
                return (Entity)ejbJarMetadata.findByEjbClass(EntityMethodController.this.ejbClass);
            }
        })) != null) {
            entity.addQuery(this.buildQuery(entity, methodModel, string));
        }
        DDProvider.getDefault().getDDRoot(fileObject).write(fileObject);
    }

    private MethodModel addSetterMethod(String string, MethodModel.Variable variable, Set<Modifier> set, boolean bl, Entity entity) {
        MethodModel methodModel = this.createSetterMethod(string, variable, set, bl);
        this.addMethod(string, methodModel, entity);
        return methodModel;
    }

    private MethodModel addGetterMethod(String string, MethodModel.Variable variable, Set<Modifier> set, boolean bl, Entity entity) {
        MethodModel methodModel = this.createGetterMethod(string, variable, set, bl);
        this.addMethod(string, methodModel, entity);
        return methodModel;
    }

    private void addMethod(String string, MethodModel methodModel, Entity entity) {
        try {
            this.addMethodToClass(string, methodModel);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private MethodModel createGetterMethod(String string, MethodModel.Variable variable, Set<Modifier> set, boolean bl) {
        String string2 = variable.getName();
        List list = bl ? Collections.singletonList(RemoteException.class.getName()) : Collections.emptyList();
        MethodModel methodModel = MethodModel.create((String)EntityMethodController.getMethodName(string2, true), (String)"void", (String)"", Collections.singletonList(variable), list, set);
        return methodModel;
    }

    private MethodModel createSetterMethod(String string, MethodModel.Variable variable, Set<Modifier> set, boolean bl) {
        String string2 = variable.getName();
        List list = bl ? Collections.singletonList(RemoteException.class.getName()) : Collections.emptyList();
        MethodModel methodModel = MethodModel.create((String)EntityMethodController.getMethodName(string2, false), (String)"void", (String)"", Collections.singletonList(variable), list, set);
        return methodModel;
    }

    private boolean isBMP() {
        return "Bean".equals(this.persistenceType);
    }

    public boolean isCMP() {
        return !this.isBMP();
    }

    private boolean isFinder(MethodType.Kind kind) {
        return kind == MethodType.Kind.FINDER;
    }

    private boolean isSelect(MethodType.Kind kind) {
        return kind == MethodType.Kind.SELECT;
    }

    @Override
    public String createDefaultQL(MethodModel methodModel) {
        String string = null;
        if (methodModel.getName().startsWith("find") && this.isCMP()) {
            string = "SELECT OBJECT(o) \nFROM " + this.abstractSchemaName + " o";
        } else if (methodModel.getName().startsWith("ejbSelect")) {
            string = "SELECT COUNT(o) \nFROM " + this.abstractSchemaName + " o";
        }
        return string;
    }

    private Query buildQuery(Entity entity, MethodModel methodModel, String string) {
        Query query = entity.newQuery();
        QueryMethod queryMethod = query.newQueryMethod();
        queryMethod.setMethodName(methodModel.getName());
        MethodParams methodParams = queryMethod.newMethodParams();
        for (MethodModel.Variable variable : methodModel.getParameters()) {
            methodParams.addMethodParam(variable.getType());
        }
        queryMethod.setMethodParams(methodParams);
        query.setQueryMethod(queryMethod);
        query.setEjbQl(string);
        return query;
    }

    private static String prependAndUpper(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        return string2 + stringBuffer.toString();
    }

    private boolean isEjbUsed(EjbRelationshipRole ejbRelationshipRole, String string, String string2) {
        return ejbRelationshipRole != null && ejbRelationshipRole.getRelationshipRoleSource() != null && string.equals(ejbRelationshipRole.getRelationshipRoleSource().getEjbName()) && string2.equals(ejbRelationshipRole.getCmrField().getCmrFieldName());
    }

    private boolean relationContainsField(EjbRelation ejbRelation, String string, String string2) {
        return this.isEjbUsed(ejbRelation.getEjbRelationshipRole(), string, string2) || this.isEjbUsed(ejbRelation.getEjbRelationshipRole2(), string, string2);
    }

    private void deleteRelationships(String string) {
    }

    private List<MethodModel> getMethods(String string) {
        assert (string != null);
        LinkedList<MethodModel> linkedList = new LinkedList<MethodModel>();
        String string2 = this.getBeanClass();
        MethodModel methodModel = this.getGetterMethod(string2, string);
        if (methodModel != null) {
            linkedList.add(methodModel);
            MethodModel methodModel2 = this.getSetterMethod(string2, string, methodModel.getReturnType());
            if (methodModel2 != null) {
                linkedList.add(methodModel2);
            }
        }
        return linkedList;
    }

    public MethodModel getGetterMethod(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        MethodModel methodModel = MethodModel.create((String)EntityMethodController.getMethodName(string2, true), (String)"void", (String)"", Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
        return this.findInClass(string, methodModel) ? methodModel : null;
    }

    public MethodModel getGetterMethod(String string, boolean bl) {
        return this.getGetterMethod(this.getBeanInterface(bl, true), string);
    }

    public MethodModel getSetterMethod(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string3 == null) {
            return null;
        }
        MethodModel methodModel = MethodModel.create((String)EntityMethodController.getMethodName(string2, true), (String)"void", (String)"", Collections.singletonList(MethodModel.Variable.create((String)string3, (String)"arg0")), Collections.emptyList(), Collections.emptySet());
        return this.findInClass(string, methodModel) ? methodModel : null;
    }

    public MethodModel getSetterMethod(String string, boolean bl) {
        MethodModel.Variable variable = this.getField(string, true);
        if (variable == null) {
            return null;
        }
        return this.getSetterMethod(this.getBeanInterface(bl, true), string, variable.getType());
    }

    public MethodModel getFinderMethod(String string, String string2, MethodModel methodModel) {
        if (methodModel == null) {
            return null;
        }
        MethodModel methodModel2 = MethodModel.create((String)EntityMethodController.getMethodName(string2, true), (String)"void", (String)"", Collections.singletonList(MethodModel.Variable.create((String)methodModel.getReturnType(), (String)"arg0")), Collections.emptyList(), Collections.emptySet());
        return this.findInClass(string, methodModel2) ? methodModel2 : null;
    }

    @Override
    public boolean supportsMethodType(MethodType.Kind kind) {
        return !this.isSelect(kind) || this.isCMP();
    }

    private void updateFieldAccessors(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.updateFieldAccessor(string, true, true, bl);
        this.updateFieldAccessor(string, false, true, bl2);
        this.updateFieldAccessor(string, true, false, bl3);
        this.updateFieldAccessor(string, false, false, bl4);
    }

    public void updateFieldAccessor(String string, boolean bl, boolean bl2, boolean bl3) {
    }

    private MethodModel.Variable getField(String string, boolean bl) {
        String string2 = this.getBeanClass();
        MethodModel methodModel = this.getGetterMethod(string2, string);
        if (methodModel == null) {
            if (!bl) {
                return null;
            }
            MethodModel.Variable variable = MethodModel.Variable.create((String)String.class.getName(), (String)string);
            this.createGetterMethod(this.getBeanClass(), variable, this.modifiersPublicAbstract, false);
            return variable;
        }
        String string3 = methodModel.getReturnType();
        if (string3 == null) {
            return null;
        }
        return MethodModel.Variable.create((String)string3, (String)string);
    }
}

