/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.common.MessageDestination;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfig;
import org.netbeans.modules.j2ee.dd.api.ejb.ActivationConfigProperty;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class MessageGenerator {
    private static final String EJB21_EJBCLASS = "Templates/J2EE/EJB21/MessageDrivenEjbClass.java";
    private static final String EJB30_QUEUE_EJBCLASS = "Templates/J2EE/EJB30/MessageDrivenQueueEjbClass.java";
    private static final String EJB30_TOPIC_EJBCLASS = "Templates/J2EE/EJB30/MessageDrivenTopicEjbClass.java";
    private final FileObject pkg;
    private final org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination;
    private final boolean isSimplified;
    private final boolean isXmlBased;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, String> templateParameters;

    public static MessageGenerator create(String string, FileObject fileObject, org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination, boolean bl, boolean bl2) {
        return new MessageGenerator(string, fileObject, messageDestination, bl, bl2, false);
    }

    protected MessageGenerator(String string, FileObject fileObject, org.netbeans.modules.j2ee.deployment.common.api.MessageDestination messageDestination, boolean bl, boolean bl2, boolean bl3) {
        this.pkg = fileObject;
        this.messageDestination = messageDestination;
        this.isSimplified = bl;
        this.isXmlBased = bl2;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getMessageDrivenEjbNamePrefix() + string + this.ejbNameOptions.getMessageDrivenEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getMessageDrivenEjbClassPrefix() + string + this.ejbNameOptions.getMessageDrivenEjbClassSuffix();
        this.displayName = this.ejbNameOptions.getMessageDrivenDisplayNamePrefix() + string + this.ejbNameOptions.getMessageDrivenDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(fileObject);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, String>();
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("messageDestinationName", messageDestination.getName());
        if (bl3) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    public FileObject generate() throws IOException {
        FileObject fileObject = null;
        if (this.isSimplified) {
            fileObject = this.generateEJB30Classes();
            if (this.isXmlBased) {
                this.generateEJB30Xml();
            }
        } else {
            fileObject = this.generateEJB21Classes();
            if (this.isXmlBased) {
                try {
                    this.generateEJB21Xml();
                }
                catch (VersionNotSupportedException versionNotSupportedException) {
                    Exceptions.printStackTrace((Throwable)versionNotSupportedException);
                }
            }
            try {
                Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
                J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
                j2eeModuleProvider.getConfigSupport().bindMdbToMessageDestination(this.ejbName, this.messageDestination.getName(), this.messageDestination.getType());
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return fileObject;
    }

    private FileObject generateEJB21Classes() throws IOException {
        return GenerationUtils.createClass((String)EJB21_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
    }

    private boolean isQueue() {
        return MessageDestination.Type.QUEUE.equals((Object)this.messageDestination.getType());
    }

    private FileObject generateEJB30Classes() throws IOException {
        String string = this.isQueue() ? EJB30_QUEUE_EJBCLASS : EJB30_TOPIC_EJBCLASS;
        return GenerationUtils.createClass((String)string, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
    }

    private void generateEJB21Xml() throws IOException, VersionNotSupportedException {
        ActivationConfigProperty activationConfigProperty;
        Object object;
        ActivationConfigProperty activationConfigProperty2;
        String string;
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.pkg);
        org.netbeans.modules.j2ee.dd.api.ejb.EjbJar ejbJar2 = DDProvider.getDefault().getDDRoot(ejbJar.getDeploymentDescriptor());
        EnterpriseBeans enterpriseBeans = ejbJar2.getEnterpriseBeans();
        MessageDriven messageDriven = null;
        if (enterpriseBeans == null) {
            enterpriseBeans = ejbJar2.newEnterpriseBeans();
            ejbJar2.setEnterpriseBeans(enterpriseBeans);
        }
        messageDriven = enterpriseBeans.newMessageDriven();
        ActivationConfig activationConfig = messageDriven.newActivationConfig();
        ActivationConfigProperty activationConfigProperty3 = activationConfig.newActivationConfigProperty();
        activationConfigProperty3.setActivationConfigPropertyName("destinationType");
        ActivationConfigProperty activationConfigProperty4 = activationConfig.newActivationConfigProperty();
        activationConfigProperty4.setActivationConfigPropertyName("acknowledgeMode");
        activationConfigProperty4.setActivationConfigPropertyValue("Auto-acknowledge");
        activationConfig.addActivationConfigProperty(activationConfigProperty4);
        if (this.isQueue()) {
            string = "javax.jms.Queue";
            messageDriven.setMessageDestinationType(string);
            activationConfigProperty3.setActivationConfigPropertyValue(string);
        } else {
            string = "javax.jms.Topic";
            messageDriven.setMessageDestinationType(string);
            activationConfigProperty3.setActivationConfigPropertyValue(string);
            activationConfigProperty2 = activationConfig.newActivationConfigProperty();
            activationConfigProperty2.setActivationConfigPropertyName("subscriptionDurability");
            activationConfigProperty2.setActivationConfigPropertyValue("Durable");
            activationConfig.addActivationConfigProperty(activationConfigProperty2);
            object = activationConfig.newActivationConfigProperty();
            object.setActivationConfigPropertyName("clientId");
            object.setActivationConfigPropertyValue(this.ejbName);
            activationConfig.addActivationConfigProperty(object);
            activationConfigProperty = activationConfig.newActivationConfigProperty();
            activationConfigProperty.setActivationConfigPropertyName("subscriptionName");
            activationConfigProperty.setActivationConfigPropertyValue(this.ejbName);
            activationConfig.addActivationConfigProperty(activationConfigProperty);
        }
        activationConfig.addActivationConfigProperty(activationConfigProperty3);
        messageDriven.setActivationConfig(activationConfig);
        messageDriven.setEjbName(this.ejbName);
        messageDriven.setDisplayName(this.displayName);
        messageDriven.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        messageDriven.setTransactionType("Container");
        enterpriseBeans.addMessageDriven(messageDriven);
        string = ejbJar2.getSingleAssemblyDescriptor();
        if (string == null) {
            string = ejbJar2.newAssemblyDescriptor();
            ejbJar2.setAssemblyDescriptor((AssemblyDescriptor)string);
        }
        activationConfigProperty2 = string.newMessageDestination();
        object = this.messageDestination.getName();
        activationConfigProperty2.setDisplayName("Destination for " + this.displayName);
        activationConfigProperty2.setMessageDestinationName((String)object);
        string.addMessageDestination((MessageDestination)activationConfigProperty2);
        messageDriven.setMessageDestinationLink((String)object);
        activationConfigProperty = string.newContainerTransaction();
        activationConfigProperty.setTransAttribute("Required");
        Method method = activationConfigProperty.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        activationConfigProperty.addMethod(method);
        string.addContainerTransaction((ContainerTransaction)activationConfigProperty);
        ejbJar2.write(ejbJar.getDeploymentDescriptor());
    }

    private void generateEJB30Xml() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }
}

