/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.spi.project.support.rake;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.RakeProjectHelper;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;

public final class SourcesHelper {
    private final Project prj;
    private final RakeProjectHelper project;
    private final PropertyEvaluator evaluator;
    private final List<SourceRoot> principalSourceRoots = new ArrayList<SourceRoot>();
    private final List<Root> nonSourceRoots = new ArrayList<Root>();
    private final List<TypedSourceRoot> typedSourceRoots = new ArrayList<TypedSourceRoot>();
    private int registeredRootAlgorithm;
    private Set<FileObject> lastRegisteredRoots;
    private PropertyChangeListener propChangeL;

    public SourcesHelper(Project prj, RakeProjectHelper project, PropertyEvaluator evaluator) {
        this.prj = prj;
        this.project = project;
        this.evaluator = evaluator;
    }

    public void addPrincipalSourceRoot(String location, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.principalSourceRoots.add(new SourceRoot(location, displayName, icon, openedIcon));
    }

    public void addNonSourceRoot(String location) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.nonSourceRoots.add(new Root(location));
    }

    public void addTypedSourceRoot(String location, String type, String displayName, Icon icon, Icon openedIcon) throws IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called");
        }
        this.typedSourceRoots.add(new TypedSourceRoot(type, location, displayName, icon, openedIcon));
    }

    private Project getProject() {
        return this.prj;
    }

    public void registerExternalRoots(int algorithm) throws IllegalArgumentException, IllegalStateException {
        if (this.lastRegisteredRoots != null) {
            throw new IllegalStateException("registerExternalRoots was already called before");
        }
        this.registeredRootAlgorithm = algorithm;
        this.remarkExternalRoots();
    }

    private void remarkExternalRoots() throws IllegalArgumentException {
        HashSet<FileObject> newRootsToRegister;
        ArrayList<SourceRoot> allRoots = new ArrayList<SourceRoot>(this.principalSourceRoots);
        allRoots.addAll(this.nonSourceRoots);
        Project p = this.getProject();
        FileObject pdir = this.project.getProjectDirectory();
        if (this.lastRegisteredRoots == null) {
            newRootsToRegister = null;
            this.lastRegisteredRoots = new HashSet<FileObject>();
            this.propChangeL = new PropChangeL();
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.propChangeL, (Object)this.evaluator));
        } else {
            newRootsToRegister = new HashSet<FileObject>();
        }
        for (Root root : allRoots) {
            File locF = root.getActualLocation();
            FileObject loc = locF != null ? FileUtil.toFileObject((File)locF) : null;
            if (loc == null || !loc.isFolder() || FileUtil.getRelativePath((FileObject)pdir, (FileObject)loc) != null) continue;
            try {
                Project other = ProjectManager.getDefault().findProject(loc);
                if (other != null) {
                }
            }
            catch (IOException e) {}
            continue;
            if (newRootsToRegister != null) {
                newRootsToRegister.add(loc);
                continue;
            }
            this.lastRegisteredRoots.add(loc);
            FileOwnerQuery.markExternalOwner((FileObject)loc, (Project)p, (int)this.registeredRootAlgorithm);
        }
        if (newRootsToRegister != null) {
            HashSet<FileObject> toUnregister = new HashSet<FileObject>(this.lastRegisteredRoots);
            toUnregister.removeAll(newRootsToRegister);
            for (FileObject loc : toUnregister) {
                FileOwnerQuery.markExternalOwner((FileObject)loc, null, (int)this.registeredRootAlgorithm);
            }
            newRootsToRegister.removeAll(this.lastRegisteredRoots);
            for (FileObject loc : newRootsToRegister) {
                FileOwnerQuery.markExternalOwner((FileObject)loc, (Project)p, (int)this.registeredRootAlgorithm);
            }
        }
    }

    public Sources createSources() {
        return new SourcesImpl();
    }

    private final class PropChangeL
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SourcesHelper.this.remarkExternalRoots();
        }
    }

    private final class SourcesImpl
    implements Sources,
    PropertyChangeListener,
    FileChangeListener {
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean haveAttachedListeners;
        private final Set<File> rootsListenedTo = new HashSet<File>();
        private final Map<String, List<URL>> lastComputedRoots = new HashMap<String, List<URL>>();

        public SourcesImpl() {
            SourcesHelper.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)SourcesHelper.this.evaluator));
        }

        public SourceGroup[] getSourceGroups(String type) {
            ArrayList<SourceGroup> groups = new ArrayList<SourceGroup>();
            if (type.equals("generic")) {
                ArrayList<SourceRoot> roots = new ArrayList<SourceRoot>(SourcesHelper.this.principalSourceRoots);
                roots.add(new SourceRoot("", ProjectUtils.getInformation((Project)SourcesHelper.this.getProject()).getDisplayName(), null, null));
                LinkedHashMap<FileObject, SourceRoot> rootsByDir = new LinkedHashMap<FileObject, SourceRoot>();
                for (SourceRoot r : roots) {
                    File locF = r.getActualLocation();
                    if (locF == null) continue;
                    this.listen(locF);
                    FileObject loc = FileUtil.toFileObject((File)locF);
                    if (loc == null || rootsByDir.containsKey(loc)) continue;
                    rootsByDir.put(loc, r);
                }
                Iterator it = rootsByDir.keySet().iterator();
                block3: while (it.hasNext()) {
                    FileObject loc = (FileObject)it.next();
                    for (FileObject parent = loc.getParent(); parent != null; parent = parent.getParent()) {
                        if (!rootsByDir.containsKey(parent)) continue;
                        it.remove();
                        continue block3;
                    }
                }
                for (Map.Entry entry : rootsByDir.entrySet()) {
                    groups.add(((SourceRoot)entry.getValue()).toGroup((FileObject)entry.getKey()));
                }
            } else {
                HashSet<FileObject> dirs = new HashSet<FileObject>();
                for (TypedSourceRoot r : SourcesHelper.this.typedSourceRoots) {
                    File locF;
                    if (!r.getType().equals(type) || (locF = r.getActualLocation()) == null) continue;
                    this.listen(locF);
                    FileObject loc = FileUtil.toFileObject((File)locF);
                    if (loc == null || !dirs.add(loc)) continue;
                    groups.add(r.toGroup(loc));
                }
            }
            ArrayList<URL> rootURLs = new ArrayList<URL>(groups.size());
            for (SourceGroup g : groups) {
                try {
                    rootURLs.add(g.getRootFolder().getURL());
                }
                catch (FileStateInvalidException e) {
                    assert (false) : e;
                }
            }
            this.lastComputedRoots.put(type, rootURLs);
            return groups.toArray(new SourceGroup[groups.size()]);
        }

        private synchronized void listen(File rootLocation) {
            if (this.rootsListenedTo.add(rootLocation) && this.haveAttachedListeners) {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)rootLocation);
            }
        }

        public synchronized void addChangeListener(ChangeListener listener) {
            if (!this.haveAttachedListeners) {
                this.haveAttachedListeners = true;
                for (File rootLocation : this.rootsListenedTo) {
                    FileUtil.addFileChangeListener((FileChangeListener)this, (File)rootLocation);
                }
            }
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        private void maybeFireChange() {
            boolean change = false;
            for (String type : new HashSet<String>(this.lastComputedRoots.keySet())) {
                ArrayList previous = new ArrayList(this.lastComputedRoots.get(type));
                this.getSourceGroups(type);
                List<URL> nue = this.lastComputedRoots.get(type);
                if (((Object)nue).equals(previous)) continue;
                change = true;
                break;
            }
            if (change) {
                this.cs.fireChange();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.maybeFireChange();
        }

        public void fileDataCreated(FileEvent fe) {
            this.maybeFireChange();
        }

        public void fileDeleted(FileEvent fe) {
            this.maybeFireChange();
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.maybeFireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.maybeFireChange();
        }
    }

    private final class TypedSourceRoot
    extends SourceRoot {
        private final String type;

        public TypedSourceRoot(String type, String location, String displayName, Icon icon, Icon openedIcon) {
            super(location, displayName, icon, openedIcon);
            this.type = type;
        }

        public final String getType() {
            return this.type;
        }
    }

    private class SourceRoot
    extends Root {
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;

        public SourceRoot(String location, String displayName, Icon icon, Icon openedIcon) {
            super(location);
            this.displayName = displayName;
            this.icon = icon;
            this.openedIcon = openedIcon;
        }

        public final SourceGroup toGroup(FileObject loc) {
            assert (loc != null);
            return GenericSources.group((Project)SourcesHelper.this.getProject(), (FileObject)loc, (String)(this.location.length() > 0 ? this.location : "generic"), (String)this.displayName, (Icon)this.icon, (Icon)this.openedIcon);
        }
    }

    private class Root {
        protected final String location;

        public Root(String location) {
            this.location = location;
        }

        public final File getActualLocation() {
            String val = SourcesHelper.this.evaluator.evaluate(this.location);
            if (val == null) {
                return null;
            }
            return SourcesHelper.this.project.resolveFile(val);
        }
    }
}

